/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.post.filters;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.post.Filter;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Texture2D;

public final class TranslucentBucketFilter
extends Filter {
    private RenderManager renderManager;

    protected void initFilter(AssetManager manager, RenderManager rm, ViewPort vp, int w, int h) {
        this.renderManager = rm;
        this.material = new Material(manager, "Common/MatDefs/Post/Overlay.j3md");
        this.material.setColor("Color", ColorRGBA.White);
        Texture2D tex = this.processor.getFilterTexture();
        this.material.setTexture("Texture", tex);
        if (tex.getImage().getMultiSamples() > 1) {
            this.material.setInt("NumSamples", tex.getImage().getMultiSamples());
        } else {
            this.material.clearParam("NumSamples");
        }
        this.renderManager.setHandleTranslucentBucket(false);
    }

    protected boolean isRequiresSceneTexture() {
        return false;
    }

    protected void postFrame(RenderManager renderManager, ViewPort viewPort, FrameBuffer prevFilterBuffer, FrameBuffer sceneBuffer) {
        renderManager.setCamera(viewPort.getCamera(), false);
        if (prevFilterBuffer != sceneBuffer) {
            renderManager.getRenderer().copyFrameBuffer(prevFilterBuffer, sceneBuffer, false);
        }
        renderManager.getRenderer().setFrameBuffer(sceneBuffer);
        viewPort.getQueue().renderQueue(RenderQueue.Bucket.Translucent, renderManager, viewPort.getCamera());
    }

    protected void cleanUpFilter(Renderer r) {
        if (this.renderManager != null) {
            this.renderManager.setHandleTranslucentBucket(true);
        }
    }

    protected Material getMaterial() {
        return this.material;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.renderManager != null) {
            this.renderManager.setHandleTranslucentBucket(!enabled);
        }
    }
}

