/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.serializing;

import com.jme3.math.Vector3f;
import com.jme3.network.message.ClientRegistrationMessage;
import com.jme3.network.message.DisconnectMessage;
import com.jme3.network.message.GZIPCompressedMessage;
import com.jme3.network.message.ZIPCompressedMessage;
import com.jme3.network.serializing.Serializable;
import com.jme3.network.serializing.SerializerException;
import com.jme3.network.serializing.SerializerRegistration;
import com.jme3.network.serializing.serializers.ArraySerializer;
import com.jme3.network.serializing.serializers.BooleanSerializer;
import com.jme3.network.serializing.serializers.ByteSerializer;
import com.jme3.network.serializing.serializers.CharSerializer;
import com.jme3.network.serializing.serializers.CollectionSerializer;
import com.jme3.network.serializing.serializers.DateSerializer;
import com.jme3.network.serializing.serializers.DoubleSerializer;
import com.jme3.network.serializing.serializers.EnumSerializer;
import com.jme3.network.serializing.serializers.FieldSerializer;
import com.jme3.network.serializing.serializers.FloatSerializer;
import com.jme3.network.serializing.serializers.GZIPSerializer;
import com.jme3.network.serializing.serializers.IntSerializer;
import com.jme3.network.serializing.serializers.LongSerializer;
import com.jme3.network.serializing.serializers.MapSerializer;
import com.jme3.network.serializing.serializers.SerializableSerializer;
import com.jme3.network.serializing.serializers.ShortSerializer;
import com.jme3.network.serializing.serializers.StringSerializer;
import com.jme3.network.serializing.serializers.Vector3Serializer;
import com.jme3.network.serializing.serializers.ZIPSerializer;
import java.awt.RenderingHints;
import java.beans.beancontext.BeanContextServicesSupport;
import java.beans.beancontext.BeanContextSupport;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.jar.Attributes;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Serializer {
    protected static final Logger log = Logger.getLogger(Serializer.class.getName());
    private static final SerializerRegistration NULL_CLASS = new SerializerRegistration(null, Void.class, -1);
    private static final Map<Short, SerializerRegistration> idRegistrations = new HashMap<Short, SerializerRegistration>();
    private static final Map<Class, SerializerRegistration> classRegistrations = new HashMap<Class, SerializerRegistration>();
    private static final Serializer fieldSerializer = new FieldSerializer();
    private static final Serializer serializableSerializer = new SerializableSerializer();
    private static final Serializer arraySerializer = new ArraySerializer();
    private static short nextId = (short)-1;
    private static boolean strictRegistration = true;

    public static void setStrictRegistration(boolean b) {
        strictRegistration = b;
    }

    public static SerializerRegistration registerClass(Class cls) {
        return Serializer.registerClass(cls, true);
    }

    public static void registerClasses(Class ... classes) {
        for (Class c : classes) {
            Serializer.registerClass(c);
        }
    }

    public static SerializerRegistration registerClass(Class cls, boolean failOnMiss) {
        if (cls.isAnnotationPresent(Serializable.class)) {
            SerializerRegistration existingReg;
            Serializer serializer;
            Serializable serializable = cls.getAnnotation(Serializable.class);
            Class serializerClass = serializable.serializer();
            short classId = serializable.id();
            if (classId == 0) {
                classId = nextId = (short)(nextId - 1);
            }
            if ((serializer = Serializer.getSerializer(serializerClass, false)) == null) {
                serializer = fieldSerializer;
            }
            if ((existingReg = Serializer.getExactSerializerRegistration(cls)) != null) {
                classId = existingReg.getId();
            }
            SerializerRegistration reg = new SerializerRegistration(serializer, cls, classId);
            idRegistrations.put(classId, reg);
            classRegistrations.put(cls, reg);
            serializer.initialize(cls);
            log.log(Level.INFO, "Registered class[" + classId + "]:{0}.", cls);
            return reg;
        }
        if (failOnMiss) {
            throw new IllegalArgumentException("Class is not marked @Serializable:" + cls);
        }
        return null;
    }

    @Deprecated
    public static SerializerRegistration[] registerPackage(String pkgName) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            String path = pkgName.replace('.', '/');
            Enumeration<URL> resources = classLoader.getResources(path);
            ArrayList<File> dirs = new ArrayList<File>();
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                dirs.add(new File(resource.getFile()));
            }
            ArrayList<Class> classes = new ArrayList<Class>();
            for (File directory : dirs) {
                classes.addAll(Serializer.findClasses(directory, pkgName));
            }
            SerializerRegistration[] registeredClasses = new SerializerRegistration[classes.size()];
            for (int i = 0; i != classes.size(); ++i) {
                Class clz = (Class)classes.get(i);
                registeredClasses[i] = Serializer.registerClass(clz, false);
            }
            return registeredClasses;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new SerializerRegistration[0];
        }
    }

    private static List<Class> findClasses(File dir, String pkgName) throws ClassNotFoundException {
        File[] files;
        ArrayList<Class> classes = new ArrayList<Class>();
        if (!dir.exists()) {
            return classes;
        }
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(Serializer.findClasses(file, pkgName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(Class.forName(pkgName + '.' + file.getName().substring(0, file.getName().length() - 6)));
        }
        return classes;
    }

    public static SerializerRegistration registerClass(Class cls, Serializer serializer) {
        SerializerRegistration existingReg = Serializer.getExactSerializerRegistration(cls);
        short id = existingReg != null ? existingReg.getId() : (nextId = (short)(nextId - 1));
        SerializerRegistration reg = new SerializerRegistration(serializer, cls, id);
        idRegistrations.put(id, reg);
        classRegistrations.put(cls, reg);
        log.log(Level.INFO, "Registered class[" + id + "]:{0} to:" + serializer, cls);
        serializer.initialize(cls);
        return reg;
    }

    public static Serializer getExactSerializer(Class cls) {
        return classRegistrations.get(cls).getSerializer();
    }

    public static Serializer getSerializer(Class cls) {
        return Serializer.getSerializer(cls, true);
    }

    public static Serializer getSerializer(Class cls, boolean failOnMiss) {
        return Serializer.getSerializerRegistration(cls, failOnMiss).getSerializer();
    }

    public static SerializerRegistration getExactSerializerRegistration(Class cls) {
        return classRegistrations.get(cls);
    }

    public static SerializerRegistration getSerializerRegistration(Class cls) {
        return Serializer.getSerializerRegistration(cls, strictRegistration);
    }

    public static SerializerRegistration getSerializerRegistration(Class cls, boolean failOnMiss) {
        Serializable serializable;
        short classId;
        SerializerRegistration reg = classRegistrations.get(cls);
        if (reg != null) {
            return reg;
        }
        for (Map.Entry<Class, SerializerRegistration> entry : classRegistrations.entrySet()) {
            if (entry.getKey().isAssignableFrom(Serializable.class) || !entry.getKey().isAssignableFrom(cls)) continue;
            return entry.getValue();
        }
        if (cls.isArray()) {
            return Serializer.registerClass(cls, arraySerializer);
        }
        if (Serializable.class.isAssignableFrom(cls)) {
            return Serializer.getExactSerializerRegistration(java.io.Serializable.class);
        }
        if (cls.isAnnotationPresent(Serializable.class) && (classId = (serializable = cls.getAnnotation(Serializable.class)).id()) != 0) {
            failOnMiss = false;
        }
        if (failOnMiss) {
            throw new IllegalArgumentException("Class has not been registered:" + cls);
        }
        return Serializer.registerClass(cls, fieldSerializer);
    }

    public static SerializerRegistration readClass(ByteBuffer buffer) {
        short classID = buffer.getShort();
        if (classID == -1) {
            return NULL_CLASS;
        }
        return idRegistrations.get(classID);
    }

    public static Object readClassAndObject(ByteBuffer buffer) throws IOException {
        SerializerRegistration reg = Serializer.readClass(buffer);
        if (reg == NULL_CLASS) {
            return null;
        }
        if (reg == null) {
            throw new SerializerException("Class not found for buffer data.");
        }
        return reg.getSerializer().readObject(buffer, reg.getType());
    }

    public static SerializerRegistration writeClass(ByteBuffer buffer, Class type) throws IOException {
        SerializerRegistration reg = Serializer.getSerializerRegistration(type);
        if (reg == null) {
            throw new SerializerException("Class not registered:" + type);
        }
        buffer.putShort(reg.getId());
        return reg;
    }

    public static void writeClassAndObject(ByteBuffer buffer, Object object) throws IOException {
        if (object == null) {
            buffer.putShort((short)-1);
            return;
        }
        SerializerRegistration reg = Serializer.writeClass(buffer, object.getClass());
        reg.getSerializer().writeObject(buffer, object);
    }

    public abstract <T> T readObject(ByteBuffer var1, Class<T> var2) throws IOException;

    public abstract void writeObject(ByteBuffer var1, Object var2) throws IOException;

    public void initialize(Class clazz) {
    }

    static {
        Serializer.registerClass(Boolean.TYPE, new BooleanSerializer());
        Serializer.registerClass(Byte.TYPE, new ByteSerializer());
        Serializer.registerClass(Character.TYPE, new CharSerializer());
        Serializer.registerClass(Short.TYPE, new ShortSerializer());
        Serializer.registerClass(Integer.TYPE, new IntSerializer());
        Serializer.registerClass(Long.TYPE, new LongSerializer());
        Serializer.registerClass(Float.TYPE, new FloatSerializer());
        Serializer.registerClass(Double.TYPE, new DoubleSerializer());
        Serializer.registerClass(Boolean.class, new BooleanSerializer());
        Serializer.registerClass(Byte.class, new ByteSerializer());
        Serializer.registerClass(Character.class, new CharSerializer());
        Serializer.registerClass(Short.class, new ShortSerializer());
        Serializer.registerClass(Integer.class, new IntSerializer());
        Serializer.registerClass(Long.class, new LongSerializer());
        Serializer.registerClass(Float.class, new FloatSerializer());
        Serializer.registerClass(Double.class, new DoubleSerializer());
        Serializer.registerClass(String.class, new StringSerializer());
        Serializer.registerClass(Vector3f.class, new Vector3Serializer());
        Serializer.registerClass(Date.class, new DateSerializer());
        Serializer.registerClass(AbstractCollection.class, new CollectionSerializer());
        Serializer.registerClass(AbstractList.class, new CollectionSerializer());
        Serializer.registerClass(AbstractSet.class, new CollectionSerializer());
        Serializer.registerClass(ArrayList.class, new CollectionSerializer());
        Serializer.registerClass(BeanContextServicesSupport.class, new CollectionSerializer());
        Serializer.registerClass(BeanContextSupport.class, new CollectionSerializer());
        Serializer.registerClass(HashSet.class, new CollectionSerializer());
        Serializer.registerClass(LinkedHashSet.class, new CollectionSerializer());
        Serializer.registerClass(LinkedList.class, new CollectionSerializer());
        Serializer.registerClass(TreeSet.class, new CollectionSerializer());
        Serializer.registerClass(Vector.class, new CollectionSerializer());
        Serializer.registerClass(AbstractMap.class, new MapSerializer());
        Serializer.registerClass(Attributes.class, new MapSerializer());
        Serializer.registerClass(HashMap.class, new MapSerializer());
        Serializer.registerClass(Hashtable.class, new MapSerializer());
        Serializer.registerClass(IdentityHashMap.class, new MapSerializer());
        Serializer.registerClass(RenderingHints.class, new MapSerializer());
        Serializer.registerClass(TreeMap.class, new MapSerializer());
        Serializer.registerClass(WeakHashMap.class, new MapSerializer());
        Serializer.registerClass(Enum.class, new EnumSerializer());
        Serializer.registerClass(GZIPCompressedMessage.class, new GZIPSerializer());
        Serializer.registerClass(ZIPCompressedMessage.class, new ZIPSerializer());
        Serializer.registerClass(DisconnectMessage.class);
        Serializer.registerClass(ClientRegistrationMessage.class);
    }
}

