/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.cinematic.events;

import com.jme3.animation.LoopMode;
import com.jme3.app.Application;
import com.jme3.audio.AudioNode;
import com.jme3.cinematic.Cinematic;
import com.jme3.cinematic.events.AbstractCinematicEvent;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import java.io.IOException;

public class SoundTrack
extends AbstractCinematicEvent {
    protected String path;
    protected AudioNode audioNode;
    protected boolean stream = false;

    public SoundTrack(String path) {
        this.path = path;
    }

    public SoundTrack(String path, boolean stream) {
        this(path);
        this.stream = stream;
    }

    public SoundTrack(String path, boolean stream, float initialDuration) {
        super(initialDuration);
        this.path = path;
        this.stream = stream;
    }

    public SoundTrack(String path, boolean stream, LoopMode loopMode) {
        super(loopMode);
        this.path = path;
        this.stream = stream;
    }

    public SoundTrack(String path, boolean stream, float initialDuration, LoopMode loopMode) {
        super(initialDuration, loopMode);
        this.path = path;
        this.stream = stream;
    }

    public SoundTrack(String path, float initialDuration) {
        super(initialDuration);
        this.path = path;
    }

    public SoundTrack(String path, LoopMode loopMode) {
        super(loopMode);
        this.path = path;
    }

    public SoundTrack(String path, float initialDuration, LoopMode loopMode) {
        super(initialDuration, loopMode);
        this.path = path;
    }

    public SoundTrack() {
    }

    public void initEvent(Application app, Cinematic cinematic) {
        super.initEvent(app, cinematic);
        this.audioNode = new AudioNode(app.getAssetManager(), this.path, this.stream);
        this.setLoopMode(this.loopMode);
    }

    public void onPlay() {
        this.audioNode.play();
    }

    public void onStop() {
        this.audioNode.stop();
    }

    public void onPause() {
        this.audioNode.pause();
    }

    public void onUpdate(float tpf) {
        if (this.audioNode.getStatus() == AudioNode.Status.Stopped) {
            this.stop();
        }
    }

    public AudioNode getAudioNode() {
        return this.audioNode;
    }

    public void setLoopMode(LoopMode loopMode) {
        super.setLoopMode(loopMode);
        if (loopMode != LoopMode.DontLoop) {
            this.audioNode.setLooping(true);
        } else {
            this.audioNode.setLooping(false);
        }
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.path, "path", "");
        oc.write(this.stream, "stream", false);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.path = ic.readString("path", "");
        this.stream = ic.readBoolean("stream", false);
    }
}

