/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.audio.lwjgl;

import com.jme3.audio.AudioBuffer;
import com.jme3.audio.AudioData;
import com.jme3.audio.AudioNode;
import com.jme3.audio.AudioParam;
import com.jme3.audio.AudioRenderer;
import com.jme3.audio.AudioStream;
import com.jme3.audio.Environment;
import com.jme3.audio.Filter;
import com.jme3.audio.Listener;
import com.jme3.audio.ListenerParam;
import com.jme3.audio.LowPassFilter;
import com.jme3.math.Vector3f;
import com.jme3.util.BufferUtils;
import com.jme3.util.NativeObjectManager;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.LWJGLException;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.AL11;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCdevice;
import org.lwjgl.openal.EFX10;
import org.lwjgl.openal.OpenALException;

public class LwjglAudioRenderer
implements AudioRenderer,
Runnable {
    private static final Logger logger = Logger.getLogger(LwjglAudioRenderer.class.getName());
    private final NativeObjectManager objManager = new NativeObjectManager();
    private static final int BUFFER_SIZE = 35280;
    private static final int STREAMING_BUFFER_COUNT = 5;
    private static final int MAX_NUM_CHANNELS = 64;
    private IntBuffer ib = BufferUtils.createIntBuffer(1);
    private final FloatBuffer fb = BufferUtils.createVector3Buffer(2);
    private final ByteBuffer nativeBuf = BufferUtils.createByteBuffer(35280);
    private final byte[] arrayBuf = new byte[35280];
    private int[] channels;
    private AudioNode[] chanSrcs;
    private int nextChan = 0;
    private ArrayList<Integer> freeChans = new ArrayList();
    private Listener listener;
    private boolean audioDisabled = false;
    private boolean supportEfx = false;
    private int auxSends = 0;
    private int reverbFx = -1;
    private int reverbFxSlot = -1;
    private static final float UPDATE_RATE = 0.05f;
    private final Thread audioThread = new Thread((Runnable)this, "jME3 Audio Thread");
    private final AtomicBoolean threadLock = new AtomicBoolean(false);

    public void initialize() {
        if (this.audioThread.isAlive()) {
            throw new IllegalStateException("Initialize already called");
        }
        this.audioThread.setDaemon(true);
        this.audioThread.setPriority(6);
        this.audioThread.start();
    }

    private void checkDead() {
        if (this.audioThread.getState() == Thread.State.TERMINATED) {
            throw new IllegalStateException("Audio thread is terminated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        this.initInThread();
        var1_1 = this.threadLock;
        synchronized (var1_1) {
            this.threadLock.set(true);
            this.threadLock.notifyAll();
        }
        updateRateNanos = 50000000L;
        block11: while (true) {
            startTime = System.nanoTime();
            if (Thread.interrupted()) break;
            var5_7 = this.threadLock;
            synchronized (var5_7) {
                this.updateInThread(0.05f);
            }
            endTime = System.nanoTime();
            diffTime = endTime - startTime;
            if (diffTime >= updateRateNanos) continue;
            desiredEndTime = startTime + updateRateNanos;
            while (true) {
                if (System.nanoTime() < desiredEndTime) ** break;
                continue block11;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ex) {
                    break block11;
                }
            }
            break;
        }
        var3_5 = this.threadLock;
        synchronized (var3_5) {
            this.cleanupInThread();
        }
    }

    public void initInThread() {
        int i;
        try {
            if (!AL.isCreated()) {
                AL.create();
            }
        }
        catch (OpenALException ex) {
            logger.log(Level.SEVERE, "Failed to load audio library", ex);
            this.audioDisabled = true;
            return;
        }
        catch (LWJGLException ex) {
            logger.log(Level.SEVERE, "Failed to load audio library", ex);
            this.audioDisabled = true;
            return;
        }
        catch (UnsatisfiedLinkError ex) {
            logger.log(Level.SEVERE, "Failed to load audio library", ex);
            this.audioDisabled = true;
            return;
        }
        ALCdevice device = AL.getDevice();
        String deviceName = ALC10.alcGetString((ALCdevice)device, (int)4101);
        logger.log(Level.FINER, "Audio Device: {0}", deviceName);
        logger.log(Level.FINER, "Audio Vendor: {0}", AL10.alGetString((int)45057));
        logger.log(Level.FINER, "Audio Renderer: {0}", AL10.alGetString((int)45059));
        logger.log(Level.FINER, "Audio Version: {0}", AL10.alGetString((int)45058));
        ArrayList<Integer> channelList = new ArrayList<Integer>();
        for (i = 0; i < 64; ++i) {
            int chan = AL10.alGenSources();
            if (AL10.alGetError() != 0) break;
            channelList.add(chan);
        }
        this.channels = new int[channelList.size()];
        for (i = 0; i < this.channels.length; ++i) {
            this.channels[i] = (Integer)channelList.get(i);
        }
        this.ib = BufferUtils.createIntBuffer(this.channels.length);
        this.chanSrcs = new AudioNode[this.channels.length];
        logger.log(Level.INFO, "AudioRenderer supports {0} channels", this.channels.length);
        this.supportEfx = ALC10.alcIsExtensionPresent((ALCdevice)device, (String)"ALC_EXT_EFX");
        if (this.supportEfx) {
            this.ib.position(0).limit(1);
            ALC10.alcGetInteger((ALCdevice)device, (int)131073, (IntBuffer)this.ib);
            int major = this.ib.get(0);
            this.ib.position(0).limit(1);
            ALC10.alcGetInteger((ALCdevice)device, (int)131074, (IntBuffer)this.ib);
            int minor = this.ib.get(0);
            logger.log(Level.INFO, "Audio effect extension version: {0}.{1}", new Object[]{major, minor});
            ALC10.alcGetInteger((ALCdevice)device, (int)131075, (IntBuffer)this.ib);
            this.auxSends = this.ib.get(0);
            logger.log(Level.INFO, "Audio max auxilary sends: {0}", this.auxSends);
            this.ib.position(0).limit(1);
            EFX10.alGenAuxiliaryEffectSlots((IntBuffer)this.ib);
            this.reverbFxSlot = this.ib.get(0);
            this.ib.position(0).limit(1);
            EFX10.alGenEffects((IntBuffer)this.ib);
            this.reverbFx = this.ib.get(0);
            EFX10.alEffecti((int)this.reverbFx, (int)32769, (int)1);
            EFX10.alAuxiliaryEffectSloti((int)this.reverbFxSlot, (int)1, (int)this.reverbFx);
        } else {
            logger.log(Level.WARNING, "OpenAL EFX not available! Audio effects won't work.");
        }
    }

    public void cleanupInThread() {
        if (this.audioDisabled) {
            AL.destroy();
            return;
        }
        for (int i = 0; i < this.chanSrcs.length; ++i) {
            if (this.chanSrcs[i] == null) continue;
            this.clearChannel(i);
        }
        this.ib.clear();
        this.ib.put(this.channels);
        this.ib.flip();
        AL10.alDeleteSources((IntBuffer)this.ib);
        this.objManager.deleteAllObjects(this);
        if (this.supportEfx) {
            this.ib.position(0).limit(1);
            this.ib.put(0, this.reverbFx);
            EFX10.alDeleteEffects((IntBuffer)this.ib);
            this.ib.position(0).limit(1);
            this.ib.put(0, this.reverbFxSlot);
            EFX10.alDeleteAuxiliaryEffectSlots((IntBuffer)this.ib);
        }
        AL.destroy();
    }

    public void cleanup() {
        if (this.audioThread.isAlive()) {
            this.audioThread.interrupt();
        }
    }

    private void updateFilter(Filter f) {
        int id = f.getId();
        if (id == -1) {
            this.ib.position(0).limit(1);
            EFX10.alGenFilters((IntBuffer)this.ib);
            id = this.ib.get(0);
            f.setId(id);
            this.objManager.registerForCleanup(f);
        }
        if (!(f instanceof LowPassFilter)) {
            throw new UnsupportedOperationException("Filter type unsupported: " + f.getClass().getName());
        }
        LowPassFilter lpf = (LowPassFilter)f;
        EFX10.alFilteri((int)id, (int)32769, (int)1);
        EFX10.alFilterf((int)id, (int)1, (float)lpf.getVolume());
        EFX10.alFilterf((int)id, (int)2, (float)lpf.getHighFreqVolume());
        f.clearUpdateNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSourceParam(AudioNode src, AudioParam param) {
        this.checkDead();
        AtomicBoolean atomicBoolean = this.threadLock;
        synchronized (atomicBoolean) {
            while (!this.threadLock.get()) {
                try {
                    this.threadLock.wait();
                }
                catch (InterruptedException ex) {}
            }
            if (this.audioDisabled) {
                return;
            }
            if (src.getChannel() < 0) {
                return;
            }
            assert (src.getChannel() >= 0);
            int id = this.channels[src.getChannel()];
            switch (param) {
                case Position: {
                    if (!src.isPositional()) {
                        return;
                    }
                    Vector3f pos = src.getWorldTranslation();
                    AL10.alSource3f((int)id, (int)4100, (float)pos.x, (float)pos.y, (float)pos.z);
                    break;
                }
                case Velocity: {
                    if (!src.isPositional()) {
                        return;
                    }
                    Vector3f vel = src.getVelocity();
                    AL10.alSource3f((int)id, (int)4102, (float)vel.x, (float)vel.y, (float)vel.z);
                    break;
                }
                case MaxDistance: {
                    if (!src.isPositional()) {
                        return;
                    }
                    AL10.alSourcef((int)id, (int)4131, (float)src.getMaxDistance());
                    break;
                }
                case RefDistance: {
                    if (!src.isPositional()) {
                        return;
                    }
                    AL10.alSourcef((int)id, (int)4128, (float)src.getRefDistance());
                    break;
                }
                case ReverbFilter: {
                    if (!(this.supportEfx && src.isPositional() && src.isReverbEnabled())) {
                        return;
                    }
                    int filter = 0;
                    if (src.getReverbFilter() != null) {
                        Filter f = src.getReverbFilter();
                        if (f.isUpdateNeeded()) {
                            this.updateFilter(f);
                        }
                        filter = f.getId();
                    }
                    AL11.alSource3i((int)id, (int)131078, (int)this.reverbFxSlot, (int)0, (int)filter);
                    break;
                }
                case ReverbEnabled: {
                    if (!this.supportEfx || !src.isPositional()) {
                        return;
                    }
                    if (src.isReverbEnabled()) {
                        this.updateSourceParam(src, AudioParam.ReverbFilter);
                        break;
                    }
                    AL11.alSource3i((int)id, (int)131078, (int)0, (int)0, (int)0);
                    break;
                }
                case IsPositional: {
                    if (!src.isPositional()) {
                        AL10.alSourcei((int)id, (int)514, (int)1);
                        AL10.alSource3f((int)id, (int)4100, (float)0.0f, (float)0.0f, (float)0.0f);
                        AL10.alSource3f((int)id, (int)4102, (float)0.0f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    AL10.alSourcei((int)id, (int)514, (int)0);
                    this.updateSourceParam(src, AudioParam.Position);
                    this.updateSourceParam(src, AudioParam.Velocity);
                    this.updateSourceParam(src, AudioParam.MaxDistance);
                    this.updateSourceParam(src, AudioParam.RefDistance);
                    this.updateSourceParam(src, AudioParam.ReverbEnabled);
                    break;
                }
                case Direction: {
                    if (!src.isDirectional()) {
                        return;
                    }
                    Vector3f dir = src.getDirection();
                    AL10.alSource3f((int)id, (int)4101, (float)dir.x, (float)dir.y, (float)dir.z);
                    break;
                }
                case InnerAngle: {
                    if (!src.isDirectional()) {
                        return;
                    }
                    AL10.alSourcef((int)id, (int)4097, (float)src.getInnerAngle());
                    break;
                }
                case OuterAngle: {
                    if (!src.isDirectional()) {
                        return;
                    }
                    AL10.alSourcef((int)id, (int)4098, (float)src.getOuterAngle());
                    break;
                }
                case IsDirectional: {
                    if (src.isDirectional()) {
                        this.updateSourceParam(src, AudioParam.Direction);
                        this.updateSourceParam(src, AudioParam.InnerAngle);
                        this.updateSourceParam(src, AudioParam.OuterAngle);
                        AL10.alSourcef((int)id, (int)4130, (float)0.0f);
                        break;
                    }
                    AL10.alSourcef((int)id, (int)4097, (float)360.0f);
                    AL10.alSourcef((int)id, (int)4098, (float)360.0f);
                    AL10.alSourcef((int)id, (int)4130, (float)1.0f);
                    break;
                }
                case DryFilter: {
                    if (!this.supportEfx) {
                        return;
                    }
                    if (src.getDryFilter() != null) {
                        Filter f = src.getDryFilter();
                        if (!f.isUpdateNeeded()) break;
                        this.updateFilter(f);
                        AL10.alSourcei((int)id, (int)131077, (int)f.getId());
                        break;
                    }
                    AL10.alSourcei((int)id, (int)131077, (int)0);
                    break;
                }
                case Looping: {
                    if (src.isLooping()) {
                        if (src.getAudioData() instanceof AudioStream) break;
                        AL10.alSourcei((int)id, (int)4103, (int)1);
                        break;
                    }
                    AL10.alSourcei((int)id, (int)4103, (int)0);
                    break;
                }
                case Volume: {
                    AL10.alSourcef((int)id, (int)4106, (float)src.getVolume());
                    break;
                }
                case Pitch: {
                    AL10.alSourcef((int)id, (int)4099, (float)src.getPitch());
                }
            }
        }
    }

    private void setSourceParams(int id, AudioNode src, boolean forceNonLoop) {
        Filter f;
        if (src.isPositional()) {
            Vector3f pos = src.getWorldTranslation();
            Vector3f vel = src.getVelocity();
            AL10.alSource3f((int)id, (int)4100, (float)pos.x, (float)pos.y, (float)pos.z);
            AL10.alSource3f((int)id, (int)4102, (float)vel.x, (float)vel.y, (float)vel.z);
            AL10.alSourcef((int)id, (int)4131, (float)src.getMaxDistance());
            AL10.alSourcef((int)id, (int)4128, (float)src.getRefDistance());
            AL10.alSourcei((int)id, (int)514, (int)0);
            if (src.isReverbEnabled() && this.supportEfx) {
                int filter = 0;
                if (src.getReverbFilter() != null) {
                    Filter f2 = src.getReverbFilter();
                    if (f2.isUpdateNeeded()) {
                        this.updateFilter(f2);
                    }
                    filter = f2.getId();
                }
                AL11.alSource3i((int)id, (int)131078, (int)this.reverbFxSlot, (int)0, (int)filter);
            }
        } else {
            AL10.alSourcei((int)id, (int)514, (int)1);
            AL10.alSource3f((int)id, (int)4100, (float)0.0f, (float)0.0f, (float)0.0f);
            AL10.alSource3f((int)id, (int)4102, (float)0.0f, (float)0.0f, (float)0.0f);
        }
        if (src.getDryFilter() != null && this.supportEfx && (f = src.getDryFilter()).isUpdateNeeded()) {
            this.updateFilter(f);
            AL10.alSourcei((int)id, (int)131077, (int)f.getId());
        }
        if (forceNonLoop) {
            AL10.alSourcei((int)id, (int)4103, (int)0);
        } else {
            AL10.alSourcei((int)id, (int)4103, (int)(src.isLooping() ? 1 : 0));
        }
        AL10.alSourcef((int)id, (int)4106, (float)src.getVolume());
        AL10.alSourcef((int)id, (int)4099, (float)src.getPitch());
        AL10.alSourcef((int)id, (int)4132, (float)src.getTimeOffset());
        if (src.isDirectional()) {
            Vector3f dir = src.getDirection();
            AL10.alSource3f((int)id, (int)4101, (float)dir.x, (float)dir.y, (float)dir.z);
            AL10.alSourcef((int)id, (int)4097, (float)src.getInnerAngle());
            AL10.alSourcef((int)id, (int)4098, (float)src.getOuterAngle());
            AL10.alSourcef((int)id, (int)4130, (float)0.0f);
        } else {
            AL10.alSourcef((int)id, (int)4097, (float)360.0f);
            AL10.alSourcef((int)id, (int)4098, (float)360.0f);
            AL10.alSourcef((int)id, (int)4130, (float)1.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateListenerParam(Listener listener, ListenerParam param) {
        this.checkDead();
        AtomicBoolean atomicBoolean = this.threadLock;
        synchronized (atomicBoolean) {
            while (!this.threadLock.get()) {
                try {
                    this.threadLock.wait();
                }
                catch (InterruptedException ex) {}
            }
            if (this.audioDisabled) {
                return;
            }
            switch (param) {
                case Position: {
                    Vector3f pos = listener.getLocation();
                    AL10.alListener3f((int)4100, (float)pos.x, (float)pos.y, (float)pos.z);
                    break;
                }
                case Rotation: {
                    Vector3f dir = listener.getDirection();
                    Vector3f up = listener.getUp();
                    this.fb.rewind();
                    this.fb.put(dir.x).put(dir.y).put(dir.z);
                    this.fb.put(up.x).put(up.y).put(up.z);
                    this.fb.flip();
                    AL10.alListener((int)4111, (FloatBuffer)this.fb);
                    break;
                }
                case Velocity: {
                    Vector3f vel = listener.getVelocity();
                    AL10.alListener3f((int)4102, (float)vel.x, (float)vel.y, (float)vel.z);
                    break;
                }
                case Volume: {
                    AL10.alListenerf((int)4106, (float)listener.getVolume());
                }
            }
        }
    }

    private void setListenerParams(Listener listener) {
        Vector3f pos = listener.getLocation();
        Vector3f vel = listener.getVelocity();
        Vector3f dir = listener.getDirection();
        Vector3f up = listener.getUp();
        AL10.alListener3f((int)4100, (float)pos.x, (float)pos.y, (float)pos.z);
        AL10.alListener3f((int)4102, (float)vel.x, (float)vel.y, (float)vel.z);
        this.fb.rewind();
        this.fb.put(dir.x).put(dir.y).put(dir.z);
        this.fb.put(up.x).put(up.y).put(up.z);
        this.fb.flip();
        AL10.alListener((int)4111, (FloatBuffer)this.fb);
        AL10.alListenerf((int)4106, (float)listener.getVolume());
    }

    private int newChannel() {
        if (this.freeChans.size() > 0) {
            return this.freeChans.remove(0);
        }
        if (this.nextChan < this.channels.length) {
            return this.nextChan++;
        }
        return -1;
    }

    private void freeChannel(int index) {
        if (index == this.nextChan - 1) {
            --this.nextChan;
        } else {
            this.freeChans.add(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnvironment(Environment env) {
        this.checkDead();
        AtomicBoolean atomicBoolean = this.threadLock;
        synchronized (atomicBoolean) {
            while (!this.threadLock.get()) {
                try {
                    this.threadLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.audioDisabled || !this.supportEfx) {
                return;
            }
            EFX10.alEffectf((int)this.reverbFx, (int)1, (float)env.getDensity());
            EFX10.alEffectf((int)this.reverbFx, (int)2, (float)env.getDiffusion());
            EFX10.alEffectf((int)this.reverbFx, (int)3, (float)env.getGain());
            EFX10.alEffectf((int)this.reverbFx, (int)4, (float)env.getGainHf());
            EFX10.alEffectf((int)this.reverbFx, (int)5, (float)env.getDecayTime());
            EFX10.alEffectf((int)this.reverbFx, (int)6, (float)env.getDecayHFRatio());
            EFX10.alEffectf((int)this.reverbFx, (int)7, (float)env.getReflectGain());
            EFX10.alEffectf((int)this.reverbFx, (int)8, (float)env.getReflectDelay());
            EFX10.alEffectf((int)this.reverbFx, (int)9, (float)env.getLateReverbGain());
            EFX10.alEffectf((int)this.reverbFx, (int)10, (float)env.getLateReverbDelay());
            EFX10.alEffectf((int)this.reverbFx, (int)11, (float)env.getAirAbsorbGainHf());
            EFX10.alEffectf((int)this.reverbFx, (int)12, (float)env.getRoomRolloffFactor());
            EFX10.alAuxiliaryEffectSloti((int)this.reverbFxSlot, (int)1, (int)this.reverbFx);
        }
    }

    private boolean fillBuffer(AudioStream stream, int id) {
        int size;
        int result;
        for (size = 0; size < this.arrayBuf.length && (result = stream.readSamples(this.arrayBuf, size, this.arrayBuf.length - size)) > 0; size += result) {
        }
        if (size == 0) {
            return false;
        }
        this.nativeBuf.clear();
        this.nativeBuf.put(this.arrayBuf, 0, size);
        this.nativeBuf.flip();
        AL10.alBufferData((int)id, (int)this.convertFormat(stream), (ByteBuffer)this.nativeBuf, (int)stream.getSampleRate());
        return true;
    }

    private boolean fillStreamingSource(int sourceId, AudioStream stream) {
        if (!stream.isOpen()) {
            return false;
        }
        boolean active = true;
        int processed = AL10.alGetSourcei((int)sourceId, (int)4118);
        if (processed > 0) {
            this.ib.position(0).limit(1);
            AL10.alSourceUnqueueBuffers((int)sourceId, (IntBuffer)this.ib);
            int buffer = this.ib.get(0);
            active = this.fillBuffer(stream, buffer);
            this.ib.position(0).limit(1);
            this.ib.put(0, buffer);
            AL10.alSourceQueueBuffers((int)sourceId, (IntBuffer)this.ib);
        }
        if (!active && stream.isOpen()) {
            stream.close();
        }
        return active;
    }

    private boolean attachStreamToSource(int sourceId, AudioStream stream) {
        boolean active = true;
        for (int id : stream.getIds()) {
            active = this.fillBuffer(stream, id);
            this.ib.position(0).limit(1);
            this.ib.put(id).flip();
            AL10.alSourceQueueBuffers((int)sourceId, (IntBuffer)this.ib);
        }
        return active;
    }

    private boolean attachBufferToSource(int sourceId, AudioBuffer buffer) {
        AL10.alSourcei((int)sourceId, (int)4105, (int)buffer.getId());
        return true;
    }

    private boolean attachAudioToSource(int sourceId, AudioData data) {
        if (data instanceof AudioBuffer) {
            return this.attachBufferToSource(sourceId, (AudioBuffer)data);
        }
        if (data instanceof AudioStream) {
            return this.attachStreamToSource(sourceId, (AudioStream)data);
        }
        throw new UnsupportedOperationException();
    }

    private void clearChannel(int index) {
        if (this.chanSrcs[index] != null) {
            AudioNode pas;
            AudioNode src = this.chanSrcs[index];
            int sourceId = this.channels[index];
            AL10.alSourceStop((int)sourceId);
            if (src.getAudioData() instanceof AudioStream) {
                AudioStream str = (AudioStream)src.getAudioData();
                this.ib.position(0).limit(5);
                this.ib.put(str.getIds()).flip();
                AL10.alSourceUnqueueBuffers((int)sourceId, (IntBuffer)this.ib);
            } else if (src.getAudioData() instanceof AudioBuffer) {
                AL10.alSourcei((int)sourceId, (int)4105, (int)0);
            }
            if (src.getDryFilter() != null && this.supportEfx) {
                AL10.alSourcei((int)sourceId, (int)131077, (int)0);
            }
            if (src.isPositional() && (pas = src).isReverbEnabled() && this.supportEfx) {
                AL11.alSource3i((int)sourceId, (int)131078, (int)0, (int)0, (int)0);
            }
            this.chanSrcs[index] = null;
        }
    }

    public void update(float tpf) {
    }

    public void updateInThread(float tpf) {
        if (this.audioDisabled) {
            return;
        }
        for (int i = 0; i < this.channels.length; ++i) {
            boolean paused;
            boolean stopped;
            AudioNode src = this.chanSrcs[i];
            if (src == null) continue;
            int sourceId = this.channels[i];
            boolean boundSource = i == src.getChannel();
            boolean streaming = src.getAudioData() instanceof AudioStream;
            assert (boundSource && streaming || !streaming);
            int state = AL10.alGetSourcei((int)sourceId, (int)4112);
            boolean wantPlaying = src.getStatus() == AudioNode.Status.Playing;
            boolean bl = stopped = state == 4116;
            if (streaming && wantPlaying) {
                AudioStream stream = (AudioStream)src.getAudioData();
                if (stream.isOpen()) {
                    this.fillStreamingSource(sourceId, stream);
                    if (!stopped) continue;
                    AL10.alSourcePlay((int)sourceId);
                    continue;
                }
                if (!stopped) continue;
                src.setStatus(AudioNode.Status.Stopped);
                src.setChannel(-1);
                this.clearChannel(i);
                this.freeChannel(i);
                this.deleteAudioData(stream);
                continue;
            }
            if (streaming) continue;
            boolean bl2 = paused = state == 4115;
            assert (src.getStatus() == AudioNode.Status.Paused && paused || !paused);
            if (!stopped) continue;
            if (boundSource) {
                src.setStatus(AudioNode.Status.Stopped);
                src.setChannel(-1);
            }
            this.clearChannel(i);
            this.freeChannel(i);
        }
        this.objManager.deleteUnused(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListener(Listener listener) {
        this.checkDead();
        AtomicBoolean atomicBoolean = this.threadLock;
        synchronized (atomicBoolean) {
            while (!this.threadLock.get()) {
                try {
                    this.threadLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.audioDisabled) {
                return;
            }
            if (this.listener != null) {
                this.listener.setRenderer(null);
            }
            this.listener = listener;
            this.listener.setRenderer(this);
            this.setListenerParams(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playSourceInstance(AudioNode src) {
        this.checkDead();
        AtomicBoolean atomicBoolean = this.threadLock;
        synchronized (atomicBoolean) {
            int index;
            while (!this.threadLock.get()) {
                try {
                    this.threadLock.wait();
                }
                catch (InterruptedException ex) {}
            }
            if (this.audioDisabled) {
                return;
            }
            if (src.getAudioData() instanceof AudioStream) {
                throw new UnsupportedOperationException("Cannot play instances of audio streams. Use playSource() instead.");
            }
            if (src.getAudioData().isUpdateNeeded()) {
                this.updateAudioData(src.getAudioData());
            }
            if ((index = this.newChannel()) == -1) {
                return;
            }
            int sourceId = this.channels[index];
            this.clearChannel(index);
            this.setSourceParams(sourceId, src, true);
            this.attachAudioToSource(sourceId, src.getAudioData());
            this.chanSrcs[index] = src;
            AL10.alSourcePlay((int)sourceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playSource(AudioNode src) {
        this.checkDead();
        AtomicBoolean atomicBoolean = this.threadLock;
        synchronized (atomicBoolean) {
            while (!this.threadLock.get()) {
                try {
                    this.threadLock.wait();
                }
                catch (InterruptedException ex) {}
            }
            if (this.audioDisabled) {
                return;
            }
            if (src.getStatus() == AudioNode.Status.Playing) {
                return;
            }
            if (src.getStatus() == AudioNode.Status.Stopped) {
                int index = this.newChannel();
                if (index == -1) {
                    logger.log(Level.WARNING, "No channel available to play {0}", src);
                    return;
                }
                this.clearChannel(index);
                src.setChannel(index);
                AudioData data = src.getAudioData();
                if (data.isUpdateNeeded()) {
                    this.updateAudioData(data);
                }
                this.chanSrcs[index] = src;
                this.setSourceParams(this.channels[index], src, false);
                this.attachAudioToSource(this.channels[index], data);
            }
            AL10.alSourcePlay((int)this.channels[src.getChannel()]);
            src.setStatus(AudioNode.Status.Playing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseSource(AudioNode src) {
        this.checkDead();
        AtomicBoolean atomicBoolean = this.threadLock;
        synchronized (atomicBoolean) {
            while (!this.threadLock.get()) {
                try {
                    this.threadLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.audioDisabled) {
                return;
            }
            if (src.getStatus() == AudioNode.Status.Playing) {
                assert (src.getChannel() != -1);
                AL10.alSourcePause((int)this.channels[src.getChannel()]);
                src.setStatus(AudioNode.Status.Paused);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopSource(AudioNode src) {
        AtomicBoolean atomicBoolean = this.threadLock;
        synchronized (atomicBoolean) {
            while (!this.threadLock.get()) {
                try {
                    this.threadLock.wait();
                }
                catch (InterruptedException ex) {}
            }
            if (this.audioDisabled) {
                return;
            }
            if (src.getStatus() != AudioNode.Status.Stopped) {
                int chan = src.getChannel();
                assert (chan != -1);
                src.setStatus(AudioNode.Status.Stopped);
                src.setChannel(-1);
                this.clearChannel(chan);
                this.freeChannel(chan);
                if (src.getAudioData() instanceof AudioStream) {
                    AudioStream stream = (AudioStream)src.getAudioData();
                    if (stream.isOpen()) {
                        stream.close();
                    }
                    this.deleteAudioData(src.getAudioData());
                }
            }
        }
    }

    private int convertFormat(AudioData ad) {
        switch (ad.getBitsPerSample()) {
            case 8: {
                if (ad.getChannels() == 1) {
                    return 4352;
                }
                if (ad.getChannels() != 2) break;
                return 4354;
            }
            case 16: {
                if (ad.getChannels() == 1) {
                    return 4353;
                }
                return 4355;
            }
        }
        throw new UnsupportedOperationException("Unsupported channels/bits combination: bits=" + ad.getBitsPerSample() + ", channels=" + ad.getChannels());
    }

    private void updateAudioBuffer(AudioBuffer ab) {
        int id = ab.getId();
        if (ab.getId() == -1) {
            this.ib.position(0).limit(1);
            AL10.alGenBuffers((IntBuffer)this.ib);
            id = this.ib.get(0);
            ab.setId(id);
            this.objManager.registerForCleanup(ab);
        }
        ab.getData().clear();
        AL10.alBufferData((int)id, (int)this.convertFormat(ab), (ByteBuffer)ab.getData(), (int)ab.getSampleRate());
        ab.clearUpdateNeeded();
    }

    private void updateAudioStream(AudioStream as) {
        if (as.getIds() != null) {
            this.deleteAudioData(as);
        }
        int[] ids = new int[5];
        this.ib.position(0).limit(5);
        AL10.alGenBuffers((IntBuffer)this.ib);
        this.ib.position(0).limit(5);
        this.ib.get(ids);
        as.setIds(ids);
        as.clearUpdateNeeded();
    }

    private void updateAudioData(AudioData ad) {
        if (ad instanceof AudioBuffer) {
            this.updateAudioBuffer((AudioBuffer)ad);
        } else if (ad instanceof AudioStream) {
            this.updateAudioStream((AudioStream)ad);
        }
    }

    public void deleteFilter(Filter filter) {
        int id = filter.getId();
        if (id != -1) {
            EFX10.alDeleteFilters((int)id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAudioData(AudioData ad) {
        AtomicBoolean atomicBoolean = this.threadLock;
        synchronized (atomicBoolean) {
            AudioStream as;
            int[] ids;
            while (!this.threadLock.get()) {
                try {
                    this.threadLock.wait();
                }
                catch (InterruptedException ex) {}
            }
            if (this.audioDisabled) {
                return;
            }
            if (ad instanceof AudioBuffer) {
                AudioBuffer ab = (AudioBuffer)ad;
                int id = ab.getId();
                if (id != -1) {
                    this.ib.put(0, id);
                    this.ib.position(0).limit(1);
                    AL10.alDeleteBuffers((IntBuffer)this.ib);
                    ab.resetObject();
                }
            } else if (ad instanceof AudioStream && (ids = (as = (AudioStream)ad).getIds()) != null) {
                this.ib.clear();
                this.ib.put(ids).flip();
                AL10.alDeleteBuffers((IntBuffer)this.ib);
                as.resetObject();
            }
        }
    }
}

