/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app;

import com.jme3.app.AppTask;
import com.jme3.app.state.AppStateManager;
import com.jme3.asset.AssetManager;
import com.jme3.audio.AudioContext;
import com.jme3.audio.AudioRenderer;
import com.jme3.audio.Listener;
import com.jme3.input.InputManager;
import com.jme3.input.JoyInput;
import com.jme3.input.KeyInput;
import com.jme3.input.MouseInput;
import com.jme3.input.TouchInput;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.system.JmeSystem;
import com.jme3.system.SystemListener;
import com.jme3.system.Timer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application
implements SystemListener {
    private static final Logger logger = Logger.getLogger(Application.class.getName());
    protected AssetManager assetManager;
    protected AudioRenderer audioRenderer;
    protected Renderer renderer;
    protected RenderManager renderManager;
    protected ViewPort viewPort;
    protected ViewPort guiViewPort;
    protected JmeContext context;
    protected AppSettings settings;
    protected Timer timer;
    protected Camera cam;
    protected Listener listener;
    protected boolean inputEnabled = true;
    protected boolean pauseOnFocus = true;
    protected float speed = 1.0f;
    protected boolean paused = false;
    protected MouseInput mouseInput;
    protected KeyInput keyInput;
    protected JoyInput joyInput;
    protected TouchInput touchInput;
    protected InputManager inputManager;
    protected AppStateManager stateManager;
    private final ConcurrentLinkedQueue<AppTask<?>> taskQueue = new ConcurrentLinkedQueue();

    public boolean isPauseOnLostFocus() {
        return this.pauseOnFocus;
    }

    public void setPauseOnLostFocus(boolean pauseOnLostFocus) {
        this.pauseOnFocus = pauseOnLostFocus;
    }

    @Deprecated
    public void setAssetManager(AssetManager assetManager) {
        if (this.assetManager != null) {
            throw new IllegalStateException("Can only set asset manager before initialization.");
        }
        this.assetManager = assetManager;
    }

    private void initAssetManager() {
        String assetCfg;
        if (this.settings != null && (assetCfg = this.settings.getString("AssetConfigURL")) != null) {
            URL url = null;
            try {
                url = new URL(assetCfg);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (url == null && (url = Application.class.getClassLoader().getResource(assetCfg)) == null) {
                logger.log(Level.SEVERE, "Unable to access AssetConfigURL in asset config:{0}", assetCfg);
                return;
            }
            this.assetManager = JmeSystem.newAssetManager(url);
        }
        if (this.assetManager == null) {
            this.assetManager = JmeSystem.newAssetManager(Thread.currentThread().getContextClassLoader().getResource("com/jme3/asset/Desktop.cfg"));
        }
    }

    public void setSettings(AppSettings settings) {
        this.settings = settings;
        if (this.context != null && settings.useInput() != this.inputEnabled) {
            boolean bl = this.inputEnabled = !this.inputEnabled;
            if (this.inputEnabled) {
                this.initInput();
            } else {
                this.destroyInput();
            }
        } else {
            this.inputEnabled = settings.useInput();
        }
    }

    private void initDisplay() {
        this.settings = this.context.getSettings();
        this.timer = this.context.getTimer();
        this.renderer = this.context.getRenderer();
    }

    private void initAudio() {
        if (this.settings.getAudioRenderer() != null && this.context.getType() != JmeContext.Type.Headless) {
            this.audioRenderer = JmeSystem.newAudioRenderer(this.settings);
            this.audioRenderer.initialize();
            AudioContext.setAudioRenderer(this.audioRenderer);
            this.listener = new Listener();
            this.audioRenderer.setListener(this.listener);
        }
    }

    private void initCamera() {
        this.cam = new Camera(this.settings.getWidth(), this.settings.getHeight());
        this.cam.setFrustumPerspective(45.0f, (float)this.cam.getWidth() / (float)this.cam.getHeight(), 1.0f, 1000.0f);
        this.cam.setLocation(new Vector3f(0.0f, 0.0f, 10.0f));
        this.cam.lookAt(new Vector3f(0.0f, 0.0f, 0.0f), Vector3f.UNIT_Y);
        this.renderManager = new RenderManager(this.renderer);
        this.renderManager.setTimer(this.timer);
        this.viewPort = this.renderManager.createMainView("Default", this.cam);
        this.viewPort.setClearFlags(true, true, true);
        Camera guiCam = new Camera(this.settings.getWidth(), this.settings.getHeight());
        this.guiViewPort = this.renderManager.createPostView("Gui Default", guiCam);
        this.guiViewPort.setClearFlags(false, false, false);
    }

    private void initInput() {
        this.mouseInput = this.context.getMouseInput();
        if (this.mouseInput != null) {
            this.mouseInput.initialize();
        }
        this.keyInput = this.context.getKeyInput();
        if (this.keyInput != null) {
            this.keyInput.initialize();
        }
        this.touchInput = this.context.getTouchInput();
        if (this.touchInput != null) {
            this.touchInput.initialize();
        }
        if (!this.settings.getBoolean("DisableJoysticks")) {
            this.joyInput = this.context.getJoyInput();
            if (this.joyInput != null) {
                this.joyInput.initialize();
            }
        }
        this.inputManager = new InputManager(this.mouseInput, this.keyInput, this.joyInput, this.touchInput);
    }

    private void initStateManager() {
        this.stateManager = new AppStateManager(this);
    }

    public AssetManager getAssetManager() {
        return this.assetManager;
    }

    public InputManager getInputManager() {
        return this.inputManager;
    }

    public AppStateManager getStateManager() {
        return this.stateManager;
    }

    public RenderManager getRenderManager() {
        return this.renderManager;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public AudioRenderer getAudioRenderer() {
        return this.audioRenderer;
    }

    public Listener getListener() {
        return this.listener;
    }

    public JmeContext getContext() {
        return this.context;
    }

    public Camera getCamera() {
        return this.cam;
    }

    public void start() {
        this.start(JmeContext.Type.Display);
    }

    public void start(JmeContext.Type contextType) {
        if (this.context != null && this.context.isCreated()) {
            logger.warning("start() called when application already created!");
            return;
        }
        if (this.settings == null) {
            this.settings = new AppSettings(true);
        }
        logger.log(Level.FINE, "Starting application: {0}", this.getClass().getName());
        this.context = JmeSystem.newContext(this.settings, contextType);
        this.context.setSystemListener(this);
        this.context.create(false);
    }

    public void createCanvas() {
        if (this.context != null && this.context.isCreated()) {
            logger.warning("createCanvas() called when application already created!");
            return;
        }
        if (this.settings == null) {
            this.settings = new AppSettings(true);
        }
        logger.log(Level.FINE, "Starting application: {0}", this.getClass().getName());
        this.context = JmeSystem.newContext(this.settings, JmeContext.Type.Canvas);
        this.context.setSystemListener(this);
    }

    public void startCanvas() {
        this.startCanvas(false);
    }

    public void startCanvas(boolean waitFor) {
        this.context.create(waitFor);
    }

    @Override
    public void reshape(int w, int h) {
        this.renderManager.notifyReshape(w, h);
    }

    public void restart() {
        this.context.setSettings(this.settings);
        this.context.restart();
    }

    public void stop() {
        this.stop(false);
    }

    public void stop(boolean waitFor) {
        logger.log(Level.FINE, "Closing application: {0}", this.getClass().getName());
        this.context.destroy(waitFor);
    }

    @Override
    public void initialize() {
        if (this.assetManager == null) {
            this.initAssetManager();
        }
        this.initDisplay();
        this.initCamera();
        if (this.inputEnabled) {
            this.initInput();
        }
        this.initAudio();
        this.initStateManager();
        this.timer.reset();
    }

    @Override
    public void handleError(String errMsg, Throwable t) {
        logger.log(Level.SEVERE, errMsg, t);
        this.stop();
    }

    @Override
    public void gainFocus() {
        if (this.pauseOnFocus) {
            this.paused = false;
            this.context.setAutoFlushFrames(true);
            if (this.inputManager != null) {
                this.inputManager.reset();
            }
        }
    }

    @Override
    public void loseFocus() {
        if (this.pauseOnFocus) {
            this.paused = true;
            this.context.setAutoFlushFrames(false);
        }
    }

    @Override
    public void requestClose(boolean esc) {
        this.context.destroy(false);
    }

    public <V> Future<V> enqueue(Callable<V> callable) {
        AppTask<V> task = new AppTask<V>(callable);
        this.taskQueue.add(task);
        return task;
    }

    @Override
    public void update() {
        AudioContext.setAudioRenderer(this.audioRenderer);
        AppTask<?> task = this.taskQueue.poll();
        block0: while (task != null) {
            while (task.isCancelled()) {
                task = this.taskQueue.poll();
                if (task != null) continue;
                break block0;
            }
            task.invoke();
            task = this.taskQueue.poll();
            if (task != null) continue;
        }
        if (this.speed == 0.0f || this.paused) {
            return;
        }
        this.timer.update();
        if (this.inputEnabled) {
            this.inputManager.update(this.timer.getTimePerFrame());
        }
        if (this.audioRenderer != null) {
            this.audioRenderer.update(this.timer.getTimePerFrame());
        }
    }

    protected void destroyInput() {
        if (this.mouseInput != null) {
            this.mouseInput.destroy();
        }
        if (this.keyInput != null) {
            this.keyInput.destroy();
        }
        if (this.joyInput != null) {
            this.joyInput.destroy();
        }
        if (this.touchInput != null) {
            this.touchInput.destroy();
        }
        this.inputManager = null;
    }

    @Override
    public void destroy() {
        this.stateManager.cleanup();
        this.destroyInput();
        if (this.audioRenderer != null) {
            this.audioRenderer.cleanup();
        }
        this.timer.reset();
    }

    public ViewPort getGuiViewPort() {
        return this.guiViewPort;
    }

    public ViewPort getViewPort() {
        return this.viewPort;
    }
}

