/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.animation;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.util.TempVars;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Bone
implements Savable {
    private String name;
    private Bone parent;
    private final ArrayList<Bone> children = new ArrayList();
    private boolean userControl = false;
    private Node attachNode;
    private Vector3f initialPos;
    private Quaternion initialRot;
    private Vector3f initialScale;
    private Vector3f worldBindInversePos;
    private Quaternion worldBindInverseRot;
    private Vector3f worldBindInverseScale;
    private Vector3f localPos = new Vector3f();
    private Quaternion localRot = new Quaternion();
    private Vector3f localScale = new Vector3f(1.0f, 1.0f, 1.0f);
    private Vector3f worldPos = new Vector3f();
    private Quaternion worldRot = new Quaternion();
    private Vector3f worldScale = new Vector3f();
    private Transform tmpTransform = new Transform();

    public Bone(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.name = name;
        this.initialPos = new Vector3f();
        this.initialRot = new Quaternion();
        this.initialScale = new Vector3f(1.0f, 1.0f, 1.0f);
        this.worldBindInversePos = new Vector3f();
        this.worldBindInverseRot = new Quaternion();
        this.worldBindInverseScale = new Vector3f();
    }

    Bone(Bone source) {
        this.name = source.name;
        this.userControl = source.userControl;
        this.initialPos = source.initialPos;
        this.initialRot = source.initialRot;
        this.initialScale = source.initialScale;
        this.worldBindInversePos = source.worldBindInversePos;
        this.worldBindInverseRot = source.worldBindInverseRot;
        this.worldBindInverseScale = source.worldBindInverseScale;
    }

    public Bone() {
    }

    public String getName() {
        return this.name;
    }

    public Bone getParent() {
        return this.parent;
    }

    public ArrayList<Bone> getChildren() {
        return this.children;
    }

    public Vector3f getLocalPosition() {
        return this.localPos;
    }

    public Quaternion getLocalRotation() {
        return this.localRot;
    }

    public Vector3f getLocalScale() {
        return this.localScale;
    }

    public Vector3f getModelSpacePosition() {
        return this.worldPos;
    }

    public Quaternion getModelSpaceRotation() {
        return this.worldRot;
    }

    public Vector3f getModelSpaceScale() {
        return this.worldScale;
    }

    public Vector3f getWorldBindInversePosition() {
        return this.worldBindInversePos;
    }

    public Quaternion getWorldBindInverseRotation() {
        return this.worldBindInverseRot;
    }

    public Vector3f getWorldBindInverseScale() {
        return this.worldBindInverseScale;
    }

    public Vector3f getWorldBindPosition() {
        return this.initialPos;
    }

    public Quaternion getWorldBindRotation() {
        return this.initialRot;
    }

    public Vector3f getWorldBindScale() {
        return this.initialScale;
    }

    public void setUserControl(boolean enable) {
        this.userControl = enable;
    }

    public void addChild(Bone bone) {
        this.children.add(bone);
        bone.parent = this;
    }

    public final void updateWorldVectors() {
        if (this.parent != null) {
            this.parent.worldRot.mult(this.localRot, this.worldRot);
            this.parent.worldScale.mult(this.localScale, this.worldScale);
            this.parent.worldRot.mult(this.localPos, this.worldPos);
            this.worldPos.multLocal(this.parent.worldScale);
            this.worldPos.addLocal(this.parent.worldPos);
        } else {
            this.worldRot.set(this.localRot);
            this.worldPos.set(this.localPos);
            this.worldScale.set(this.localScale);
        }
        if (this.attachNode != null) {
            this.attachNode.setLocalTranslation(this.worldPos);
            this.attachNode.setLocalRotation(this.worldRot);
            this.attachNode.setLocalScale(this.worldScale);
        }
    }

    final void update() {
        this.updateWorldVectors();
        for (int i = this.children.size() - 1; i >= 0; --i) {
            this.children.get(i).update();
        }
    }

    void setBindingPose() {
        this.initialPos.set(this.localPos);
        this.initialRot.set(this.localRot);
        this.initialScale.set(this.localScale);
        if (this.worldBindInversePos == null) {
            this.worldBindInversePos = new Vector3f();
            this.worldBindInverseRot = new Quaternion();
            this.worldBindInverseScale = new Vector3f();
        }
        this.worldBindInversePos.set(this.worldPos);
        this.worldBindInversePos.negateLocal();
        this.worldBindInverseRot.set(this.worldRot);
        this.worldBindInverseRot.inverseLocal();
        this.worldBindInverseScale.set(Vector3f.UNIT_XYZ);
        this.worldBindInverseScale.divideLocal(this.worldScale);
        for (Bone b : this.children) {
            b.setBindingPose();
        }
    }

    final void reset() {
        if (!this.userControl) {
            this.localPos.set(this.initialPos);
            this.localRot.set(this.initialRot);
            this.localScale.set(this.initialScale);
        }
        for (int i = this.children.size() - 1; i >= 0; --i) {
            this.children.get(i).reset();
        }
    }

    void getOffsetTransform(Matrix4f outTransform, Quaternion tmp1, Vector3f tmp2, Vector3f tmp3, Matrix3f tmp4) {
        Vector3f scale = this.worldScale.mult(this.worldBindInverseScale, tmp3);
        Quaternion rotate = this.worldRot.mult(this.worldBindInverseRot, tmp1);
        Vector3f translate = this.worldPos.add(rotate.mult(scale.mult(this.worldBindInversePos, tmp2), tmp2), tmp2);
        outTransform.loadIdentity();
        outTransform.setTransform(translate, scale, rotate.toRotationMatrix(tmp4));
    }

    public void setUserTransforms(Vector3f translation, Quaternion rotation, Vector3f scale) {
        if (!this.userControl) {
            throw new IllegalStateException("User control must be on bone to allow user transforms");
        }
        this.localPos.set(this.initialPos);
        this.localRot.set(this.initialRot);
        this.localScale.set(this.initialScale);
        this.localPos.addLocal(translation);
        this.localRot = this.localRot.mult(rotation);
        this.localScale.multLocal(scale);
    }

    public void setUserTransformsWorld(Vector3f translation, Quaternion rotation) {
        if (!this.userControl) {
            throw new IllegalStateException("User control must be on bone to allow user transforms");
        }
        this.worldPos.set(translation);
        this.worldRot.set(rotation);
    }

    public Transform getCombinedTransform(Vector3f position, Quaternion rotation) {
        rotation.mult(this.localPos, this.tmpTransform.getTranslation()).addLocal(position);
        this.tmpTransform.setRotation(rotation).getRotation().multLocal(this.localRot);
        return this.tmpTransform;
    }

    public Node getAttachmentsNode() {
        if (this.attachNode == null) {
            this.attachNode = new Node(this.name + "_attachnode");
            this.attachNode.setUserData("AttachedBone", this);
        }
        return this.attachNode;
    }

    void setAttachmentsNode(Node attachNode) {
        this.attachNode = attachNode;
    }

    void setAnimTransforms(Vector3f translation, Quaternion rotation, Vector3f scale) {
        if (this.userControl) {
            return;
        }
        this.localPos.set(this.initialPos).addLocal(translation);
        this.localRot.set(this.initialRot).multLocal(rotation);
        if (scale != null) {
            this.localScale.set(this.initialScale).multLocal(scale);
        }
    }

    void blendAnimTransforms(Vector3f translation, Quaternion rotation, Vector3f scale, float weight) {
        if (this.userControl) {
            return;
        }
        TempVars vars = TempVars.get();
        Vector3f tmpV = vars.vect1;
        Vector3f tmpV2 = vars.vect2;
        Quaternion tmpQ = vars.quat1;
        tmpV.set(this.initialPos).addLocal(translation);
        this.localPos.interpolate(tmpV, weight);
        tmpQ.set(this.initialRot).multLocal(rotation);
        this.localRot.nlerp(tmpQ, weight);
        if (scale != null) {
            tmpV2.set(this.initialScale).multLocal(scale);
            this.localScale.interpolate(tmpV2, weight);
        }
        vars.release();
    }

    public void setBindTransforms(Vector3f translation, Quaternion rotation, Vector3f scale) {
        this.initialPos.set(translation);
        this.initialRot.set(rotation);
        if (scale != null) {
            this.initialScale.set(scale);
        }
        this.localPos.set(translation);
        this.localRot.set(rotation);
        if (scale != null) {
            this.localScale.set(scale);
        }
    }

    private String toString(int depth) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            sb.append('-');
        }
        sb.append(this.name).append(" bone\n");
        for (Bone child : this.children) {
            sb.append(child.toString(depth + 1));
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(0);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule input = im.getCapsule(this);
        this.name = input.readString("name", null);
        this.initialPos = (Vector3f)input.readSavable("initialPos", null);
        this.initialRot = (Quaternion)input.readSavable("initialRot", null);
        this.initialScale = (Vector3f)input.readSavable("initialScale", new Vector3f(1.0f, 1.0f, 1.0f));
        this.attachNode = (Node)input.readSavable("attachNode", null);
        this.localPos.set(this.initialPos);
        this.localRot.set(this.initialRot);
        ArrayList childList = input.readSavableArrayList("children", null);
        for (int i = childList.size() - 1; i >= 0; --i) {
            this.addChild((Bone)childList.get(i));
        }
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule output = ex.getCapsule(this);
        output.write(this.name, "name", null);
        output.write(this.attachNode, "attachNode", null);
        output.write(this.initialPos, "initialPos", null);
        output.write(this.initialRot, "initialRot", null);
        output.write(this.initialScale, "initialScale", new Vector3f(1.0f, 1.0f, 1.0f));
        output.writeSavableArrayList(this.children, "children", null);
    }
}

