/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.animation;

import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimControl;
import com.jme3.animation.Track;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.util.TempVars;
import java.io.IOException;

public class Animation
implements Savable,
Cloneable {
    private String name;
    private float length;
    private Track[] tracks;

    public Animation() {
    }

    public Animation(String name, float length) {
        this.name = name;
        this.length = length;
    }

    public String getName() {
        return this.name;
    }

    public float getLength() {
        return this.length;
    }

    void setTime(float time, float blendAmount, AnimControl control, AnimChannel channel, TempVars vars) {
        for (int i = 0; i < this.tracks.length; ++i) {
            this.tracks[i].setTime(time, blendAmount, control, channel, vars);
        }
    }

    public void setTracks(Track[] tracks) {
        this.tracks = tracks;
    }

    public Track[] getTracks() {
        return this.tracks;
    }

    public Animation clone() {
        try {
            Animation result = (Animation)super.clone();
            result.tracks = (Track[])this.tracks.clone();
            for (int i = 0; i < this.tracks.length; ++i) {
                result.tracks[i] = this.tracks[i].clone();
            }
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.name + ", length=" + this.length + ']';
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule out = ex.getCapsule(this);
        out.write(this.name, "name", null);
        out.write(this.length, "length", 0.0f);
        out.write(this.tracks, "tracks", null);
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule in = im.getCapsule(this);
        this.name = in.readString("name", null);
        this.length = in.readFloat("length", 0.0f);
        Savable[] arr = in.readSavableArray("tracks", null);
        this.tracks = new Track[arr.length];
        System.arraycopy(arr, 0, this.tracks, 0, arr.length);
    }
}

