/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app.state;

import com.jme3.app.Application;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.app.state.MjpegFileWriter;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.system.Timer;
import com.jme3.texture.FrameBuffer;
import com.jme3.util.BufferUtils;
import com.jme3.util.Screenshots;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VideoRecorderAppState
extends AbstractAppState {
    private int framerate = 30;
    private VideoProcessor processor;
    private File file;
    private Application app;
    private ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread th = new Thread(r);
            th.setName("jME Video Processing Thread");
            th.setDaemon(true);
            return th;
        }
    });
    private int numCpus = Runtime.getRuntime().availableProcessors();
    private ViewPort lastViewPort;
    private float quality;
    private Timer oldTimer;

    public VideoRecorderAppState() {
        this(null, 0.8f);
    }

    public VideoRecorderAppState(float quality) {
        this(null, quality);
    }

    public VideoRecorderAppState(float quality, int framerate) {
        this(null, quality, framerate);
    }

    public VideoRecorderAppState(File file) {
        this(file, 0.8f);
    }

    public VideoRecorderAppState(File file, float quality) {
        this.file = file;
        this.quality = quality;
        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, "JME3 VideoRecorder running on {0} CPU's", this.numCpus);
    }

    public VideoRecorderAppState(File file, float quality, int framerate) {
        this.file = file;
        this.quality = quality;
        this.framerate = framerate;
        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, "JME3 VideoRecorder running on {0} CPU's", this.numCpus);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        if (this.isInitialized()) {
            throw new IllegalStateException("Cannot set file while attached!");
        }
        this.file = file;
    }

    public float getQuality() {
        return this.quality;
    }

    public void setQuality(float quality) {
        this.quality = quality;
    }

    public void initialize(AppStateManager stateManager, Application app) {
        super.initialize(stateManager, app);
        this.app = app;
        this.oldTimer = app.getTimer();
        app.setTimer((Timer)new IsoTimer(this.framerate));
        if (this.file == null) {
            String filename = System.getProperty("user.home") + File.separator + "jMonkey-" + System.currentTimeMillis() / 1000L + ".avi";
            this.file = new File(filename);
        }
        this.processor = new VideoProcessor();
        List vps = app.getRenderManager().getPostViews();
        for (int i = vps.size() - 1; i >= 0; --i) {
            this.lastViewPort = (ViewPort)vps.get(i);
            if (this.lastViewPort.isEnabled()) break;
        }
        this.lastViewPort.addProcessor((SceneProcessor)this.processor);
    }

    public void cleanup() {
        this.lastViewPort.removeProcessor((SceneProcessor)this.processor);
        this.app.setTimer(this.oldTimer);
        this.initialized = false;
        this.file = null;
        super.cleanup();
    }

    public static final class IsoTimer
    extends Timer {
        private float framerate;
        private int ticks;
        private long lastTime = 0L;

        public IsoTimer(float framerate) {
            this.framerate = framerate;
            this.ticks = 0;
        }

        public long getTime() {
            return (long)((float)this.ticks * (1.0f / this.framerate) * 1000.0f);
        }

        public long getResolution() {
            return 1000L;
        }

        public float getFrameRate() {
            return this.framerate;
        }

        public float getTimePerFrame() {
            return 1.0f / this.framerate;
        }

        public void update() {
            long time = System.currentTimeMillis();
            long difference = time - this.lastTime;
            this.lastTime = time;
            if ((float)difference < 1.0f / this.framerate * 1000.0f) {
                try {
                    Thread.sleep(difference);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            ++this.ticks;
        }

        public void reset() {
            this.ticks = 0;
        }
    }

    private class VideoProcessor
    implements SceneProcessor {
        private Camera camera;
        private int width;
        private int height;
        private RenderManager renderManager;
        private boolean isInitilized = false;
        private LinkedBlockingQueue<WorkItem> freeItems;
        private LinkedBlockingQueue<WorkItem> usedItems = new LinkedBlockingQueue();
        private MjpegFileWriter writer;

        private VideoProcessor() {
        }

        public void addImage(Renderer renderer, FrameBuffer out) {
            if (this.freeItems == null) {
                return;
            }
            try {
                final WorkItem item = this.freeItems.take();
                this.usedItems.add(item);
                item.buffer.clear();
                renderer.readFrameBuffer(out, item.buffer);
                VideoRecorderAppState.this.executor.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        Screenshots.convertScreenShot(item.buffer, item.image);
                        item.data = VideoProcessor.this.writer.writeImageToBytes(item.image, VideoRecorderAppState.this.quality);
                        while (VideoProcessor.this.usedItems.peek() != item) {
                            Thread.sleep(1L);
                        }
                        VideoProcessor.this.writer.addImage(item.data);
                        VideoProcessor.this.usedItems.poll();
                        VideoProcessor.this.freeItems.add(item);
                        return null;
                    }
                });
            }
            catch (InterruptedException ex) {
                Logger.getLogger(VideoRecorderAppState.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        public void initialize(RenderManager rm, ViewPort viewPort) {
            this.camera = viewPort.getCamera();
            this.width = this.camera.getWidth();
            this.height = this.camera.getHeight();
            this.renderManager = rm;
            this.isInitilized = true;
            if (this.freeItems == null) {
                this.freeItems = new LinkedBlockingQueue();
                for (int i = 0; i < VideoRecorderAppState.this.numCpus; ++i) {
                    this.freeItems.add(new WorkItem(this.width, this.height));
                }
            }
        }

        public void reshape(ViewPort vp, int w, int h) {
        }

        public boolean isInitialized() {
            return this.isInitilized;
        }

        public void preFrame(float tpf) {
            if (null == this.writer) {
                try {
                    this.writer = new MjpegFileWriter(VideoRecorderAppState.this.file, this.width, this.height, VideoRecorderAppState.this.framerate);
                }
                catch (Exception ex) {
                    Logger.getLogger(VideoRecorderAppState.class.getName()).log(Level.SEVERE, "Error creating file writer: {0}", ex);
                }
            }
        }

        public void postQueue(RenderQueue rq) {
        }

        public void postFrame(FrameBuffer out) {
            this.addImage(this.renderManager.getRenderer(), out);
        }

        public void cleanup() {
            try {
                while (this.freeItems.size() < VideoRecorderAppState.this.numCpus) {
                    Thread.sleep(10L);
                }
                this.writer.finishAVI();
            }
            catch (Exception ex) {
                Logger.getLogger(VideoRecorderAppState.class.getName()).log(Level.SEVERE, "Error closing video: {0}", ex);
            }
            this.writer = null;
        }
    }

    private class WorkItem {
        ByteBuffer buffer;
        BufferedImage image;
        byte[] data;

        public WorkItem(int width, int height) {
            this.image = new BufferedImage(width, height, 6);
            this.buffer = BufferUtils.createByteBuffer((int)(width * height * 4));
        }
    }
}

