/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures.generating;

import com.jme3.math.FastMath;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.scene.plugins.blender.textures.generating.NoiseGenerator;
import com.jme3.scene.plugins.blender.textures.generating.TextureGenerator;
import com.jme3.texture.Image;

public class TextureGeneratorWood
extends TextureGenerator {
    protected static final int TEX_SIN = 0;
    protected static final int TEX_SAW = 1;
    protected static final int TEX_TRI = 2;
    protected static final int TEX_BAND = 0;
    protected static final int TEX_RING = 1;
    protected static final int TEX_BANDNOISE = 2;
    protected static final int TEX_RINGNOISE = 3;
    protected static final int TEX_NOISESOFT = 0;
    protected static final int TEX_NOISEPERL = 1;
    protected WoodIntensityData woodIntensityData;
    protected static WaveForm[] waveformFunctions = new WaveForm[3];

    public TextureGeneratorWood(NoiseGenerator noiseGenerator) {
        super(noiseGenerator, Image.Format.Luminance8);
    }

    public void readData(Structure tex, BlenderContext blenderContext) {
        super.readData(tex, blenderContext);
        this.woodIntensityData = new WoodIntensityData(tex);
    }

    public void getPixel(TexturePixel pixel, float x, float y, float z) {
        pixel.intensity = this.woodIntensity(this.woodIntensityData, x, y, z);
        if (this.colorBand != null) {
            int colorbandIndex = (int)(pixel.intensity * 1000.0f);
            pixel.red = this.colorBand[colorbandIndex][0];
            pixel.green = this.colorBand[colorbandIndex][1];
            pixel.blue = this.colorBand[colorbandIndex][2];
            this.applyBrightnessAndContrast(this.bacd, pixel);
            pixel.alpha = this.colorBand[colorbandIndex][3];
        } else {
            this.applyBrightnessAndContrast(pixel, this.bacd.contrast, this.bacd.brightness);
        }
    }

    public float woodIntensity(WoodIntensityData woodIntData, float x, float y, float z) {
        float result;
        switch (woodIntData.woodType) {
            case 0: {
                result = woodIntData.waveformFunction.execute((x + y + z) * 10.0f);
                break;
            }
            case 1: {
                result = woodIntData.waveformFunction.execute((float)Math.sqrt(x * x + y * y + z * z) * 20.0f);
                break;
            }
            case 2: {
                result = woodIntData.turbul * NoiseGenerator.NoiseFunctions.noise(x, y, z, woodIntData.noisesize, 0, woodIntData.noisebasis, woodIntData.isHard);
                result = woodIntData.waveformFunction.execute((x + y + z) * 10.0f + result);
                break;
            }
            case 3: {
                result = woodIntData.turbul * NoiseGenerator.NoiseFunctions.noise(x, y, z, woodIntData.noisesize, 0, woodIntData.noisebasis, woodIntData.isHard);
                result = woodIntData.waveformFunction.execute((float)Math.sqrt(x * x + y * y + z * z) * 20.0f + result);
                break;
            }
            default: {
                result = 0.0f;
            }
        }
        return result;
    }

    static {
        TextureGeneratorWood.waveformFunctions[0] = new WaveForm(){

            public float execute(float x) {
                return 0.5f + 0.5f * (float)Math.sin(x);
            }
        };
        TextureGeneratorWood.waveformFunctions[1] = new WaveForm(){

            public float execute(float x) {
                int n;
                if ((x -= (float)(n = (int)(x * 0.15915494f)) * ((float)Math.PI * 2)) < 0.0f) {
                    x += (float)Math.PI * 2;
                }
                return x * 0.15915494f;
            }
        };
        TextureGeneratorWood.waveformFunctions[2] = new WaveForm(){

            public float execute(float x) {
                return 1.0f - 2.0f * FastMath.abs((float)((float)Math.floor(x * 0.15915494f + 0.5f) - x * 0.15915494f));
            }
        };
    }

    protected static interface WaveForm {
        public float execute(float var1);
    }

    private static class WoodIntensityData {
        public final WaveForm waveformFunction;
        public final int noisebasis;
        public final float noisesize;
        public final float turbul;
        public final int noiseType;
        public final int woodType;
        public final boolean isHard;

        public WoodIntensityData(Structure tex) {
            int waveform = ((Number)tex.getFieldValue("noisebasis2")).intValue();
            if (waveform > 2 || waveform < 0) {
                waveform = 0;
            }
            this.waveformFunction = waveformFunctions[waveform];
            this.noisebasis = ((Number)tex.getFieldValue("noisebasis")).intValue();
            this.woodType = ((Number)tex.getFieldValue("stype")).intValue();
            this.noisesize = ((Number)tex.getFieldValue("noisesize")).floatValue();
            this.turbul = ((Number)tex.getFieldValue("turbul")).floatValue();
            this.noiseType = ((Number)tex.getFieldValue("noisetype")).intValue();
            this.isHard = this.noiseType != 0;
        }
    }
}

