/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures.generating;

import com.jme3.math.FastMath;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.scene.plugins.blender.textures.generating.NoiseGenerator;
import com.jme3.scene.plugins.blender.textures.generating.TextureGenerator;
import com.jme3.texture.Image;

public class TextureGeneratorNoise
extends TextureGenerator {
    protected int noisedepth;

    public TextureGeneratorNoise(NoiseGenerator noiseGenerator) {
        super(noiseGenerator, Image.Format.Luminance8);
    }

    public void readData(Structure tex, BlenderContext blenderContext) {
        super.readData(tex, blenderContext);
        this.noisedepth = ((Number)tex.getFieldValue("noisedepth")).intValue();
    }

    public void getPixel(TexturePixel pixel, float x, float y, float z) {
        int random = FastMath.rand.nextInt();
        int val = random & 3;
        int loop = this.noisedepth;
        while (loop-- != 0) {
            val *= (random >>= 2) & 3;
        }
        pixel.intensity = FastMath.clamp((float)val, (float)0.0f, (float)1.0f);
        if (this.colorBand != null) {
            int colorbandIndex = (int)(pixel.intensity * 1000.0f);
            pixel.red = this.colorBand[colorbandIndex][0];
            pixel.green = this.colorBand[colorbandIndex][1];
            pixel.blue = this.colorBand[colorbandIndex][2];
            this.applyBrightnessAndContrast(this.bacd, pixel);
            pixel.alpha = this.colorBand[colorbandIndex][3];
        } else {
            this.applyBrightnessAndContrast(pixel, this.bacd.contrast, this.bacd.brightness);
        }
    }
}

