/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures.generating;

import com.jme3.math.FastMath;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.scene.plugins.blender.textures.generating.NoiseGenerator;
import com.jme3.scene.plugins.blender.textures.generating.TextureGenerator;
import com.jme3.texture.Image;

public class TextureGeneratorDistnoise
extends TextureGenerator {
    protected float noisesize;
    protected float distAmount;
    protected int noisebasis;
    protected int noisebasis2;

    public TextureGeneratorDistnoise(NoiseGenerator noiseGenerator) {
        super(noiseGenerator, Image.Format.Luminance8);
    }

    public void readData(Structure tex, BlenderContext blenderContext) {
        super.readData(tex, blenderContext);
        this.noisesize = ((Number)tex.getFieldValue("noisesize")).floatValue();
        this.distAmount = ((Number)tex.getFieldValue("dist_amount")).floatValue();
        this.noisebasis = ((Number)tex.getFieldValue("noisebasis")).intValue();
        this.noisebasis2 = ((Number)tex.getFieldValue("noisebasis2")).intValue();
    }

    public void getPixel(TexturePixel pixel, float x, float y, float z) {
        pixel.intensity = this.musgraveVariableLunacrityNoise(x * 4.0f, y * 4.0f, z * 4.0f, this.distAmount, this.noisebasis, this.noisebasis2);
        pixel.intensity = FastMath.clamp((float)pixel.intensity, (float)0.0f, (float)1.0f);
        if (this.colorBand != null) {
            int colorbandIndex = (int)(pixel.intensity * 1000.0f);
            pixel.red = this.colorBand[colorbandIndex][0];
            pixel.green = this.colorBand[colorbandIndex][1];
            pixel.blue = this.colorBand[colorbandIndex][2];
            this.applyBrightnessAndContrast(this.bacd, pixel);
        } else {
            this.applyBrightnessAndContrast(pixel, this.bacd.contrast, this.bacd.brightness);
        }
    }

    private float musgraveVariableLunacrityNoise(float x, float y, float z, float distortion, int nbas1, int nbas2) {
        NoiseGenerator.NoiseFunction abstractNoiseFunc2;
        NoiseGenerator.NoiseFunction abstractNoiseFunc1 = NoiseGenerator.noiseFunctions.get(nbas1);
        if (abstractNoiseFunc1 == null) {
            abstractNoiseFunc1 = NoiseGenerator.noiseFunctions.get(0);
        }
        if ((abstractNoiseFunc2 = NoiseGenerator.noiseFunctions.get(nbas2)) == null) {
            abstractNoiseFunc2 = NoiseGenerator.noiseFunctions.get(0);
        }
        float rx = abstractNoiseFunc1.execute(x + 13.5f, y + 13.5f, z + 13.5f) * distortion;
        float ry = abstractNoiseFunc1.execute(x, y, z) * distortion;
        float rz = abstractNoiseFunc1.execute(x - 13.5f, y - 13.5f, z - 13.5f) * distortion;
        return abstractNoiseFunc2.executeSigned(x + rx, y + ry, z + rz);
    }
}

