/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures.generating;

import com.jme3.math.FastMath;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.scene.plugins.blender.textures.generating.NoiseGenerator;
import com.jme3.scene.plugins.blender.textures.generating.TextureGenerator;
import com.jme3.texture.Image;

public class TextureGeneratorClouds
extends TextureGenerator {
    protected static final int TEX_NOISESOFT = 0;
    protected static final int TEX_NOISEPERL = 1;
    protected static final int TEX_DEFAULT = 0;
    protected static final int TEX_COLOR = 1;
    protected float noisesize;
    protected int noiseDepth;
    protected int noiseBasis;
    protected int noiseType;
    protected boolean isHard;
    protected int sType;

    public TextureGeneratorClouds(NoiseGenerator noiseGenerator) {
        super(noiseGenerator, Image.Format.Luminance8);
    }

    public void readData(Structure tex, BlenderContext blenderContext) {
        super.readData(tex, blenderContext);
        this.noisesize = ((Number)tex.getFieldValue("noisesize")).floatValue();
        this.noiseDepth = ((Number)tex.getFieldValue("noisedepth")).intValue();
        this.noiseBasis = ((Number)tex.getFieldValue("noisebasis")).intValue();
        this.noiseType = ((Number)tex.getFieldValue("noisetype")).intValue();
        this.isHard = this.noiseType != 0;
        this.sType = ((Number)tex.getFieldValue("stype")).intValue();
        if (this.sType == 1) {
            this.imageFormat = Image.Format.RGBA8;
        }
    }

    public void getPixel(TexturePixel pixel, float x, float y, float z) {
        pixel.intensity = NoiseGenerator.NoiseFunctions.turbulence(x, y, z, this.noisesize, this.noiseDepth, this.noiseBasis, this.isHard);
        pixel.intensity = FastMath.clamp((float)pixel.intensity, (float)0.0f, (float)1.0f);
        if (this.colorBand != null) {
            int colorbandIndex = (int)(pixel.intensity * 1000.0f);
            pixel.red = this.colorBand[colorbandIndex][0];
            pixel.green = this.colorBand[colorbandIndex][1];
            pixel.blue = this.colorBand[colorbandIndex][2];
            pixel.alpha = this.colorBand[colorbandIndex][3];
            this.applyBrightnessAndContrast(this.bacd, pixel);
        } else if (this.sType == 1) {
            pixel.red = pixel.intensity;
            pixel.green = NoiseGenerator.NoiseFunctions.turbulence(y, x, z, this.noisesize, this.noiseDepth, this.noiseBasis, this.isHard);
            pixel.blue = NoiseGenerator.NoiseFunctions.turbulence(y, z, x, this.noisesize, this.noiseDepth, this.noiseBasis, this.isHard);
            pixel.green = FastMath.clamp((float)pixel.green, (float)0.0f, (float)1.0f);
            pixel.blue = FastMath.clamp((float)pixel.blue, (float)0.0f, (float)1.0f);
            pixel.alpha = 1.0f;
            this.applyBrightnessAndContrast(this.bacd, pixel);
        } else {
            this.applyBrightnessAndContrast(pixel, this.bacd.contrast, this.bacd.brightness);
        }
    }
}

