/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures.generating;

import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.scene.plugins.blender.textures.generating.NoiseGenerator;
import com.jme3.scene.plugins.blender.textures.generating.TextureGenerator;
import com.jme3.texture.Image;

public final class TextureGeneratorBlend
extends TextureGenerator {
    private static final IntensityFunction[] INTENSITY_FUNCTION = new IntensityFunction[7];
    protected int stype;

    public TextureGeneratorBlend(NoiseGenerator noiseGenerator) {
        super(noiseGenerator, Image.Format.Luminance8);
    }

    public void readData(Structure tex, BlenderContext blenderContext) {
        super.readData(tex, blenderContext);
        this.stype = ((Number)tex.getFieldValue("stype")).intValue();
    }

    public void getPixel(TexturePixel pixel, float x, float y, float z) {
        pixel.intensity = INTENSITY_FUNCTION[this.stype].getIntensity(x, y, z);
        if (this.colorBand != null) {
            int colorbandIndex = (int)(pixel.intensity * 1000.0f);
            pixel.red = this.colorBand[colorbandIndex][0];
            pixel.green = this.colorBand[colorbandIndex][1];
            pixel.blue = this.colorBand[colorbandIndex][2];
            this.applyBrightnessAndContrast(this.bacd, pixel);
        } else {
            this.applyBrightnessAndContrast(pixel, this.bacd.contrast, this.bacd.brightness);
        }
    }

    static {
        TextureGeneratorBlend.INTENSITY_FUNCTION[0] = new IntensityFunction(){

            public float getIntensity(float x, float y, float z) {
                return (1.0f + x) * 0.5f;
            }
        };
        TextureGeneratorBlend.INTENSITY_FUNCTION[1] = new IntensityFunction(){

            public float getIntensity(float x, float y, float z) {
                float result = (1.0f + x) * 0.5f;
                return result * result;
            }
        };
        TextureGeneratorBlend.INTENSITY_FUNCTION[2] = new IntensityFunction(){

            public float getIntensity(float x, float y, float z) {
                float result = (1.0f + x) * 0.5f;
                if (result <= 0.0f) {
                    return 0.0f;
                }
                if (result >= 1.0f) {
                    return 1.0f;
                }
                return result * result * (3.0f - 2.0f * result);
            }
        };
        TextureGeneratorBlend.INTENSITY_FUNCTION[3] = new IntensityFunction(){

            public float getIntensity(float x, float y, float z) {
                return (2.0f + x + y) * 0.25f;
            }
        };
        TextureGeneratorBlend.INTENSITY_FUNCTION[4] = new IntensityFunction(){

            public float getIntensity(float x, float y, float z) {
                float result = 1.0f - (float)Math.sqrt(x * x + y * y + z * z);
                return result < 0.0f ? 0.0f : result;
            }
        };
        TextureGeneratorBlend.INTENSITY_FUNCTION[5] = new IntensityFunction(){

            public float getIntensity(float x, float y, float z) {
                float result = 1.0f - (float)Math.sqrt(x * x + y * y + z * z);
                return result <= 0.0f ? 0.0f : result * result;
            }
        };
        TextureGeneratorBlend.INTENSITY_FUNCTION[6] = new IntensityFunction(){

            public float getIntensity(float x, float y, float z) {
                return (float)Math.atan2(y, x) * 0.15915494f + 0.5f;
            }
        };
    }

    private static interface IntensityFunction {
        public float getIntensity(float var1, float var2, float var3);
    }
}

