/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.plugins.blender.textures.UVProjectionGenerator;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UVCoordinatesGenerator {
    private static final Logger LOGGER = Logger.getLogger(UVCoordinatesGenerator.class.getName());

    public static List<Vector2f> generateUVCoordinatesFor2DTexture(Mesh mesh, UVCoordinatesType texco, UVProjectionGenerator.UVProjectionType projection, List<Geometry> geometries) {
        ArrayList<Vector2f> result = new ArrayList<Vector2f>();
        BoundingBox bb = UVCoordinatesGenerator.getBoundingBox(geometries);
        float[] inputData = null;
        switch (texco) {
            case TEXCO_ORCO: {
                inputData = BufferUtils.getFloatArray((FloatBuffer)mesh.getFloatBuffer(VertexBuffer.Type.Position));
                break;
            }
            case TEXCO_UV: {
                Vector2f[] data = new Vector2f[]{new Vector2f(0.0f, 1.0f), new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 0.0f)};
                for (int i = 0; i < mesh.getVertexCount(); ++i) {
                    result.add(data[i % 3]);
                }
                break;
            }
            case TEXCO_NORM: {
                inputData = BufferUtils.getFloatArray((FloatBuffer)mesh.getFloatBuffer(VertexBuffer.Type.Normal));
                break;
            }
            case TEXCO_REFL: 
            case TEXCO_GLOB: 
            case TEXCO_TANGENT: 
            case TEXCO_STRESS: 
            case TEXCO_LAVECTOR: 
            case TEXCO_OBJECT: 
            case TEXCO_OSA: 
            case TEXCO_PARTICLE_OR_STRAND: 
            case TEXCO_SPEED: 
            case TEXCO_STICKY: 
            case TEXCO_VIEW: 
            case TEXCO_WINDOW: {
                LOGGER.warning("Texture coordinates type not currently supported: " + (Object)((Object)texco));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown texture coordinates value: " + (Object)((Object)texco));
            }
        }
        if (inputData != null) {
            switch (projection) {
                case PROJECTION_FLAT: {
                    inputData = UVProjectionGenerator.flatProjection(inputData, bb);
                    break;
                }
                case PROJECTION_CUBE: {
                    inputData = UVProjectionGenerator.cubeProjection(inputData, bb);
                    break;
                }
                case PROJECTION_TUBE: {
                    BoundingTube bt = UVCoordinatesGenerator.getBoundingTube(geometries);
                    inputData = UVProjectionGenerator.tubeProjection(inputData, bt);
                    break;
                }
                case PROJECTION_SPHERE: {
                    BoundingSphere bs = UVCoordinatesGenerator.getBoundingSphere(geometries);
                    inputData = UVProjectionGenerator.sphereProjection(inputData, bs);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown projection type: " + (Object)((Object)projection));
                }
            }
            for (int i = 0; i < inputData.length; i += 2) {
                result.add(new Vector2f(inputData[i], inputData[i + 1]));
            }
        }
        return result;
    }

    public static List<Vector3f> generateUVCoordinatesFor3DTexture(Mesh mesh, UVCoordinatesType texco, int[] coordinatesSwappingIndexes, List<Geometry> geometries) {
        ArrayList<Vector3f> result = new ArrayList<Vector3f>();
        BoundingBox bb = UVCoordinatesGenerator.getBoundingBox(geometries);
        float[] inputData = null;
        switch (texco) {
            case TEXCO_ORCO: {
                inputData = BufferUtils.getFloatArray((FloatBuffer)mesh.getFloatBuffer(VertexBuffer.Type.Position));
                break;
            }
            case TEXCO_UV: {
                Vector2f[] data = new Vector2f[]{new Vector2f(0.0f, 1.0f), new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 0.0f)};
                for (int i = 0; i < mesh.getVertexCount(); ++i) {
                    Vector2f uv = data[i % 3];
                    result.add(new Vector3f(uv.x, uv.y, 0.0f));
                }
                break;
            }
            case TEXCO_NORM: {
                inputData = BufferUtils.getFloatArray((FloatBuffer)mesh.getFloatBuffer(VertexBuffer.Type.Normal));
                break;
            }
            case TEXCO_REFL: 
            case TEXCO_GLOB: 
            case TEXCO_TANGENT: 
            case TEXCO_STRESS: 
            case TEXCO_LAVECTOR: 
            case TEXCO_OBJECT: 
            case TEXCO_OSA: 
            case TEXCO_PARTICLE_OR_STRAND: 
            case TEXCO_SPEED: 
            case TEXCO_STICKY: 
            case TEXCO_VIEW: 
            case TEXCO_WINDOW: {
                LOGGER.warning("Texture coordinates type not currently supported: " + (Object)((Object)texco));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown texture coordinates value: " + (Object)((Object)texco));
            }
        }
        if (inputData != null) {
            int i;
            Vector3f min = bb.getMin(null);
            float[] uvCoordsResults = new float[4];
            float[] ext = new float[]{bb.getXExtent() * 2.0f, bb.getYExtent() * 2.0f, bb.getZExtent() * 2.0f};
            for (i = 0; i < ext.length; ++i) {
                if (ext[i] != 0.0f) continue;
                ext[i] = 1.0f;
            }
            for (i = 0; i < inputData.length; i += 3) {
                uvCoordsResults[1] = (inputData[i] - min.x) / ext[0];
                uvCoordsResults[2] = (inputData[i + 1] - min.y) / ext[1];
                uvCoordsResults[3] = (inputData[i + 2] - min.z) / ext[2];
                result.add(new Vector3f(uvCoordsResults[coordinatesSwappingIndexes[0]], uvCoordsResults[coordinatesSwappingIndexes[1]], uvCoordsResults[coordinatesSwappingIndexes[2]]));
            }
        }
        return result;
    }

    public static boolean isTextureCoordinateTypeSupported(UVCoordinatesType texco) {
        switch (texco) {
            case TEXCO_ORCO: 
            case TEXCO_UV: 
            case TEXCO_NORM: {
                return true;
            }
            case TEXCO_REFL: 
            case TEXCO_GLOB: 
            case TEXCO_TANGENT: 
            case TEXCO_STRESS: 
            case TEXCO_LAVECTOR: 
            case TEXCO_OBJECT: 
            case TEXCO_OSA: 
            case TEXCO_PARTICLE_OR_STRAND: 
            case TEXCO_SPEED: 
            case TEXCO_STICKY: 
            case TEXCO_VIEW: 
            case TEXCO_WINDOW: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown texture coordinates value: " + (Object)((Object)texco));
    }

    public static BoundingBox getBoundingBox(List<Geometry> geometries) {
        BoundingBox result = null;
        for (Geometry geometry : geometries) {
            BoundingBox bb = UVCoordinatesGenerator.getBoundingBox(geometry.getMesh());
            if (result == null) {
                result = bb;
                continue;
            }
            result.merge((BoundingVolume)bb);
        }
        return result;
    }

    static BoundingBox getBoundingBox(Mesh mesh) {
        mesh.updateBound();
        BoundingVolume bv = mesh.getBound();
        if (bv instanceof BoundingBox) {
            return (BoundingBox)bv;
        }
        if (bv instanceof BoundingSphere) {
            BoundingSphere bs = (BoundingSphere)bv;
            float r = bs.getRadius();
            return new BoundingBox(bs.getCenter(), r, r, r);
        }
        throw new IllegalStateException("Unknown bounding volume type: " + bv.getClass().getName());
    }

    static BoundingSphere getBoundingSphere(List<Geometry> geometries) {
        BoundingSphere result = null;
        for (Geometry geometry : geometries) {
            BoundingSphere bs = UVCoordinatesGenerator.getBoundingSphere(geometry.getMesh());
            if (result == null) {
                result = bs;
                continue;
            }
            result.merge((BoundingVolume)bs);
        }
        return result;
    }

    static BoundingSphere getBoundingSphere(Mesh mesh) {
        mesh.updateBound();
        BoundingVolume bv = mesh.getBound();
        if (bv instanceof BoundingBox) {
            BoundingBox bb = (BoundingBox)bv;
            float r = Math.max(bb.getXExtent(), bb.getYExtent());
            r = Math.max(r, bb.getZExtent());
            return new BoundingSphere(r, bb.getCenter());
        }
        if (bv instanceof BoundingSphere) {
            return (BoundingSphere)bv;
        }
        throw new IllegalStateException("Unknown bounding volume type: " + bv.getClass().getName());
    }

    static BoundingTube getBoundingTube(Mesh mesh) {
        Vector3f center = new Vector3f();
        float maxx = -3.4028235E38f;
        float minx = Float.MAX_VALUE;
        float maxy = -3.4028235E38f;
        float miny = Float.MAX_VALUE;
        float maxz = -3.4028235E38f;
        float minz = Float.MAX_VALUE;
        FloatBuffer positions = mesh.getFloatBuffer(VertexBuffer.Type.Position);
        int limit = positions.limit();
        for (int i = 0; i < limit; i += 3) {
            float x = positions.get(i);
            float y = positions.get(i + 1);
            float z = positions.get(i + 2);
            center.addLocal(x, y, z);
            maxx = x > maxx ? x : maxx;
            minx = x < minx ? x : minx;
            maxy = y > maxy ? y : maxy;
            miny = y < miny ? y : miny;
            maxz = z > maxz ? z : maxz;
            minz = z < minz ? z : minz;
        }
        center.divideLocal((float)(limit / 3));
        float radius = Math.max(maxx - minx, maxy - miny) * 0.5f;
        return new BoundingTube(radius, maxz - minz, center);
    }

    static BoundingTube getBoundingTube(List<Geometry> geometries) {
        BoundingTube result = null;
        for (Geometry geometry : geometries) {
            BoundingTube bt = UVCoordinatesGenerator.getBoundingTube(geometry.getMesh());
            if (result == null) {
                result = bt;
                continue;
            }
            result.merge(bt);
        }
        return result;
    }

    static class BoundingTube {
        private float radius;
        private float height;
        private Vector3f center;

        public BoundingTube(float radius, float height, Vector3f center) {
            this.radius = radius;
            this.height = height;
            this.center = center;
        }

        public BoundingTube merge(BoundingTube boundingTube) {
            BoundingTube tube2;
            BoundingTube tube1;
            if (this.radius >= boundingTube.radius) {
                tube1 = this;
                tube2 = boundingTube;
            } else {
                tube1 = boundingTube;
                tube2 = this;
            }
            float r1 = tube1.radius;
            float r2 = tube2.radius;
            float minZ = Math.min(tube1.center.z - tube1.height * 0.5f, tube2.center.z - tube2.height * 0.5f);
            float maxZ = Math.max(tube1.center.z + tube1.height * 0.5f, tube2.center.z + tube2.height * 0.5f);
            float height = maxZ - minZ;
            Vector3f distance = tube2.center.subtract(tube1.center);
            Vector3f center = tube1.center.add(distance.mult(0.5f));
            distance.z = 0.0f;
            float d = distance.length();
            float radius = d <= r1 - r2 ? tube1.radius : (d + r1 + r2) * 0.5f;
            return new BoundingTube(radius, height, center);
        }

        public float getRadius() {
            return this.radius;
        }

        public float getHeight() {
            return this.height;
        }

        public Vector3f getCenter() {
            return this.center;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UVCoordinatesType {
        TEXCO_ORCO(1),
        TEXCO_REFL(2),
        TEXCO_NORM(4),
        TEXCO_GLOB(8),
        TEXCO_UV(16),
        TEXCO_OBJECT(32),
        TEXCO_LAVECTOR(64),
        TEXCO_VIEW(128),
        TEXCO_STICKY(256),
        TEXCO_OSA(512),
        TEXCO_WINDOW(1024),
        NEED_UV(2048),
        TEXCO_TANGENT(4096),
        TEXCO_PARTICLE_OR_STRAND(8192),
        TEXCO_STRESS(16384),
        TEXCO_SPEED(32768);

        public final int blenderValue;

        private UVCoordinatesType(int blenderValue) {
            this.blenderValue = blenderValue;
        }

        public static UVCoordinatesType valueOf(int blenderValue) {
            for (UVCoordinatesType coordinatesType : UVCoordinatesType.values()) {
                if (coordinatesType.blenderValue != blenderValue) continue;
                return coordinatesType;
            }
            return null;
        }
    }
}

