/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.asset.BlenderKey;
import com.jme3.asset.GeneratedTextureKey;
import com.jme3.asset.TextureKey;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.FileBlockHeader;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.ColorBand;
import com.jme3.scene.plugins.blender.textures.DDSTexelData;
import com.jme3.scene.plugins.blender.textures.GeneratedTexture;
import com.jme3.scene.plugins.blender.textures.ImageLoader;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.scene.plugins.blender.textures.generating.TextureGeneratorFactory;
import com.jme3.scene.plugins.blender.textures.io.PixelIOFactory;
import com.jme3.scene.plugins.blender.textures.io.PixelInputOutput;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.util.BufferUtils;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3tools.converters.ImageToAwt;
import jme3tools.converters.RGB565;

public class TextureHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(TextureHelper.class.getName());
    public static final int TEX_NONE = 0;
    public static final int TEX_CLOUDS = 1;
    public static final int TEX_WOOD = 2;
    public static final int TEX_MARBLE = 3;
    public static final int TEX_MAGIC = 4;
    public static final int TEX_BLEND = 5;
    public static final int TEX_STUCCI = 6;
    public static final int TEX_NOISE = 7;
    public static final int TEX_IMAGE = 8;
    public static final int TEX_PLUGIN = 9;
    public static final int TEX_ENVMAP = 10;
    public static final int TEX_MUSGRAVE = 11;
    public static final int TEX_VORONOI = 12;
    public static final int TEX_DISTNOISE = 13;
    public static final int TEX_POINTDENSITY = 14;
    public static final int TEX_VOXELDATA = 15;
    private TextureGeneratorFactory textureGeneratorFactory;

    public TextureHelper(String blenderVersion, boolean fixUpAxis) {
        super(blenderVersion, false);
        this.textureGeneratorFactory = new TextureGeneratorFactory(blenderVersion);
    }

    public Texture getTexture(Structure tex, Structure mTex, BlenderContext blenderContext) throws BlenderFileException {
        Texture result = (Texture)blenderContext.getLoadedFeature(tex.getOldMemoryAddress(), BlenderContext.LoadedFeatureDataType.LOADED_FEATURE);
        if (result != null) {
            return result;
        }
        int type = ((Number)tex.getFieldValue("type")).intValue();
        switch (type) {
            case 8: {
                Structure image;
                Pointer pImage = (Pointer)tex.getFieldValue("ima");
                if (!pImage.isNotNull() || (result = this.getTextureFromImage(image = pImage.fetchData(blenderContext.getInputStream()).get(0), blenderContext)) == null) break;
                this.applyColorbandAndColorFactors(tex, result.getImage(), blenderContext);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                result = new GeneratedTexture(tex, mTex, this.textureGeneratorFactory.createTextureGenerator(type), blenderContext);
                break;
            }
            case 0: {
                break;
            }
            case 14: {
                LOGGER.warning("Point density texture loading currently not supported!");
                break;
            }
            case 15: {
                LOGGER.warning("Voxel data texture loading currently not supported!");
                break;
            }
            case 9: 
            case 10: {
                LOGGER.log(Level.WARNING, "Unsupported texture type: {0} for texture: {1}", new Object[]{type, tex.getName()});
                break;
            }
            default: {
                throw new BlenderFileException("Unknown texture type: " + type + " for texture: " + tex.getName());
            }
        }
        if (result != null) {
            result.setName(tex.getName());
            result.setWrap(Texture.WrapMode.Repeat);
            result.setMinFilter(Texture.MinFilter.Trilinear);
            if (type != 8) {
                result.setKey((AssetKey)new GeneratedTextureKey(tex.getName()));
            }
        }
        return result;
    }

    public Image convertToNormalMapTexture(Image source, float strengthFactor) {
        BufferedImage sourceImage = ImageToAwt.convert((Image)source, (boolean)false, (boolean)false, (int)0);
        BufferedImage heightMap = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 2);
        BufferedImage bumpMap = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 2);
        ColorConvertOp gscale = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        gscale.filter(sourceImage, heightMap);
        Vector3f S = new Vector3f();
        Vector3f T = new Vector3f();
        Vector3f N = new Vector3f();
        for (int x = 0; x < bumpMap.getWidth(); ++x) {
            for (int y = 0; y < bumpMap.getHeight(); ++y) {
                S.x = 1.0f;
                S.y = 0.0f;
                S.z = strengthFactor * (float)this.getHeight(heightMap, x + 1, y) - strengthFactor * (float)this.getHeight(heightMap, x - 1, y);
                T.x = 0.0f;
                T.y = 1.0f;
                T.z = strengthFactor * (float)this.getHeight(heightMap, x, y + 1) - strengthFactor * (float)this.getHeight(heightMap, x, y - 1);
                float den = (float)Math.sqrt(S.z * S.z + T.z * T.z + 1.0f);
                N.x = -S.z;
                N.y = -T.z;
                N.z = 1.0f;
                N.divideLocal(den);
                bumpMap.setRGB(x, y, this.vectorToColor(N.x, N.y, N.z));
            }
        }
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)(source.getWidth() * source.getHeight() * 3));
        ImageToAwt.convert((BufferedImage)bumpMap, (Image.Format)Image.Format.RGB8, (ByteBuffer)byteBuffer);
        return new Image(Image.Format.RGB8, source.getWidth(), source.getHeight(), byteBuffer);
    }

    public Image decompress(Image image) {
        Image result;
        Image.Format format = image.getFormat();
        int depth = image.getDepth();
        if (depth == 0) {
            depth = 1;
        }
        ArrayList<ByteBuffer> dataArray = new ArrayList<ByteBuffer>(depth);
        int[] sizes = image.getMipMapSizes() != null ? image.getMipMapSizes() : new int[1];
        int[] newMipmapSizes = image.getMipMapSizes() != null ? new int[image.getMipMapSizes().length] : null;
        for (int dataLayerIndex = 0; dataLayerIndex < depth; ++dataLayerIndex) {
            ByteBuffer data = image.getData(dataLayerIndex);
            data.rewind();
            if (sizes.length == 1) {
                sizes[0] = data.remaining();
            }
            float widthToHeightRatio = image.getWidth() / image.getHeight();
            ArrayList<DDSTexelData> texelDataList = new ArrayList<DDSTexelData>(sizes.length);
            int maxPosition = 0;
            int resultSize = 0;
            for (int sizeIndex = 0; sizeIndex < sizes.length; ++sizeIndex) {
                maxPosition += sizes[sizeIndex];
                DDSTexelData texelData = new DDSTexelData(sizes[sizeIndex], widthToHeightRatio, format);
                texelDataList.add(texelData);
                switch (format) {
                    case DXT1: 
                    case DXT1A: {
                        TexturePixel[] colors;
                        while (data.position() < maxPosition) {
                            colors = new TexturePixel[]{new TexturePixel(), new TexturePixel(), new TexturePixel(), new TexturePixel()};
                            short c0 = data.getShort();
                            short c1 = data.getShort();
                            int col0 = RGB565.RGB565_to_ARGB8((short)c0);
                            int col1 = RGB565.RGB565_to_ARGB8((short)c1);
                            colors[0].fromARGB8(col0);
                            colors[1].fromARGB8(col1);
                            if (col0 > col1) {
                                colors[2].fromPixel(colors[0]);
                                colors[2].mult(2.0f);
                                colors[2].add(colors[1]);
                                colors[2].divide(3.0f);
                                colors[3].fromPixel(colors[1]);
                                colors[3].mult(2.0f);
                                colors[3].add(colors[0]);
                                colors[3].divide(3.0f);
                            } else {
                                colors[2].fromPixel(colors[0]);
                                colors[2].add(colors[1]);
                                colors[2].mult(0.5f);
                                colors[3].fromARGB8(0);
                            }
                            int indexes = data.getInt();
                            texelData.add(colors, indexes);
                        }
                        break;
                    }
                    case DXT3: {
                        TexturePixel[] colors;
                        while (data.position() < maxPosition) {
                            colors = new TexturePixel[]{new TexturePixel(), new TexturePixel(), new TexturePixel(), new TexturePixel()};
                            long alpha = data.getLong();
                            float[] alphas = new float[16];
                            long alphasIndex = 0L;
                            for (int i = 0; i < 16; ++i) {
                                alphasIndex |= (long)(i << i * 4);
                                byte a = (byte)((alpha >> i * 4 & 0xFL) << 4);
                                alphas[i] = a >= 0 ? (float)a / 255.0f : 1.0f - (float)(~a) / 255.0f;
                            }
                            short c0 = data.getShort();
                            short c1 = data.getShort();
                            int col0 = RGB565.RGB565_to_ARGB8((short)c0);
                            int col1 = RGB565.RGB565_to_ARGB8((short)c1);
                            colors[0].fromARGB8(col0);
                            colors[1].fromARGB8(col1);
                            colors[2].fromPixel(colors[0]);
                            colors[2].mult(2.0f);
                            colors[2].add(colors[1]);
                            colors[2].divide(3.0f);
                            colors[3].fromPixel(colors[1]);
                            colors[3].mult(2.0f);
                            colors[3].add(colors[0]);
                            colors[3].divide(3.0f);
                            int indexes = data.getInt();
                            texelData.add(colors, indexes, alphas, alphasIndex);
                        }
                        break;
                    }
                    case DXT5: {
                        float[] alphas = new float[8];
                        while (data.position() < maxPosition) {
                            TexturePixel[] colors = new TexturePixel[]{new TexturePixel(), new TexturePixel(), new TexturePixel(), new TexturePixel()};
                            alphas[0] = (float)data.get() * 255.0f;
                            alphas[1] = (float)data.get() * 255.0f;
                            long alphaIndices = data.get() | data.get() << 8 | data.get() << 16 | data.get() << 24 | data.get() << 32 | data.get() << 40;
                            if (alphas[0] > alphas[1]) {
                                alphas[2] = (6.0f * alphas[0] + alphas[1]) / 7.0f;
                                alphas[3] = (5.0f * alphas[0] + 2.0f * alphas[1]) / 7.0f;
                                alphas[4] = (4.0f * alphas[0] + 3.0f * alphas[1]) / 7.0f;
                                alphas[5] = (3.0f * alphas[0] + 4.0f * alphas[1]) / 7.0f;
                                alphas[6] = (2.0f * alphas[0] + 5.0f * alphas[1]) / 7.0f;
                                alphas[7] = (alphas[0] + 6.0f * alphas[1]) / 7.0f;
                            } else {
                                alphas[2] = (4.0f * alphas[0] + alphas[1]) * 0.2f;
                                alphas[3] = (3.0f * alphas[0] + 2.0f * alphas[1]) * 0.2f;
                                alphas[4] = (2.0f * alphas[0] + 3.0f * alphas[1]) * 0.2f;
                                alphas[5] = (alphas[0] + 4.0f * alphas[1]) * 0.2f;
                                alphas[6] = 0.0f;
                                alphas[7] = 1.0f;
                            }
                            short c0 = data.getShort();
                            short c1 = data.getShort();
                            int col0 = RGB565.RGB565_to_ARGB8((short)c0);
                            int col1 = RGB565.RGB565_to_ARGB8((short)c1);
                            colors[0].fromARGB8(col0);
                            colors[1].fromARGB8(col1);
                            colors[2].fromPixel(colors[0]);
                            colors[2].mult(2.0f);
                            colors[2].add(colors[1]);
                            colors[2].divide(3.0f);
                            colors[3].fromPixel(colors[1]);
                            colors[3].mult(2.0f);
                            colors[3].add(colors[0]);
                            colors[3].divide(3.0f);
                            int indexes = data.getInt();
                            texelData.add(colors, indexes, alphas, alphaIndices);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown compressed format: " + format);
                    }
                }
                newMipmapSizes[sizeIndex] = texelData.getSizeInBytes();
                resultSize += texelData.getSizeInBytes();
            }
            byte[] bytes = new byte[resultSize];
            int offset = 0;
            byte[] pixelBytes = new byte[4];
            for (DDSTexelData texelData : texelDataList) {
                for (int i = 0; i < texelData.getPixelWidth(); ++i) {
                    for (int j = 0; j < texelData.getPixelHeight() && texelData.getRGBA8(i, j, pixelBytes); ++j) {
                        bytes[offset + (j * texelData.getPixelWidth() + i) * 4] = pixelBytes[0];
                        bytes[offset + (j * texelData.getPixelWidth() + i) * 4 + 1] = pixelBytes[1];
                        bytes[offset + (j * texelData.getPixelWidth() + i) * 4 + 2] = pixelBytes[2];
                        bytes[offset + (j * texelData.getPixelWidth() + i) * 4 + 3] = pixelBytes[3];
                    }
                }
                offset += texelData.getSizeInBytes();
            }
            dataArray.add(BufferUtils.createByteBuffer((byte[])bytes));
        }
        Image image2 = result = depth > 1 ? new Image(Image.Format.RGBA8, image.getWidth(), image.getHeight(), depth, dataArray) : new Image(Image.Format.RGBA8, image.getWidth(), image.getHeight(), (ByteBuffer)dataArray.get(0));
        if (newMipmapSizes != null) {
            result.setMipMapSizes(newMipmapSizes);
        }
        return result;
    }

    protected int getHeight(BufferedImage image, int x, int y) {
        if (x < 0) {
            x = 0;
        } else if (x >= image.getWidth()) {
            x = image.getWidth() - 1;
        }
        if (y < 0) {
            y = 0;
        } else if (y >= image.getHeight()) {
            y = image.getHeight() - 1;
        }
        return image.getRGB(x, y) & 0xFF;
    }

    protected int vectorToColor(float x, float y, float z) {
        int r = Math.round(255.0f * (x + 1.0f) / 2.0f);
        int g = Math.round(255.0f * (y + 1.0f) / 2.0f);
        int b = Math.round(255.0f * (z + 1.0f) / 2.0f);
        return -16777216 + (r << 16) + (g << 8) + b;
    }

    public Texture getTextureFromImage(Structure image, BlenderContext blenderContext) throws BlenderFileException {
        LOGGER.log(Level.FINE, "Fetching texture with OMA = {0}", image.getOldMemoryAddress());
        Texture result = (Texture)blenderContext.getLoadedFeature(image.getOldMemoryAddress(), BlenderContext.LoadedFeatureDataType.LOADED_FEATURE);
        if (result == null) {
            String texturePath = image.getFieldValue("name").toString();
            Pointer pPackedFile = (Pointer)image.getFieldValue("packedfile");
            if (pPackedFile.isNull()) {
                LOGGER.log(Level.INFO, "Reading texture from file: {0}", texturePath);
                result = this.loadTextureFromFile(texturePath, blenderContext);
            } else {
                LOGGER.info("Packed texture. Reading directly from the blend file!");
                Structure packedFile = pPackedFile.fetchData(blenderContext.getInputStream()).get(0);
                Pointer pData = (Pointer)packedFile.getFieldValue("data");
                FileBlockHeader dataFileBlock = blenderContext.getFileBlock(pData.getOldMemoryAddress());
                blenderContext.getInputStream().setPosition(dataFileBlock.getBlockPosition());
                ImageLoader imageLoader = new ImageLoader();
                Image im = imageLoader.loadImage(blenderContext.getInputStream(), dataFileBlock.getBlockPosition(), true);
                if (im != null) {
                    result = new Texture2D(im);
                }
            }
            if (result != null) {
                result.setName(texturePath);
                result.setWrap(Texture.WrapMode.Repeat);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Adding texture {0} to the loaded features with OMA = {1}", new Object[]{texturePath, image.getOldMemoryAddress()});
                }
                blenderContext.addLoadedFeatures(image.getOldMemoryAddress(), image.getName(), image, result);
            }
        }
        return result;
    }

    public AffineTransform createAffineTransform(Vector2f[] source, Vector2f[] dest, int[] sourceSize, int[] targetSize) {
        float x11 = source[0].getX() * (float)sourceSize[0];
        float x12 = source[0].getY() * (float)sourceSize[1];
        float x21 = source[1].getX() * (float)sourceSize[0];
        float x22 = source[1].getY() * (float)sourceSize[1];
        float x31 = source[2].getX() * (float)sourceSize[0];
        float x32 = source[2].getY() * (float)sourceSize[1];
        float y11 = dest[0].getX() * (float)targetSize[0];
        float y12 = dest[0].getY() * (float)targetSize[1];
        float y21 = dest[1].getX() * (float)targetSize[0];
        float y22 = dest[1].getY() * (float)targetSize[1];
        float y31 = dest[2].getX() * (float)targetSize[0];
        float y32 = dest[2].getY() * (float)targetSize[1];
        float a1 = ((y11 - y21) * (x12 - x32) - (y11 - y31) * (x12 - x22)) / ((x11 - x21) * (x12 - x32) - (x11 - x31) * (x12 - x22));
        float a2 = ((y11 - y21) * (x11 - x31) - (y11 - y31) * (x11 - x21)) / ((x12 - x22) * (x11 - x31) - (x12 - x32) * (x11 - x21));
        float a3 = y11 - a1 * x11 - a2 * x12;
        float a4 = ((y12 - y22) * (x12 - x32) - (y12 - y32) * (x12 - x22)) / ((x11 - x21) * (x12 - x32) - (x11 - x31) * (x12 - x22));
        float a5 = ((y12 - y22) * (x11 - x31) - (y12 - y32) * (x11 - x21)) / ((x12 - x22) * (x11 - x31) - (x12 - x32) * (x11 - x21));
        float a6 = y12 - a4 * x11 - a5 * x12;
        return new AffineTransform(a1, a4, a2, a5, a3, a6);
    }

    public int getPixelPosition(float pos, int size) {
        float pixelWidth = 1.0f / (float)size;
        int result = (int)(pos *= (float)size);
        if (Math.abs((float)result - pos) > pixelWidth) {
            ++result;
        }
        return result;
    }

    public Image getSubimage(Image image, int minX, int minY, int maxX, int maxY) {
        if (minY > maxY) {
            throw new IllegalArgumentException("Minimum Y value is higher than maximum Y value!");
        }
        if (minX > maxX) {
            throw new IllegalArgumentException("Minimum Y value is higher than maximum Y value!");
        }
        if (image.getData().size() > 1) {
            throw new IllegalArgumentException("Only flat images are allowed for subimage operation!");
        }
        if (image.getMipMapSizes() != null) {
            LOGGER.warning("Subimaging image with mipmaps is not yet supported!");
        }
        int width = maxX - minX;
        int height = maxY - minY;
        ByteBuffer data = BufferUtils.createByteBuffer((int)(width * height * (image.getFormat().getBitsPerPixel() >> 3)));
        Image result = new Image(image.getFormat(), width, height, data);
        PixelInputOutput pixelIO = PixelIOFactory.getPixelIO(image.getFormat());
        TexturePixel pixel = new TexturePixel();
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                pixelIO.read(image, 0, pixel, x, y);
                pixelIO.write(result, 0, pixel, x - minX, y - minY);
            }
        }
        return result;
    }

    private void applyColorbandAndColorFactors(Structure tex, Image image, BlenderContext blenderContext) {
        block7: {
            int depth;
            float bfac;
            float gfac;
            float rfac;
            block6: {
                rfac = ((Number)tex.getFieldValue("rfac")).floatValue();
                gfac = ((Number)tex.getFieldValue("gfac")).floatValue();
                bfac = ((Number)tex.getFieldValue("bfac")).floatValue();
                float[][] colorBand = new ColorBand(tex, blenderContext).computeValues();
                int n = depth = image.getDepth() == 0 ? 1 : image.getDepth();
                if (colorBand == null) break block6;
                TexturePixel pixel = new TexturePixel();
                PixelInputOutput imageIO = PixelIOFactory.getPixelIO(image.getFormat());
                for (int layerIndex = 0; layerIndex < depth; ++layerIndex) {
                    for (int x = 0; x < image.getWidth(); ++x) {
                        for (int y = 0; y < image.getHeight(); ++y) {
                            imageIO.read(image, layerIndex, pixel, x, y);
                            int colorbandIndex = (int)(pixel.alpha * 1000.0f);
                            pixel.red = colorBand[colorbandIndex][0] * rfac;
                            pixel.green = colorBand[colorbandIndex][1] * gfac;
                            pixel.blue = colorBand[colorbandIndex][2] * bfac;
                            pixel.alpha = colorBand[colorbandIndex][3];
                            imageIO.write(image, layerIndex, pixel, x, y);
                        }
                    }
                }
                break block7;
            }
            if (rfac == 1.0f && gfac == 1.0f && bfac == 1.0f) break block7;
            TexturePixel pixel = new TexturePixel();
            PixelInputOutput imageIO = PixelIOFactory.getPixelIO(image.getFormat());
            for (int layerIndex = 0; layerIndex < depth; ++layerIndex) {
                for (int x = 0; x < image.getWidth(); ++x) {
                    for (int y = 0; y < image.getHeight(); ++y) {
                        imageIO.read(image, layerIndex, pixel, x, y);
                        pixel.red *= rfac;
                        pixel.green *= gfac;
                        pixel.blue *= bfac;
                        imageIO.write(image, layerIndex, pixel, x, y);
                    }
                }
            }
        }
    }

    protected Texture loadTextureFromFile(String name, BlenderContext blenderContext) {
        if (!name.contains(".")) {
            return null;
        }
        AssetManager assetManager = blenderContext.getAssetManager();
        name = name.replaceAll("\\\\", "\\/");
        Texture result = null;
        ArrayList<String> assetNames = new ArrayList<String>();
        if (name.startsWith("//")) {
            String relativePath = name.substring(2);
            BlenderKey blenderKey = blenderContext.getBlenderKey();
            int idx = blenderKey.getName().lastIndexOf(47);
            String blenderAssetFolder = blenderKey.getName().substring(0, idx != -1 ? idx : 0);
            assetNames.add(blenderAssetFolder + '/' + relativePath);
        } else {
            String[] paths = name.split("\\/");
            StringBuilder sb = new StringBuilder(paths[paths.length - 1]);
            assetNames.add(paths[paths.length - 1]);
            for (int i = paths.length - 2; i >= 0; --i) {
                sb.insert(0, '/');
                sb.insert(0, paths[i]);
                assetNames.add(0, sb.toString());
            }
        }
        for (String assetName : assetNames) {
            try {
                TextureKey key = new TextureKey(assetName);
                key.setGenerateMips(true);
                key.setAsCube(false);
                result = assetManager.loadTexture(key);
                break;
            }
            catch (AssetNotFoundException e) {
                LOGGER.fine(e.getLocalizedMessage());
            }
        }
        return result;
    }

    public boolean shouldBeLoaded(Structure structure, BlenderContext blenderContext) {
        return (blenderContext.getBlenderKey().getFeaturesToLoad() & 1) != 0;
    }
}

