/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.bounding.BoundingBox;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.TexturePixel;
import com.jme3.scene.plugins.blender.textures.TriangulatedTexture;
import com.jme3.scene.plugins.blender.textures.UVCoordinatesGenerator;
import com.jme3.scene.plugins.blender.textures.generating.TextureGenerator;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

class GeneratedTexture
extends Texture {
    public static final int TEX_COLORBAND = 1;
    public static final int TEX_FLIPBLEND = 2;
    public static final int TEX_NEGALPHA = 4;
    public static final int TEX_CHECKER_ODD = 8;
    public static final int TEX_CHECKER_EVEN = 16;
    public static final int TEX_PRV_ALPHA = 32;
    public static final int TEX_PRV_NOR = 64;
    public static final int TEX_REPEAT_XMIR = 128;
    public static final int TEX_REPEAT_YMIR = 256;
    public static final int TEX_FLAG_MASK = 511;
    private final Structure mTex;
    private final TextureGenerator textureGenerator;

    public GeneratedTexture(Structure tex, Structure mTex, TextureGenerator textureGenerator, BlenderContext blenderContext) {
        this.mTex = mTex;
        this.textureGenerator = textureGenerator;
        this.textureGenerator.readData(tex, blenderContext);
        super.setImage((Image)new GeneratedTextureImage(textureGenerator.getImageFormat()));
    }

    public void getPixel(TexturePixel pixel, float u, float v, float s) {
        this.textureGenerator.getPixel(pixel, u, v, s);
    }

    public TriangulatedTexture triangulate(Mesh mesh, Long geometriesOMA, UVCoordinatesGenerator.UVCoordinatesType coordinatesType, BlenderContext blenderContext) {
        List geometries = (List)blenderContext.getLoadedFeature(geometriesOMA, BlenderContext.LoadedFeatureDataType.LOADED_FEATURE);
        int[] coordinatesSwappingIndexes = new int[]{((Number)this.mTex.getFieldValue("projx")).intValue(), ((Number)this.mTex.getFieldValue("projy")).intValue(), ((Number)this.mTex.getFieldValue("projz")).intValue()};
        List<Vector3f> uvs = UVCoordinatesGenerator.generateUVCoordinatesFor3DTexture(mesh, coordinatesType, coordinatesSwappingIndexes, geometries);
        Vector3f[] uvsArray = uvs.toArray(new Vector3f[uvs.size()]);
        BoundingBox boundingBox = UVCoordinatesGenerator.getBoundingBox(geometries);
        TreeSet<TriangulatedTexture.TriangleTextureElement> triangleTextureElements = new TreeSet<TriangulatedTexture.TriangleTextureElement>(new Comparator<TriangulatedTexture.TriangleTextureElement>(){

            @Override
            public int compare(TriangulatedTexture.TriangleTextureElement o1, TriangulatedTexture.TriangleTextureElement o2) {
                return o1.faceIndex - o2.faceIndex;
            }
        });
        int[] indices = new int[3];
        for (int i = 0; i < mesh.getTriangleCount(); ++i) {
            mesh.getTriangle(i, indices);
            triangleTextureElements.add(new TriangulatedTexture.TriangleTextureElement(i, boundingBox, this, uvsArray, indices, blenderContext));
        }
        return new TriangulatedTexture(triangleTextureElements, blenderContext);
    }

    public void setWrap(Texture.WrapAxis axis, Texture.WrapMode mode) {
    }

    public void setWrap(Texture.WrapMode mode) {
    }

    public Texture.WrapMode getWrap(Texture.WrapAxis axis) {
        return null;
    }

    public Texture.Type getType() {
        return Texture.Type.ThreeDimensional;
    }

    public Texture createSimpleClone() {
        return null;
    }

    private static class GeneratedTextureImage
    extends Image {
        public GeneratedTextureImage(Image.Format imageFormat) {
            this.format = imageFormat;
        }
    }
}

