/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.particles;

import com.jme3.effect.ParticleEmitter;
import com.jme3.effect.ParticleMesh;
import com.jme3.effect.influencers.EmptyParticleInfluencer;
import com.jme3.effect.influencers.NewtonianParticleInfluencer;
import com.jme3.effect.influencers.ParticleInfluencer;
import com.jme3.effect.shapes.EmitterMeshConvexHullShape;
import com.jme3.effect.shapes.EmitterMeshFaceShape;
import com.jme3.effect.shapes.EmitterMeshVertexShape;
import com.jme3.effect.shapes.EmitterShape;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.DynamicArray;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import java.util.logging.Logger;

public class ParticlesHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(ParticlesHelper.class.getName());
    public static final int PART_EMITTER = 0;
    public static final int PART_REACTOR = 1;
    public static final int PART_HAIR = 2;
    public static final int PART_FLUID = 3;
    public static final int PART_REACT_STA_END = 1;
    public static final int PART_REACT_MULTIPLE = 2;
    public static final int PART_LOOP = 4;
    public static final int PART_HAIR_GEOMETRY = 16;
    public static final int PART_UNBORN = 32;
    public static final int PART_DIED = 64;
    public static final int PART_TRAND = 128;
    public static final int PART_EDISTR = 256;
    public static final int PART_STICKY = 512;
    public static final int PART_DIE_ON_COL = 4096;
    public static final int PART_SIZE_DEFL = 8192;
    public static final int PART_ROT_DYN = 16384;
    public static final int PART_SIZEMASS = 65536;
    public static final int PART_ABS_LENGTH = 32768;
    public static final int PART_ABS_TIME = 131072;
    public static final int PART_GLOB_TIME = 262144;
    public static final int PART_BOIDS_2D = 524288;
    public static final int PART_BRANCHING = 0x100000;
    public static final int PART_ANIM_BRANCHING = 0x200000;
    public static final int PART_SELF_EFFECT = 0x400000;
    public static final int PART_SYMM_BRANCHING = 0x1000000;
    public static final int PART_HAIR_BSPLINE = 1024;
    public static final int PART_GRID_INVERT = 0x4000000;
    public static final int PART_CHILD_EFFECT = 0x8000000;
    public static final int PART_CHILD_SEAMS = 0x10000000;
    public static final int PART_CHILD_RENDER = 0x20000000;
    public static final int PART_CHILD_GUIDE = 0x40000000;
    public static final int PART_FROM_VERT = 0;
    public static final int PART_FROM_FACE = 1;
    public static final int PART_FROM_VOLUME = 2;
    public static final int PART_FROM_PARTICLE = 3;
    public static final int PART_FROM_CHILD = 4;
    public static final int PART_PHYS_NO = 0;
    public static final int PART_PHYS_NEWTON = 1;
    public static final int PART_PHYS_KEYED = 2;
    public static final int PART_PHYS_BOIDS = 3;
    public static final int PART_DRAW_NOT = 0;
    public static final int PART_DRAW_DOT = 1;
    public static final int PART_DRAW_CIRC = 2;
    public static final int PART_DRAW_CROSS = 3;
    public static final int PART_DRAW_AXIS = 4;
    public static final int PART_DRAW_LINE = 5;
    public static final int PART_DRAW_PATH = 6;
    public static final int PART_DRAW_OB = 7;
    public static final int PART_DRAW_GR = 8;
    public static final int PART_DRAW_BB = 9;

    public ParticlesHelper(String blenderVersion, boolean fixUpAxis) {
        super(blenderVersion, fixUpAxis);
    }

    public ParticleEmitter toParticleEmitter(Structure particleSystem, BlenderContext blenderContext) throws BlenderFileException {
        ParticleEmitter result = null;
        Pointer pParticleSettings = (Pointer)particleSystem.getFieldValue("part");
        if (pParticleSettings.isNotNull()) {
            NewtonianParticleInfluencer influencer;
            char nameSuffix;
            Structure particleSettings = pParticleSettings.fetchData(blenderContext.getInputStream()).get(0);
            int totPart = ((Number)particleSettings.getFieldValue("totpart")).intValue();
            int drawAs = ((Number)particleSettings.getFieldValue("draw_as")).intValue();
            switch (drawAs) {
                case 0: {
                    nameSuffix = 'N';
                    totPart = 0;
                    break;
                }
                case 9: {
                    nameSuffix = 'B';
                    break;
                }
                case 7: 
                case 8: {
                    nameSuffix = 'P';
                    LOGGER.warning("Neither object nor group particles supported yet! Using point representation instead!");
                    break;
                }
                case 5: {
                    nameSuffix = 'L';
                    LOGGER.warning("Lines not yet supported! Using point representation instead!");
                }
                default: {
                    nameSuffix = 'P';
                }
            }
            result = new ParticleEmitter(particleSettings.getName() + nameSuffix, ParticleMesh.Type.Triangle, totPart);
            if (nameSuffix == 'N') {
                return result;
            }
            int from = ((Number)particleSettings.getFieldValue("from")).intValue();
            switch (from) {
                case 0: {
                    result.setShape((EmitterShape)new EmitterMeshVertexShape());
                    break;
                }
                case 1: {
                    result.setShape((EmitterShape)new EmitterMeshFaceShape());
                    break;
                }
                case 2: {
                    result.setShape((EmitterShape)new EmitterMeshConvexHullShape());
                    break;
                }
                default: {
                    LOGGER.warning("Default shape used! Unknown emitter shape value ('from' parameter: " + from + ')');
                }
            }
            DynamicArray acc = (DynamicArray)particleSettings.getFieldValue("acc");
            result.setGravity(-((Number)acc.get(0)).floatValue(), -((Number)acc.get(1)).floatValue(), -((Number)acc.get(2)).floatValue());
            result.setEndColor(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
            result.setStartColor(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
            float sizeFactor = nameSuffix == 'B' ? 1.0f : 0.3f;
            float size = ((Number)particleSettings.getFieldValue("size")).floatValue() * sizeFactor;
            result.setStartSize(size);
            result.setEndSize(size);
            int fps = blenderContext.getBlenderKey().getFps();
            float lifetime = ((Number)particleSettings.getFieldValue("lifetime")).floatValue() / (float)fps;
            float randlife = ((Number)particleSettings.getFieldValue("randlife")).floatValue() / (float)fps;
            result.setLowLife(lifetime * (1.0f - randlife));
            result.setHighLife(lifetime);
            int phystype = ((Number)particleSettings.getFieldValue("phystype")).intValue();
            switch (phystype) {
                case 1: {
                    influencer = new NewtonianParticleInfluencer();
                    influencer.setNormalVelocity(((Number)particleSettings.getFieldValue("normfac")).floatValue());
                    influencer.setVelocityVariation(((Number)particleSettings.getFieldValue("randfac")).floatValue());
                    influencer.setSurfaceTangentFactor(((Number)particleSettings.getFieldValue("tanfac")).floatValue());
                    influencer.setSurfaceTangentRotation(((Number)particleSettings.getFieldValue("tanphase")).floatValue());
                    break;
                }
                case 2: 
                case 3: {
                    LOGGER.warning("Boids and Keyed particles physic not yet supported! Empty influencer used!");
                }
                default: {
                    influencer = new EmptyParticleInfluencer();
                }
            }
            result.setParticleInfluencer((ParticleInfluencer)influencer);
        }
        return result;
    }

    public boolean shouldBeLoaded(Structure structure, BlenderContext blenderContext) {
        return true;
    }
}

