/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.objects;

import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.cameras.CameraHelper;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.constraints.ConstraintHelper;
import com.jme3.scene.plugins.blender.curves.CurvesHelper;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.DynamicArray;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.lights.LightHelper;
import com.jme3.scene.plugins.blender.meshes.MeshHelper;
import com.jme3.scene.plugins.blender.modifiers.Modifier;
import com.jme3.scene.plugins.blender.modifiers.ModifierHelper;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ObjectHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(ObjectHelper.class.getName());
    protected static final int OBJECT_TYPE_EMPTY = 0;
    protected static final int OBJECT_TYPE_MESH = 1;
    protected static final int OBJECT_TYPE_CURVE = 2;
    protected static final int OBJECT_TYPE_SURF = 3;
    protected static final int OBJECT_TYPE_TEXT = 4;
    protected static final int OBJECT_TYPE_METABALL = 5;
    protected static final int OBJECT_TYPE_LAMP = 10;
    protected static final int OBJECT_TYPE_CAMERA = 11;
    protected static final int OBJECT_TYPE_WAVE = 21;
    protected static final int OBJECT_TYPE_LATTICE = 22;
    protected static final int OBJECT_TYPE_ARMATURE = 25;

    public ObjectHelper(String blenderVersion, boolean fixUpAxis) {
        super(blenderVersion, fixUpAxis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Object toObject(Structure objectStructure, BlenderContext blenderContext) throws BlenderFileException {
        loadedResult = blenderContext.getLoadedFeature(objectStructure.getOldMemoryAddress(), BlenderContext.LoadedFeatureDataType.LOADED_FEATURE);
        if (loadedResult != null) {
            return loadedResult;
        }
        blenderContext.pushParent(objectStructure);
        type = ((Number)objectStructure.getFieldValue("type")).intValue();
        name = objectStructure.getName();
        ObjectHelper.LOGGER.log(Level.INFO, "Loading obejct: {0}", name);
        restrictflag = ((Number)objectStructure.getFieldValue("restrictflag")).intValue();
        visible = (restrictflag & 1) != 0;
        result = null;
        pParent = (Pointer)objectStructure.getFieldValue("parent");
        parent = blenderContext.getLoadedFeature(pParent.getOldMemoryAddress(), BlenderContext.LoadedFeatureDataType.LOADED_FEATURE);
        if (parent == null && pParent.isNotNull()) {
            parentStructure = pParent.fetchData(blenderContext.getInputStream()).get(0);
            parent = this.toObject(parentStructure, blenderContext);
        }
        t = this.getTransformation(objectStructure, blenderContext);
        try {
            switch (type) {
                case 0: {
                    ObjectHelper.LOGGER.log(Level.INFO, "Importing empty.");
                    empty = new Node(name);
                    empty.setLocalTransform(t);
                    if (parent instanceof Node) {
                        ((Node)parent).attachChild((Spatial)empty);
                    }
                    empty.updateModelBound();
                    result = empty;
                    ** break;
lbl29:
                    // 1 sources

                    break;
                }
                case 1: {
                    ObjectHelper.LOGGER.log(Level.INFO, "Importing mesh.");
                    node = new Node(name);
                    node.setCullHint(visible != false ? Spatial.CullHint.Always : Spatial.CullHint.Inherit);
                    meshHelper = (MeshHelper)blenderContext.getHelper(MeshHelper.class);
                    pMesh = (Pointer)objectStructure.getFieldValue("data");
                    meshesArray = pMesh.fetchData(blenderContext.getInputStream());
                    geometries = meshHelper.toMesh(meshesArray.get(0), blenderContext);
                    if (geometries != null) {
                        for (Geometry geometry : geometries) {
                            node.attachChild((Spatial)geometry);
                        }
                    }
                    node.setLocalTransform(t);
                    modifierHelper = (ModifierHelper)blenderContext.getHelper(ModifierHelper.class);
                    modifiers = modifierHelper.readModifiers(objectStructure, blenderContext);
                    for (Modifier modifier : modifiers) {
                        modifier.apply(node, blenderContext);
                    }
                    if (parent instanceof Node) {
                        ((Node)parent).attachChild((Spatial)node);
                    }
                    node.updateModelBound();
                    result = node;
                    ** break;
lbl56:
                    // 1 sources

                    break;
                }
                case 2: 
                case 3: {
                    ObjectHelper.LOGGER.log(Level.INFO, "Importing curve/nurb.");
                    pCurve = (Pointer)objectStructure.getFieldValue("data");
                    if (pCurve.isNotNull()) {
                        curvesHelper = (CurvesHelper)blenderContext.getHelper(CurvesHelper.class);
                        curveData = pCurve.fetchData(blenderContext.getInputStream()).get(0);
                        curves = curvesHelper.toCurve(curveData, blenderContext);
                        result = new Node(name);
                        for (Geometry curve : curves) {
                            result.attachChild((Spatial)curve);
                        }
                        result.setLocalTransform(t);
                        ** break;
                    }
lbl71:
                    // 3 sources

                    break;
                }
                case 10: {
                    ObjectHelper.LOGGER.log(Level.INFO, "Importing lamp.");
                    pLamp = (Pointer)objectStructure.getFieldValue("data");
                    if (pLamp.isNotNull()) {
                        lightHelper = (LightHelper)blenderContext.getHelper(LightHelper.class);
                        light = lightHelper.toLight((lampsArray = pLamp.fetchData(blenderContext.getInputStream())).get(0), blenderContext);
                        if (light != null) {
                            light.setName(name);
                            light.setLocalTransform(t);
                        }
                        result = light;
                        ** break;
                    }
lbl83:
                    // 3 sources

                    break;
                }
                case 11: {
                    pCamera = (Pointer)objectStructure.getFieldValue("data");
                    if (pCamera.isNotNull()) {
                        cameraHelper = (CameraHelper)blenderContext.getHelper(CameraHelper.class);
                        camerasArray = pCamera.fetchData(blenderContext.getInputStream());
                        camera = cameraHelper.toCamera(camerasArray.get(0));
                        camera.setName(name);
                        camera.setLocalTransform(t);
                        result = camera;
                        ** break;
                    }
lbl94:
                    // 3 sources

                    break;
                }
                case 25: {
                    armature = new Node(name);
                    armature.setLocalTransform(t);
                    if (parent instanceof Node) {
                        ((Node)parent).attachChild((Spatial)armature);
                    }
                    armature.updateModelBound();
                    result = armature;
                    ** break;
lbl104:
                    // 1 sources

                    break;
                }
                default: {
                    ObjectHelper.LOGGER.log(Level.WARNING, "Unknown object type: {0}", type);
                    break;
                }
            }
        }
        finally {
            blenderContext.popParent();
        }
        if (result != null) {
            blenderContext.addLoadedFeatures(objectStructure.getOldMemoryAddress(), name, objectStructure, result);
            constraintHelper = (ConstraintHelper)blenderContext.getHelper(ConstraintHelper.class);
            constraintHelper.loadConstraints(objectStructure, blenderContext);
            objectConstraints = blenderContext.getConstraints(objectStructure.getOldMemoryAddress());
            if (objectConstraints != null) {
                for (Constraint objectConstraint : objectConstraints) {
                    objectConstraint.bake();
                }
            }
            if (blenderContext.getBlenderKey().isLoadObjectProperties()) {
                properties = this.loadProperties(objectStructure, blenderContext);
                if (result instanceof Spatial && properties != null && properties.getValue() != null) {
                    this.applyProperties((Spatial)result, properties);
                }
            }
        }
        return result;
    }

    public Transform getTransformation(Structure objectStructure, BlenderContext blenderContext) {
        DynamicArray loc = (DynamicArray)objectStructure.getFieldValue("loc");
        DynamicArray size = (DynamicArray)objectStructure.getFieldValue("size");
        DynamicArray rot = (DynamicArray)objectStructure.getFieldValue("rot");
        Pointer pParent = (Pointer)objectStructure.getFieldValue("parent");
        Matrix4f parentInv = pParent.isNull() ? Matrix4f.IDENTITY : this.getMatrix(objectStructure, "parentinv");
        Matrix4f globalMatrix = new Matrix4f();
        globalMatrix.setTranslation(((Number)loc.get(0)).floatValue(), ((Number)loc.get(1)).floatValue(), ((Number)loc.get(2)).floatValue());
        globalMatrix.setRotationQuaternion(new Quaternion().fromAngles(((Number)rot.get(0)).floatValue(), ((Number)rot.get(1)).floatValue(), ((Number)rot.get(2)).floatValue()));
        Matrix4f localMatrix = parentInv.mult(globalMatrix);
        Vector3f translation = localMatrix.toTranslationVector();
        Quaternion rotation = localMatrix.toRotationQuat();
        Vector3f scale = this.getScale(parentInv).multLocal(((Number)size.get(0)).floatValue(), ((Number)size.get(1)).floatValue(), ((Number)size.get(2)).floatValue());
        if (this.fixUpAxis) {
            float y = translation.y;
            translation.y = translation.z;
            translation.z = -y;
            y = rotation.getY();
            float z = rotation.getZ();
            rotation.set(rotation.getX(), z, -y, rotation.getW());
            y = scale.y;
            scale.y = scale.z;
            scale.z = y;
        }
        Transform t = new Transform(translation, rotation);
        t.setScale(scale);
        return t;
    }

    public Matrix4f getMatrix(Structure structure, String matrixName) {
        return this.getMatrix(structure, matrixName, false);
    }

    public Matrix4f getMatrix(Structure structure, String matrixName, boolean applyFixUpAxis) {
        Matrix4f result = new Matrix4f();
        DynamicArray obmat = (DynamicArray)structure.getFieldValue(matrixName);
        int rowAndColumnSize = Math.abs((int)Math.sqrt(obmat.getTotalSize()));
        for (int i = 0; i < rowAndColumnSize; ++i) {
            for (int j = 0; j < rowAndColumnSize; ++j) {
                result.set(i, j, ((Number)obmat.get(j, i)).floatValue());
            }
        }
        if (applyFixUpAxis && this.fixUpAxis) {
            Vector3f translation = result.toTranslationVector();
            Quaternion rotation = result.toRotationQuat();
            Vector3f scale = this.getScale(result);
            float y = translation.y;
            translation.y = translation.z;
            translation.z = -y;
            y = rotation.getY();
            float z = rotation.getZ();
            rotation.set(rotation.getX(), z, -y, rotation.getW());
            y = scale.y;
            scale.y = scale.z;
            scale.z = y;
            result.loadIdentity();
            result.setTranslation(translation);
            result.setRotationQuaternion(rotation);
            result.setScale(scale);
        }
        return result;
    }

    public Vector3f getScale(Matrix4f matrix) {
        float scaleX = (float)Math.sqrt(matrix.m00 * matrix.m00 + matrix.m10 * matrix.m10 + matrix.m20 * matrix.m20);
        float scaleY = (float)Math.sqrt(matrix.m01 * matrix.m01 + matrix.m11 * matrix.m11 + matrix.m21 * matrix.m21);
        float scaleZ = (float)Math.sqrt(matrix.m02 * matrix.m02 + matrix.m12 * matrix.m12 + matrix.m22 * matrix.m22);
        return new Vector3f(scaleX, scaleY, scaleZ);
    }

    public void clearState() {
        this.fixUpAxis = false;
    }

    public boolean shouldBeLoaded(Structure structure, BlenderContext blenderContext) {
        int lay = ((Number)structure.getFieldValue("lay")).intValue();
        return (lay & blenderContext.getBlenderKey().getLayersToLoad()) != 0 && (blenderContext.getBlenderKey().getFeaturesToLoad() & 0xB) != 0;
    }
}

