/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.modifiers;

import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.animations.IpoHelper;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.modifiers.ArmatureModifier;
import com.jme3.scene.plugins.blender.modifiers.ArrayModifier;
import com.jme3.scene.plugins.blender.modifiers.MirrorModifier;
import com.jme3.scene.plugins.blender.modifiers.Modifier;
import com.jme3.scene.plugins.blender.modifiers.ObjectAnimationModifier;
import com.jme3.scene.plugins.blender.modifiers.ParticlesModifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifierHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(ModifierHelper.class.getName());

    public ModifierHelper(String blenderVersion, boolean fixUpAxis) {
        super(blenderVersion, fixUpAxis);
    }

    public Collection<Modifier> readModifiers(Structure objectStructure, BlenderContext blenderContext) throws BlenderFileException {
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        Structure modifiersListBase = (Structure)objectStructure.getFieldValue("modifiers");
        List<Structure> modifiers = modifiersListBase.evaluateListBase(blenderContext);
        for (Structure modifierStructure : modifiers) {
            Modifier modifier = null;
            if ("ArrayModifierData".equals(modifierStructure.getType())) {
                modifier = new ArrayModifier(modifierStructure, blenderContext);
            } else if ("MirrorModifierData".equals(modifierStructure.getType())) {
                modifier = new MirrorModifier(modifierStructure, blenderContext);
            } else if ("ArmatureModifierData".equals(modifierStructure.getType())) {
                modifier = new ArmatureModifier(objectStructure, modifierStructure, blenderContext);
            } else if ("ParticleSystemModifierData".equals(modifierStructure.getType())) {
                modifier = new ParticlesModifier(modifierStructure, blenderContext);
            }
            if (modifier != null) {
                result.add(modifier);
                blenderContext.addModifier(objectStructure.getOldMemoryAddress(), modifier);
                continue;
            }
            LOGGER.log(Level.WARNING, "Unsupported modifier type: {0}", modifierStructure.getType());
        }
        Modifier modifier = this.blenderVersion <= 249 ? this.readAnimationModifier249(objectStructure, blenderContext) : this.readAnimationModifier250(objectStructure, blenderContext);
        if (modifier != null) {
            result.add(modifier);
        }
        return result;
    }

    @Override
    public boolean shouldBeLoaded(Structure structure, BlenderContext blenderContext) {
        return true;
    }

    private Modifier readAnimationModifier249(Structure objectStructure, BlenderContext blenderContext) throws BlenderFileException {
        ObjectAnimationModifier result = null;
        Pointer pIpo = (Pointer)objectStructure.getFieldValue("ipo");
        if (pIpo.isNotNull()) {
            IpoHelper ipoHelper = (IpoHelper)blenderContext.getHelper(IpoHelper.class);
            Structure ipoStructure = pIpo.fetchData(blenderContext.getInputStream()).get(0);
            Ipo ipo = ipoHelper.fromIpoStructure(ipoStructure, blenderContext);
            result = new ObjectAnimationModifier(ipo, objectStructure.getName(), objectStructure.getOldMemoryAddress(), blenderContext);
            blenderContext.addModifier(objectStructure.getOldMemoryAddress(), result);
        }
        return result;
    }

    private Modifier readAnimationModifier250(Structure objectStructure, BlenderContext blenderContext) throws BlenderFileException {
        Structure animData;
        Pointer pAction;
        ObjectAnimationModifier result = null;
        Pointer pAnimData = (Pointer)objectStructure.getFieldValue("adt");
        if (pAnimData.isNotNull() && (pAction = (Pointer)(animData = pAnimData.fetchData(blenderContext.getInputStream()).get(0)).getFieldValue("action")).isNotNull()) {
            Structure actionStructure = pAction.fetchData(blenderContext.getInputStream()).get(0);
            IpoHelper ipoHelper = (IpoHelper)blenderContext.getHelper(IpoHelper.class);
            Ipo ipo = ipoHelper.fromAction(actionStructure, blenderContext);
            result = new ObjectAnimationModifier(ipo, actionStructure.getName(), objectStructure.getOldMemoryAddress(), blenderContext);
            blenderContext.addModifier(objectStructure.getOldMemoryAddress(), result);
        }
        return result;
    }
}

