/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.meshes;

import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.DynamicArray;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.materials.MaterialContext;
import com.jme3.scene.plugins.blender.materials.MaterialHelper;
import com.jme3.scene.plugins.blender.meshes.MeshBuilder;
import com.jme3.scene.plugins.blender.meshes.MeshContext;
import com.jme3.scene.plugins.blender.objects.Properties;
import com.jme3.util.BufferUtils;
import java.nio.Buffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeshHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(MeshHelper.class.getName());

    public MeshHelper(String blenderVersion, boolean fixUpAxis) {
        super(blenderVersion, fixUpAxis);
    }

    public List<Geometry> toMesh(Structure structure, BlenderContext blenderContext) throws BlenderFileException {
        ArrayList<Object> geometries = (ArrayList<Geometry>)blenderContext.getLoadedFeature(structure.getOldMemoryAddress(), BlenderContext.LoadedFeatureDataType.LOADED_FEATURE);
        if (geometries != null) {
            ArrayList<Geometry> copiedGeometries = new ArrayList<Geometry>(geometries.size());
            for (Geometry geometry : geometries) {
                copiedGeometries.add(geometry.clone());
            }
            return copiedGeometries;
        }
        String name = structure.getName();
        MeshContext meshContext = new MeshContext();
        MaterialHelper materialHelper = (MaterialHelper)blenderContext.getHelper(MaterialHelper.class);
        MaterialContext[] materials = null;
        if ((blenderContext.getBlenderKey().getFeaturesToLoad() & 3) != 0) {
            materials = materialHelper.getMaterials(structure, blenderContext);
        }
        Vector3f[][] verticesAndNormals = this.getVerticesAndNormals(structure, blenderContext);
        List<byte[]> verticesColors = this.getVerticesColors(structure, blenderContext);
        MeshBuilder meshBuilder = new MeshBuilder(verticesAndNormals, verticesColors, this.areGeneratedTexturesPresent(materials));
        if (this.isBMeshCompatible(structure)) {
            this.readBMesh(meshBuilder, structure, blenderContext);
        } else {
            this.readTraditionalFaces(meshBuilder, structure, blenderContext);
        }
        if (meshBuilder.isEmpty()) {
            geometries = new ArrayList<Geometry>(0);
            blenderContext.addLoadedFeatures(structure.getOldMemoryAddress(), structure.getName(), structure, geometries);
            blenderContext.setMeshContext(structure.getOldMemoryAddress(), meshContext);
            return geometries;
        }
        meshContext.setVertexReferenceMap(meshBuilder.getVertexReferenceMap());
        Structure parent = blenderContext.peekParent();
        Structure defbase = (Structure)parent.getFieldValue("defbase");
        List<Structure> defs = defbase.evaluateListBase(blenderContext);
        String[] verticesGroups = new String[defs.size()];
        int defIndex = 0;
        for (Structure def : defs) {
            verticesGroups[defIndex++] = def.getFieldValue("name").toString();
        }
        geometries = new ArrayList(meshBuilder.getMeshesPartAmount());
        Properties properties = this.loadProperties(structure, blenderContext);
        for (Map.Entry<Integer, List<Integer>> entry : meshBuilder.getMeshesMap().entrySet()) {
            int i;
            Object[] indices;
            int n = entry.getKey();
            Mesh mesh = new Mesh();
            List<Integer> indexList = entry.getValue();
            if (meshBuilder.getVerticesAmount(n) <= Short.MAX_VALUE) {
                indices = new short[indexList.size()];
                for (i = 0; i < indexList.size(); ++i) {
                    indices[i] = indexList.get(i).shortValue();
                }
                mesh.setBuffer(VertexBuffer.Type.Index, 1, indices);
            } else {
                indices = new int[indexList.size()];
                for (i = 0; i < indexList.size(); ++i) {
                    indices[i] = indexList.get(i);
                }
                mesh.setBuffer(VertexBuffer.Type.Index, 1, (int[])indices);
            }
            VertexBuffer verticesBuffer = new VertexBuffer(VertexBuffer.Type.Position);
            verticesBuffer.setupData(VertexBuffer.Usage.Static, 3, VertexBuffer.Format.Float, (Buffer)BufferUtils.createFloatBuffer((Vector3f[])meshBuilder.getVertices(n)));
            VertexBuffer verticesBind = new VertexBuffer(VertexBuffer.Type.BindPosePosition);
            verticesBind.setupData(VertexBuffer.Usage.CpuOnly, 3, VertexBuffer.Format.Float, BufferUtils.clone((Buffer)verticesBuffer.getData()));
            VertexBuffer normalsBuffer = new VertexBuffer(VertexBuffer.Type.Normal);
            normalsBuffer.setupData(VertexBuffer.Usage.Static, 3, VertexBuffer.Format.Float, (Buffer)BufferUtils.createFloatBuffer((Vector3f[])meshBuilder.getNormals(n)));
            VertexBuffer normalsBind = new VertexBuffer(VertexBuffer.Type.BindPoseNormal);
            normalsBind.setupData(VertexBuffer.Usage.CpuOnly, 3, VertexBuffer.Format.Float, BufferUtils.clone((Buffer)normalsBuffer.getData()));
            mesh.setBuffer(verticesBuffer);
            meshContext.setBindPoseBuffer(verticesBind);
            if (verticesColors != null) {
                mesh.setBuffer(VertexBuffer.Type.Color, 4, meshBuilder.getVertexColorsBuffer(n));
                mesh.getBuffer(VertexBuffer.Type.Color).setNormalized(true);
            }
            mesh.setBuffer(normalsBuffer);
            meshContext.setBindNormalBuffer(normalsBind);
            Geometry geometry = new Geometry(name + (geometries.size() + 1), mesh);
            if (properties != null && properties.getValue() != null) {
                this.applyProperties((Spatial)geometry, properties);
            }
            geometries.add(geometry);
            meshContext.putGeometry(n, geometry);
        }
        blenderContext.addLoadedFeatures(structure.getOldMemoryAddress(), structure.getName(), structure, geometries);
        blenderContext.setMeshContext(structure.getOldMemoryAddress(), meshContext);
        if (materials != null) {
            for (Geometry geometry : geometries) {
                int n = meshContext.getMaterialIndex(geometry);
                if (materials[n] != null) {
                    List<Vector2f> uvCoordinates = meshBuilder.getUVCoordinates(n);
                    MaterialContext materialContext = materials[n];
                    materialContext.applyMaterial(geometry, structure.getOldMemoryAddress(), uvCoordinates, blenderContext);
                    continue;
                }
                geometry.setMaterial(blenderContext.getDefaultMaterial());
                LOGGER.warning("The importer came accross mesh that points to a null material. Default material is used to prevent loader from crashing, but the model might look not the way it should. Sometimes blender does not assign materials properly. Enter the edit mode and assign materials once more to your faces.");
            }
        } else {
            VertexBuffer uvCoordsBuffer = null;
            if (meshBuilder.hasUVCoordinates()) {
                List<Vector2f> list = meshBuilder.getUVCoordinates(0);
                uvCoordsBuffer = new VertexBuffer(VertexBuffer.Type.TexCoord);
                uvCoordsBuffer.setupData(VertexBuffer.Usage.Static, 2, VertexBuffer.Format.Float, (Buffer)BufferUtils.createFloatBuffer((Vector2f[])list.toArray(new Vector2f[list.size()])));
            }
            for (Geometry geometry : geometries) {
                geometry.setMaterial(blenderContext.getDefaultMaterial());
                if (uvCoordsBuffer == null) continue;
                geometry.getMesh().setBuffer(uvCoordsBuffer);
            }
        }
        return geometries;
    }

    private boolean isBMeshCompatible(Structure meshStructure) {
        Pointer pMLoop = (Pointer)meshStructure.getFieldValue("mloop");
        Pointer pMPoly = (Pointer)meshStructure.getFieldValue("mpoly");
        return pMLoop != null && pMPoly != null;
    }

    private void readBMesh(MeshBuilder meshBuilder, Structure meshStructure, BlenderContext blenderContext) throws BlenderFileException {
        Pointer pMLoop = (Pointer)meshStructure.getFieldValue("mloop");
        Pointer pMPoly = (Pointer)meshStructure.getFieldValue("mpoly");
        Pointer pMEdge = (Pointer)meshStructure.getFieldValue("medge");
        Pointer pMLoopUV = (Pointer)meshStructure.getFieldValue("mloopuv");
        Vector2f[] uvCoordinatesForFace = new Vector2f[3];
        if (pMPoly.isNotNull() && pMLoop.isNotNull() && pMEdge.isNotNull()) {
            int faceIndex = 0;
            List<Structure> polys = pMPoly.fetchData(blenderContext.getInputStream());
            List<Structure> loops = pMLoop.fetchData(blenderContext.getInputStream());
            List<Structure> loopuvs = pMLoopUV.isNotNull() ? pMLoopUV.fetchData(blenderContext.getInputStream()) : null;
            for (Structure poly : polys) {
                int i;
                int materialNumber = ((Number)poly.getFieldValue("mat_nr")).intValue();
                int loopStart = ((Number)poly.getFieldValue("loopstart")).intValue();
                int totLoop = ((Number)poly.getFieldValue("totloop")).intValue();
                boolean smooth = (((Number)poly.getFieldValue("flag")).byteValue() & 1) != 0;
                int[] vertexIndexes = new int[totLoop];
                Vector2f[] uvs = loopuvs != null ? new Vector2f[totLoop] : null;
                for (i = loopStart; i < loopStart + totLoop; ++i) {
                    vertexIndexes[i - loopStart] = ((Number)loops.get(i).getFieldValue("v")).intValue();
                    if (uvs == null) continue;
                    DynamicArray loopUVS = (DynamicArray)loopuvs.get(i).getFieldValue("uv");
                    uvs[i - loopStart] = new Vector2f(((Number)loopUVS.get(0)).floatValue(), ((Number)loopUVS.get(1)).floatValue());
                }
                for (i = 0; i < totLoop - 2; ++i) {
                    int v1 = vertexIndexes[0];
                    int v2 = vertexIndexes[i + 1];
                    int v3 = vertexIndexes[i + 2];
                    if (uvs != null) {
                        uvCoordinatesForFace[0] = uvs[0];
                        uvCoordinatesForFace[1] = uvs[i + 1];
                        uvCoordinatesForFace[2] = uvs[i + 2];
                    }
                    meshBuilder.appendFace(v1, v2, v3, smooth, materialNumber, uvs == null ? null : uvCoordinatesForFace, false, faceIndex);
                }
                ++faceIndex;
            }
        }
    }

    private void readTraditionalFaces(MeshBuilder meshBuilder, Structure meshStructure, BlenderContext blenderContext) throws BlenderFileException {
        block7: {
            List<Structure> mEdges;
            block6: {
                List<Structure> mFaces;
                Pointer pMFace = (Pointer)meshStructure.getFieldValue("mface");
                List<Structure> list = mFaces = pMFace.isNotNull() ? pMFace.fetchData(blenderContext.getInputStream()) : null;
                if (mFaces == null || mFaces.size() <= 0) break block6;
                Pointer pMTFace = (Pointer)meshStructure.getFieldValue("mtface");
                List<Structure> mtFaces = null;
                if (pMTFace.isNotNull()) {
                    mtFaces = pMTFace.fetchData(blenderContext.getInputStream());
                    int facesAmount = ((Number)meshStructure.getFieldValue("totface")).intValue();
                    if (mtFaces.size() != facesAmount) {
                        throw new BlenderFileException("The amount of faces uv coordinates is not equal to faces amount!");
                    }
                }
                Vector2f[] uvCoordinatesForFace = new Vector2f[3];
                for (int i = 0; i < mFaces.size(); ++i) {
                    Structure mFace = mFaces.get(i);
                    int materialNumber = ((Number)mFace.getFieldValue("mat_nr")).intValue();
                    boolean smooth = (((Number)mFace.getFieldValue("flag")).byteValue() & 1) != 0;
                    DynamicArray uvs = null;
                    if (mtFaces != null) {
                        Structure mtFace = mtFaces.get(i);
                        uvs = (DynamicArray)mtFace.getFieldValue("uv");
                        uvCoordinatesForFace[0] = new Vector2f(((Number)uvs.get(0, 0)).floatValue(), ((Number)uvs.get(0, 1)).floatValue());
                        uvCoordinatesForFace[1] = new Vector2f(((Number)uvs.get(1, 0)).floatValue(), ((Number)uvs.get(1, 1)).floatValue());
                        uvCoordinatesForFace[2] = new Vector2f(((Number)uvs.get(2, 0)).floatValue(), ((Number)uvs.get(2, 1)).floatValue());
                    }
                    int v1 = ((Number)mFace.getFieldValue("v1")).intValue();
                    int v2 = ((Number)mFace.getFieldValue("v2")).intValue();
                    int v3 = ((Number)mFace.getFieldValue("v3")).intValue();
                    int v4 = ((Number)mFace.getFieldValue("v4")).intValue();
                    meshBuilder.appendFace(v1, v2, v3, smooth, materialNumber, uvs == null ? null : uvCoordinatesForFace, false, i);
                    if (v4 <= 0) continue;
                    if (uvs != null) {
                        uvCoordinatesForFace[0] = new Vector2f(((Number)uvs.get(0, 0)).floatValue(), ((Number)uvs.get(0, 1)).floatValue());
                        uvCoordinatesForFace[1] = new Vector2f(((Number)uvs.get(2, 0)).floatValue(), ((Number)uvs.get(2, 1)).floatValue());
                        uvCoordinatesForFace[2] = new Vector2f(((Number)uvs.get(3, 0)).floatValue(), ((Number)uvs.get(3, 1)).floatValue());
                    }
                    meshBuilder.appendFace(v1, v3, v4, smooth, materialNumber, uvs == null ? null : uvCoordinatesForFace, true, i);
                }
                break block7;
            }
            Pointer pMEdge = (Pointer)meshStructure.getFieldValue("medge");
            List<Structure> list = mEdges = pMEdge.isNotNull() ? pMEdge.fetchData(blenderContext.getInputStream()) : null;
            if (mEdges == null || mEdges.size() <= 0) break block7;
            for (int i = 0; i < mEdges.size(); ++i) {
                Structure mEdge = mEdges.get(i);
                boolean smooth = (((Number)mEdge.getFieldValue("flag")).byteValue() & 1) != 0;
                int v1 = ((Number)mEdge.getFieldValue("v1")).intValue();
                int v2 = ((Number)mEdge.getFieldValue("v2")).intValue();
                meshBuilder.appendEdge(v1, v2, smooth);
            }
        }
    }

    private boolean areGeneratedTexturesPresent(MaterialContext[] materials) {
        if (materials != null) {
            for (MaterialContext material : materials) {
                if (material == null || !material.hasGeneratedTextures()) continue;
                return true;
            }
        }
        return false;
    }

    public List<byte[]> getVerticesColors(Structure meshStructure, BlenderContext blenderContext) throws BlenderFileException {
        Pointer pMCol = (Pointer)meshStructure.getFieldValue("mcol");
        ArrayList<byte[]> verticesColors = null;
        List<Structure> mCol = null;
        if (pMCol.isNotNull()) {
            verticesColors = new ArrayList<byte[]>();
            mCol = pMCol.fetchData(blenderContext.getInputStream());
            for (Structure color : mCol) {
                byte r = ((Number)color.getFieldValue("r")).byteValue();
                byte g = ((Number)color.getFieldValue("g")).byteValue();
                byte b = ((Number)color.getFieldValue("b")).byteValue();
                byte a = ((Number)color.getFieldValue("a")).byteValue();
                verticesColors.add(new byte[]{b, g, r, a});
            }
        }
        return verticesColors;
    }

    private Vector3f[][] getVerticesAndNormals(Structure meshStructure, BlenderContext blenderContext) throws BlenderFileException {
        int count = ((Number)meshStructure.getFieldValue("totvert")).intValue();
        Vector3f[][] result = new Vector3f[count][2];
        if (count == 0) {
            return result;
        }
        Pointer pMVert = (Pointer)meshStructure.getFieldValue("mvert");
        List<Structure> mVerts = pMVert.fetchData(blenderContext.getInputStream());
        if (this.fixUpAxis) {
            for (int i = 0; i < count; ++i) {
                DynamicArray coordinates = (DynamicArray)mVerts.get(i).getFieldValue("co");
                result[i][0] = new Vector3f(((Number)coordinates.get(0)).floatValue(), ((Number)coordinates.get(2)).floatValue(), -((Number)coordinates.get(1)).floatValue());
                DynamicArray normals = (DynamicArray)mVerts.get(i).getFieldValue("no");
                result[i][1] = new Vector3f((float)((Number)normals.get(0)).shortValue() / 32767.0f, (float)((Number)normals.get(2)).shortValue() / 32767.0f, (float)(-((Number)normals.get(1)).shortValue()) / 32767.0f);
            }
        } else {
            for (int i = 0; i < count; ++i) {
                DynamicArray coordinates = (DynamicArray)mVerts.get(i).getFieldValue("co");
                result[i][0] = new Vector3f(((Number)coordinates.get(0)).floatValue(), ((Number)coordinates.get(1)).floatValue(), ((Number)coordinates.get(2)).floatValue());
                DynamicArray normals = (DynamicArray)mVerts.get(i).getFieldValue("no");
                result[i][1] = new Vector3f((float)((Number)normals.get(0)).shortValue() / 32767.0f, (float)((Number)normals.get(1)).shortValue() / 32767.0f, (float)((Number)normals.get(2)).shortValue() / 32767.0f);
            }
        }
        return result;
    }

    @Override
    public boolean shouldBeLoaded(Structure structure, BlenderContext blenderContext) {
        return true;
    }
}

