/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.meshes;

import com.jme3.scene.Geometry;
import com.jme3.scene.VertexBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeshContext {
    private Map<Integer, Geometry> geometries = new HashMap<Integer, Geometry>();
    private Map<Integer, Map<Integer, List<Integer>>> vertexReferenceMap;
    private Map<Geometry, VertexBuffer> uvCoordinates = new HashMap<Geometry, VertexBuffer>();
    private VertexBuffer bindPoseBuffer;
    private VertexBuffer bindNormalBuffer;

    public void putGeometry(Integer materialIndex, Geometry geometry) {
        this.geometries.put(materialIndex, geometry);
    }

    public int getVertexCount(int materialIndex) {
        return this.geometries.get(materialIndex).getVertexCount();
    }

    public int getMaterialIndex(Geometry geometry) {
        for (Map.Entry<Integer, Geometry> entry : this.geometries.entrySet()) {
            if (!entry.getValue().equals(geometry)) continue;
            return entry.getKey();
        }
        throw new IllegalStateException("Cannot find material index for the given geometry: " + geometry);
    }

    public Map<Integer, List<Integer>> getVertexReferenceMap(int materialIndex) {
        return this.vertexReferenceMap.get(materialIndex);
    }

    public void setVertexReferenceMap(Map<Integer, Map<Integer, List<Integer>>> vertexReferenceMap) {
        this.vertexReferenceMap = vertexReferenceMap;
    }

    public void addUVCoordinates(Geometry geometry, VertexBuffer vertexBuffer) {
        this.uvCoordinates.put(geometry, vertexBuffer);
    }

    public VertexBuffer getUVCoordinates(Geometry geometry) {
        return this.uvCoordinates.get(geometry);
    }

    public void setBindNormalBuffer(VertexBuffer bindNormalBuffer) {
        this.bindNormalBuffer = bindNormalBuffer;
    }

    public VertexBuffer getBindNormalBuffer() {
        return this.bindNormalBuffer;
    }

    public void setBindPoseBuffer(VertexBuffer bindPoseBuffer) {
        this.bindPoseBuffer = bindPoseBuffer;
    }

    public VertexBuffer getBindPoseBuffer() {
        return this.bindPoseBuffer;
    }
}

