/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.curves;

import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.FastMath;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Spline;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.curves.BezierCurve;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.BlenderInputStream;
import com.jme3.scene.plugins.blender.file.DynamicArray;
import com.jme3.scene.plugins.blender.file.FileBlockHeader;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.materials.MaterialContext;
import com.jme3.scene.plugins.blender.materials.MaterialHelper;
import com.jme3.scene.plugins.blender.objects.Properties;
import com.jme3.scene.shape.Curve;
import com.jme3.scene.shape.Surface;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurvesHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(CurvesHelper.class.getName());
    protected int minimumBasisUFunctionDegree = 4;
    protected int minimumBasisVFunctionDegree = 4;

    public CurvesHelper(String blenderVersion, boolean fixUpAxis) {
        super(blenderVersion, fixUpAxis);
    }

    public List<Geometry> toCurve(Structure curveStructure, BlenderContext blenderContext) throws BlenderFileException {
        boolean isBack;
        String name = curveStructure.getName();
        int flag = ((Number)curveStructure.getFieldValue("flag")).intValue();
        boolean is3D = (flag & 1) != 0;
        boolean isFront = (flag & 2) != 0 && !is3D;
        boolean bl = isBack = (flag & 4) != 0 && !is3D;
        if (isFront) {
            LOGGER.warning("No front face in curve implemented yet!");
        }
        if (isBack) {
            LOGGER.warning("No back face in curve implemented yet!");
        }
        List<Structure> nurbStructures = ((Structure)curveStructure.getFieldValue("nurb")).evaluateListBase(blenderContext);
        HashMap<Number, ArrayList<Structure>> nurbs = new HashMap<Number, ArrayList<Structure>>();
        for (Structure nurb : nurbStructures) {
            Number matNumber = (Number)nurb.getFieldValue("mat_nr");
            ArrayList<Structure> nurbList = (ArrayList<Structure>)nurbs.get(matNumber);
            if (nurbList == null) {
                nurbList = new ArrayList<Structure>();
                nurbs.put(matNumber, nurbList);
            }
            nurbList.add(nurb);
        }
        MaterialHelper materialHelper = (MaterialHelper)blenderContext.getHelper(MaterialHelper.class);
        MaterialContext[] materialContexts = materialHelper.getMaterials(curveStructure, blenderContext);
        Material defaultMaterial = null;
        if (materialContexts != null) {
            for (MaterialContext materialContext : materialContexts) {
                materialContext.setFaceCullMode(RenderState.FaceCullMode.Off);
            }
        } else {
            defaultMaterial = blenderContext.getDefaultMaterial().clone();
            defaultMaterial.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
        }
        List<Geometry> bevelObject = null;
        Pointer pBevelObject = (Pointer)curveStructure.getFieldValue("bevobj");
        if (pBevelObject.isNotNull()) {
            Pointer pBevelStructure = (Pointer)pBevelObject.fetchData(blenderContext.getInputStream()).get(0).getFieldValue("data");
            Structure bevelStructure = pBevelStructure.fetchData(blenderContext.getInputStream()).get(0);
            bevelObject = this.toCurve(bevelStructure, blenderContext);
        } else {
            int bevResol = ((Number)curveStructure.getFieldValue("bevresol")).intValue();
            float extrude = ((Number)curveStructure.getFieldValue("ext1")).floatValue();
            float bevelDepth = ((Number)curveStructure.getFieldValue("ext2")).floatValue();
            if (bevelDepth > 0.0f) {
                float handlerLength = bevelDepth / 2.0f;
                ArrayList<Vector3f> conrtolPoints = new ArrayList<Vector3f>(extrude > 0.0f ? 19 : 13);
                conrtolPoints.add(new Vector3f(-bevelDepth, extrude, 0.0f));
                conrtolPoints.add(new Vector3f(-bevelDepth, handlerLength + extrude, 0.0f));
                conrtolPoints.add(new Vector3f(-handlerLength, bevelDepth + extrude, 0.0f));
                conrtolPoints.add(new Vector3f(0.0f, bevelDepth + extrude, 0.0f));
                conrtolPoints.add(new Vector3f(handlerLength, bevelDepth + extrude, 0.0f));
                conrtolPoints.add(new Vector3f(bevelDepth, extrude + handlerLength, 0.0f));
                conrtolPoints.add(new Vector3f(bevelDepth, extrude, 0.0f));
                conrtolPoints.add(new Vector3f(bevelDepth, extrude - handlerLength, 0.0f));
                if (extrude > 0.0f) {
                    conrtolPoints.add(new Vector3f(bevelDepth, -extrude + handlerLength, 0.0f));
                    conrtolPoints.add(new Vector3f(bevelDepth, -extrude, 0.0f));
                    conrtolPoints.add(new Vector3f(bevelDepth, -extrude - handlerLength, 0.0f));
                }
                conrtolPoints.add(new Vector3f(handlerLength, -bevelDepth - extrude, 0.0f));
                conrtolPoints.add(new Vector3f(0.0f, -bevelDepth - extrude, 0.0f));
                conrtolPoints.add(new Vector3f(-handlerLength, -bevelDepth - extrude, 0.0f));
                conrtolPoints.add(new Vector3f(-bevelDepth, -handlerLength - extrude, 0.0f));
                conrtolPoints.add(new Vector3f(-bevelDepth, -extrude, 0.0f));
                if (extrude > 0.0f) {
                    conrtolPoints.add(new Vector3f(-bevelDepth, handlerLength - extrude, 0.0f));
                    conrtolPoints.add(new Vector3f(-bevelDepth, -handlerLength + extrude, 0.0f));
                    conrtolPoints.add(new Vector3f(-bevelDepth, extrude, 0.0f));
                }
                Spline bevelSpline = new Spline(Spline.SplineType.Bezier, conrtolPoints, 0.0f, false);
                Curve bevelCurve = new Curve(bevelSpline, bevResol);
                bevelObject = new ArrayList<Geometry>(1);
                bevelObject.add(new Geometry("", (Mesh)bevelCurve));
            } else if (extrude > 0.0f) {
                Spline bevelSpline = new Spline(Spline.SplineType.Linear, new Vector3f[]{new Vector3f(0.0f, extrude, 0.0f), new Vector3f(0.0f, -extrude, 0.0f)}, 1.0f, false);
                Curve bevelCurve = new Curve(bevelSpline, bevResol);
                bevelObject = new ArrayList<Geometry>(1);
                bevelObject.add(new Geometry("", (Mesh)bevelCurve));
            }
        }
        Curve taperObject = null;
        Pointer pTaperObject = (Pointer)curveStructure.getFieldValue("taperobj");
        if (bevelObject != null && pTaperObject.isNotNull()) {
            Pointer pTaperStructure = (Pointer)pTaperObject.fetchData(blenderContext.getInputStream()).get(0).getFieldValue("data");
            Structure taperStructure = pTaperStructure.fetchData(blenderContext.getInputStream()).get(0);
            taperObject = this.loadTaperObject(taperStructure, blenderContext);
        }
        Vector3f loc = this.getLoc(curveStructure);
        ArrayList<Geometry> result = new ArrayList<Geometry>(nurbs.size());
        for (Map.Entry nurbEntry : nurbs.entrySet()) {
            for (Structure nurb : (List)nurbEntry.getValue()) {
                int type = ((Number)nurb.getFieldValue("type")).intValue();
                List<Geometry> nurbGeoms = null;
                if ((type & 1) != 0) {
                    nurbGeoms = this.loadBezierCurve(loc, nurb, bevelObject, taperObject, blenderContext);
                } else if ((type & 4) != 0) {
                    nurbGeoms = this.loadNurb(loc, nurb, bevelObject, taperObject, blenderContext);
                }
                if (nurbGeoms == null) continue;
                for (Geometry nurbGeom : nurbGeoms) {
                    if (materialContexts != null) {
                        materialContexts[((Number)nurbEntry.getKey()).intValue()].applyMaterial(nurbGeom, curveStructure.getOldMemoryAddress(), null, blenderContext);
                    } else {
                        nurbGeom.setMaterial(defaultMaterial);
                    }
                    nurbGeom.setName(name);
                    result.add(nurbGeom);
                }
            }
        }
        Properties properties = this.loadProperties(curveStructure, blenderContext);
        if (properties != null && properties.getValue() != null) {
            for (Geometry geom : result) {
                geom.setUserData("properties", (Object)properties);
            }
        }
        return result;
    }

    protected List<Geometry> loadBezierCurve(Vector3f loc, Structure nurb, List<Geometry> bevelObject, Curve taperObject, BlenderContext blenderContext) throws BlenderFileException {
        Pointer pBezierTriple = (Pointer)nurb.getFieldValue("bezt");
        List<Geometry> result = new ArrayList<Geometry>();
        if (pBezierTriple.isNotNull()) {
            boolean smooth = (((Number)nurb.getFlatFieldValue("flag")).intValue() & 1) != 0;
            int resolution = ((Number)nurb.getFieldValue("resolu")).intValue();
            boolean cyclic = (((Number)nurb.getFieldValue("flagu")).intValue() & 1) != 0;
            BezierCurve bezierCurve = new BezierCurve(0, pBezierTriple.fetchData(blenderContext.getInputStream()), 3);
            List<Vector3f> controlPoints = bezierCurve.getControlPoints();
            if (cyclic) {
                for (int i = 0; i < 3; ++i) {
                    controlPoints.add(controlPoints.get(i));
                }
            }
            controlPoints.remove(0);
            controlPoints.remove(controlPoints.size() - 1);
            Spline spline = new Spline(Spline.SplineType.Bezier, controlPoints, 0.0f, false);
            Curve curve = new Curve(spline, resolution);
            if (bevelObject == null) {
                Geometry curveGeometry = new Geometry(null, (Mesh)curve);
                result.add(curveGeometry);
            } else {
                result = this.applyBevelAndTaper(curve, bevelObject, taperObject, smooth, blenderContext);
            }
        }
        return result;
    }

    protected List<Geometry> loadNurb(Vector3f loc, Structure nurb, List<Geometry> bevelObject, Curve taperObject, BlenderContext blenderContext) throws BlenderFileException {
        List<Object> result;
        List[] knots = new List[2];
        Pointer[] pKnots = new Pointer[]{(Pointer)nurb.getFieldValue("knotsu"), (Pointer)nurb.getFieldValue("knotsv")};
        for (int i = 0; i < knots.length; ++i) {
            if (!pKnots[i].isNotNull()) continue;
            FileBlockHeader fileBlockHeader = blenderContext.getFileBlock(pKnots[i].getOldMemoryAddress());
            BlenderInputStream blenderInputStream = blenderContext.getInputStream();
            blenderInputStream.setPosition(fileBlockHeader.getBlockPosition());
            int knotsAmount = fileBlockHeader.getCount() * fileBlockHeader.getSize() / 4;
            knots[i] = new ArrayList(knotsAmount);
            for (int j = 0; j < knotsAmount; ++j) {
                knots[i].add(Float.valueOf(blenderInputStream.readFloat()));
            }
        }
        int flagU = ((Number)nurb.getFieldValue("flagu")).intValue();
        int flagV = ((Number)nurb.getFieldValue("flagv")).intValue();
        int orderU = ((Number)nurb.getFieldValue("orderu")).intValue();
        int orderV = ((Number)nurb.getFieldValue("orderv")).intValue();
        int pntsU = ((Number)nurb.getFieldValue("pntsu")).intValue();
        int pntsV = ((Number)nurb.getFieldValue("pntsv")).intValue();
        List<Structure> bPoints = ((Pointer)nurb.getFieldValue("bp")).fetchData(blenderContext.getInputStream());
        ArrayList controlPoints = new ArrayList(pntsV);
        for (int i = 0; i < pntsV; ++i) {
            ArrayList<Object> uControlPoints = new ArrayList<Object>(pntsU);
            for (int j = 0; j < pntsU; ++j) {
                DynamicArray vec = (DynamicArray)bPoints.get(j + i * pntsU).getFieldValue("vec");
                if (this.fixUpAxis) {
                    uControlPoints.add(new Vector4f(((Float)vec.get(0)).floatValue(), ((Float)vec.get(2)).floatValue(), -((Float)vec.get(1)).floatValue(), ((Float)vec.get(3)).floatValue()));
                    continue;
                }
                uControlPoints.add(new Vector4f(((Float)vec.get(0)).floatValue(), ((Float)vec.get(1)).floatValue(), ((Float)vec.get(2)).floatValue(), ((Float)vec.get(3)).floatValue()));
            }
            if ((flagU & 1) != 0) {
                for (int k = 0; k < orderU - 1; ++k) {
                    uControlPoints.add(uControlPoints.get(k));
                }
            }
            controlPoints.add(uControlPoints);
        }
        if ((flagV & 1) != 0) {
            for (int k = 0; k < orderV - 1; ++k) {
                controlPoints.add(controlPoints.get(k));
            }
        }
        int resolu = ((Number)nurb.getFieldValue("resolu")).intValue() + 1;
        if (knots[1] == null) {
            Spline nurbSpline = new Spline((List)controlPoints.get(0), knots[0]);
            Curve nurbCurve = new Curve(nurbSpline, resolu);
            if (bevelObject != null) {
                result = this.applyBevelAndTaper(nurbCurve, bevelObject, taperObject, true, blenderContext);
            } else {
                result = new ArrayList(1);
                Geometry nurbGeometry = new Geometry("", (Mesh)nurbCurve);
                result.add(nurbGeometry);
            }
        } else {
            int resolv = ((Number)nurb.getFieldValue("resolv")).intValue() + 1;
            Surface nurbSurface = Surface.createNurbsSurface(controlPoints, (List[])knots, (int)resolu, (int)resolv, (int)orderU, (int)orderV);
            Geometry nurbGeometry = new Geometry("", (Mesh)nurbSurface);
            result = new ArrayList(1);
            result.add(nurbGeometry);
        }
        return result;
    }

    protected float getTaperScale(float[] taperPoints, float taperLength, float percent) {
        int i;
        float length = taperLength * percent;
        float currentLength = 0.0f;
        Vector3f p = new Vector3f();
        for (i = 0; i < taperPoints.length - 6 && currentLength < length; currentLength += p.length(), i += 3) {
            p.set(taperPoints[i], taperPoints[i + 1], taperPoints[i + 2]);
            p.subtractLocal(taperPoints[i + 3], taperPoints[i + 4], taperPoints[i + 5]);
        }
        float leftLength = length - (currentLength -= p.length());
        float percentOnSegment = p.length() == 0.0f ? 0.0f : leftLength / p.length();
        Vector3f store = FastMath.interpolateLinear((float)percentOnSegment, (Vector3f)new Vector3f(taperPoints[i], taperPoints[i + 1], taperPoints[i + 2]), (Vector3f)new Vector3f(taperPoints[i + 3], taperPoints[i + 4], taperPoints[i + 5]));
        return store.y;
    }

    protected List<Geometry> applyBevelAndTaper(Curve curve, List<Geometry> bevelObject, Curve taperObject, boolean smooth, BlenderContext blenderContext) {
        int geomIndex;
        float[] curvePoints = BufferUtils.getFloatArray((FloatBuffer)curve.getFloatBuffer(VertexBuffer.Type.Position));
        float curveLength = curve.getLength();
        float[] taperPoints = null;
        float taperLength = 0.0f;
        if (taperObject != null) {
            taperPoints = BufferUtils.getFloatArray((FloatBuffer)taperObject.getFloatBuffer(VertexBuffer.Type.Position));
            taperLength = taperObject.getLength();
        }
        Vector3f p = new Vector3f();
        Vector3f z = new Vector3f(0.0f, 0.0f, 1.0f);
        Vector3f negativeY = new Vector3f(0.0f, -1.0f, 0.0f);
        Matrix4f m = new Matrix4f();
        float lengthAlongCurve = 0.0f;
        float taperScale = 1.0f;
        Quaternion planeRotation = new Quaternion();
        Quaternion zRotation = new Quaternion();
        float[] temp = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        HashMap<Vector3f, Vector3f> normalMap = new HashMap<Vector3f, Vector3f>();
        FloatBuffer[] vertexBuffers = new FloatBuffer[bevelObject.size()];
        FloatBuffer[] normalBuffers = new FloatBuffer[bevelObject.size()];
        IntBuffer[] indexBuffers = new IntBuffer[bevelObject.size()];
        for (geomIndex = 0; geomIndex < bevelObject.size(); ++geomIndex) {
            Mesh mesh = bevelObject.get(geomIndex).getMesh();
            FloatBuffer positions = mesh.getFloatBuffer(VertexBuffer.Type.Position);
            float[] vertices = BufferUtils.getFloatArray((FloatBuffer)positions);
            for (int i = 0; i < curvePoints.length; i += 3) {
                Vector3f v;
                p.set(curvePoints[i], curvePoints[i + 1], curvePoints[i + 2]);
                if (i == 0) {
                    v = new Vector3f(curvePoints[3] - p.x, curvePoints[4] - p.y, curvePoints[5] - p.z);
                } else if (i + 3 >= curvePoints.length) {
                    v = new Vector3f(p.x - curvePoints[i - 3], p.y - curvePoints[i - 2], p.z - curvePoints[i - 1]);
                    lengthAlongCurve += v.length();
                } else {
                    v = new Vector3f(curvePoints[i + 3] - curvePoints[i - 3], curvePoints[i + 4] - curvePoints[i - 2], curvePoints[i + 5] - curvePoints[i - 1]);
                    lengthAlongCurve += new Vector3f(curvePoints[i + 3] - p.x, curvePoints[i + 4] - p.y, curvePoints[i + 5] - p.z).length();
                }
                v.normalizeLocal();
                float angle = FastMath.acos((float)v.dot(z));
                v.crossLocal(z).normalizeLocal();
                planeRotation.fromAngleAxis(angle, v);
                Vector3f zAxisRotationVector = negativeY.cross(v).normalizeLocal();
                float zAxisRotationAngle = FastMath.acos((float)negativeY.dot(v));
                zRotation.fromAngleAxis(zAxisRotationAngle, zAxisRotationVector);
                if (taperPoints != null) {
                    taperScale = this.getTaperScale(taperPoints, taperLength, lengthAlongCurve / curveLength);
                }
                m.set(Matrix4f.IDENTITY);
                m.setRotationQuaternion(planeRotation.multLocal(zRotation));
                m.setTranslation(p);
                Vector3f[] verts = new Vector3f[vertices.length / 3];
                for (int j = 0; j < verts.length; ++j) {
                    temp[0] = vertices[j * 3] * taperScale;
                    temp[1] = vertices[j * 3 + 1] * taperScale;
                    temp[2] = 0.0f;
                    m.mult(temp);
                    verts[j] = this.fixUpAxis ? new Vector3f(temp[0], temp[1], temp[2]) : new Vector3f(temp[0], temp[2], -temp[1]);
                }
                if (vertexBuffers[geomIndex] == null) {
                    vertexBuffers[geomIndex] = BufferUtils.createFloatBuffer((int)(verts.length * curvePoints.length));
                }
                FloatBuffer buffer = BufferUtils.createFloatBuffer((Vector3f[])verts);
                vertexBuffers[geomIndex].put(buffer);
                IntBuffer indexBuffer = indexBuffers[geomIndex];
                if (indexBuffer == null) {
                    int bevelCurveEdgesAmount = verts.length - 1;
                    indexBuffers[geomIndex] = indexBuffer = BufferUtils.createIntBuffer((int)(((bevelCurveEdgesAmount << 1) * curvePoints.length - bevelCurveEdgesAmount << 1) * 3));
                }
                int pointOffset = i / 3 * verts.length;
                if (i + 3 >= curvePoints.length) continue;
                for (int index = 0; index < verts.length - 1; ++index) {
                    indexBuffer.put(index + pointOffset);
                    indexBuffer.put(index + pointOffset + 1);
                    indexBuffer.put(verts.length + index + pointOffset);
                    indexBuffer.put(verts.length + index + pointOffset);
                    indexBuffer.put(index + pointOffset + 1);
                    indexBuffer.put(verts.length + index + pointOffset + 1);
                }
            }
        }
        for (geomIndex = 0; geomIndex < bevelObject.size(); ++geomIndex) {
            Vector3f[] allVerts = BufferUtils.getVector3Array((FloatBuffer)vertexBuffers[geomIndex]);
            int[] allIndices = BufferUtils.getIntArray((IntBuffer)indexBuffers[geomIndex]);
            for (int i = 0; i < allIndices.length - 3; i += 3) {
                Vector3f n = FastMath.computeNormal((Vector3f)allVerts[allIndices[i]], (Vector3f)allVerts[allIndices[i + 1]], (Vector3f)allVerts[allIndices[i + 2]]);
                this.addNormal(n, normalMap, smooth, allVerts[allIndices[i]], allVerts[allIndices[i + 1]], allVerts[allIndices[i + 2]]);
            }
            if (normalBuffers[geomIndex] == null) {
                normalBuffers[geomIndex] = BufferUtils.createFloatBuffer((int)(allVerts.length * 3));
            }
            for (Vector3f v : allVerts) {
                Vector3f n = (Vector3f)normalMap.get(v);
                normalBuffers[geomIndex].put(n.x);
                normalBuffers[geomIndex].put(n.y);
                normalBuffers[geomIndex].put(n.z);
            }
        }
        ArrayList<Geometry> result = new ArrayList<Geometry>(vertexBuffers.length);
        Float oneReferenceToCurveLength = new Float(curveLength);
        for (int i = 0; i < vertexBuffers.length; ++i) {
            Mesh mesh = new Mesh();
            mesh.setBuffer(VertexBuffer.Type.Position, 3, vertexBuffers[i]);
            mesh.setBuffer(VertexBuffer.Type.Index, 3, indexBuffers[i]);
            mesh.setBuffer(VertexBuffer.Type.Normal, 3, normalBuffers[i]);
            Geometry g = new Geometry("g" + i, mesh);
            g.setUserData("curveLength", (Object)oneReferenceToCurveLength);
            g.updateModelBound();
            result.add(g);
        }
        return result;
    }

    private void addNormal(Vector3f normalToAdd, Map<Vector3f, Vector3f> normalMap, boolean smooth, Vector3f ... vertices) {
        for (Vector3f v : vertices) {
            Vector3f n = normalMap.get(v);
            if (!smooth || n == null) {
                normalMap.put(v, normalToAdd.clone());
                continue;
            }
            n.addLocal(normalToAdd).normalizeLocal();
        }
    }

    protected Curve loadTaperObject(Structure taperStructure, BlenderContext blenderContext) throws BlenderFileException {
        List<Structure> nurbStructures = ((Structure)taperStructure.getFieldValue("nurb")).evaluateListBase(blenderContext);
        for (Structure nurb : nurbStructures) {
            Pointer pBezierTriple = (Pointer)nurb.getFieldValue("bezt");
            if (!pBezierTriple.isNotNull()) continue;
            BezierCurve bezierCurve = new BezierCurve(0, pBezierTriple.fetchData(blenderContext.getInputStream()), 3);
            List<Vector3f> controlPoints = bezierCurve.getControlPoints();
            controlPoints.remove(0);
            controlPoints.remove(controlPoints.size() - 1);
            if (controlPoints.size() <= 3) continue;
            Spline spline = new Spline(Spline.SplineType.Bezier, controlPoints, 0.0f, false);
            int resolution = ((Number)taperStructure.getFieldValue("resolu")).intValue();
            return new Curve(spline, resolution);
        }
        return null;
    }

    protected Vector3f getLoc(Structure curveStructure) {
        DynamicArray locArray = (DynamicArray)curveStructure.getFieldValue("loc");
        if (this.fixUpAxis) {
            return new Vector3f(((Number)locArray.get(0)).floatValue(), ((Number)locArray.get(1)).floatValue(), -((Number)locArray.get(2)).floatValue());
        }
        return new Vector3f(((Number)locArray.get(0)).floatValue(), ((Number)locArray.get(2)).floatValue(), ((Number)locArray.get(1)).floatValue());
    }

    @Override
    public boolean shouldBeLoaded(Structure structure, BlenderContext blenderContext) {
        return true;
    }
}

