/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import com.jme3.animation.Bone;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.file.DynamicArray;
import com.jme3.scene.plugins.blender.file.Structure;

class Feature {
    protected Constraint.Space space;
    protected Long oma;
    protected Spatial spatial;
    protected Bone bone;
    protected BlenderContext blenderContext;

    public Feature(Constraint.Space space, Long oma, BlenderContext blenderContext) {
        this.space = space;
        this.oma = oma;
        this.blenderContext = blenderContext;
    }

    public Feature(Spatial spatial, Constraint.Space space, Long oma, BlenderContext blenderContext) {
        this(space, oma, blenderContext);
        this.blenderContext = blenderContext;
    }

    public Feature(Bone bone, Constraint.Space space, Long oma, BlenderContext blenderContext) {
        this(space, oma, blenderContext);
        this.bone = bone;
    }

    public void update() {
        Object owner = this.blenderContext.getLoadedFeature(this.oma, BlenderContext.LoadedFeatureDataType.LOADED_FEATURE);
        if (owner instanceof Spatial) {
            this.spatial = (Spatial)owner;
        } else if (owner instanceof Bone) {
            this.bone = (Bone)owner;
        } else {
            throw new IllegalStateException("Unknown type of owner: " + owner.getClass());
        }
    }

    public Long getOma() {
        return this.oma;
    }

    public Object getObject() {
        if (this.spatial != null) {
            return this.spatial;
        }
        return this.bone;
    }

    public Transform getTransform() {
        if (this.spatial != null) {
            switch (this.space) {
                case CONSTRAINT_SPACE_LOCAL: {
                    Structure targetStructure = (Structure)this.blenderContext.getLoadedFeature(this.oma, BlenderContext.LoadedFeatureDataType.LOADED_STRUCTURE);
                    DynamicArray locArray = (DynamicArray)targetStructure.getFieldValue("loc");
                    Vector3f loc = new Vector3f(((Number)locArray.get(0)).floatValue(), ((Number)locArray.get(1)).floatValue(), ((Number)locArray.get(2)).floatValue());
                    DynamicArray rotArray = (DynamicArray)targetStructure.getFieldValue("rot");
                    Quaternion rot = new Quaternion(new float[]{((Number)rotArray.get(0)).floatValue(), ((Number)rotArray.get(1)).floatValue(), ((Number)rotArray.get(2)).floatValue()});
                    DynamicArray sizeArray = (DynamicArray)targetStructure.getFieldValue("size");
                    Vector3f size = new Vector3f(((Number)sizeArray.get(0)).floatValue(), ((Number)sizeArray.get(1)).floatValue(), ((Number)sizeArray.get(2)).floatValue());
                    if (this.blenderContext.getBlenderKey().isFixUpAxis()) {
                        float y = loc.y;
                        loc.y = loc.z;
                        loc.z = -y;
                        y = rot.getY();
                        float z = rot.getZ();
                        rot.set(rot.getX(), z, -y, rot.getW());
                        y = size.y;
                        size.y = size.z;
                        size.z = y;
                    }
                    Transform result = new Transform(loc, rot);
                    result.setScale(size);
                    return result;
                }
                case CONSTRAINT_SPACE_WORLD: {
                    return this.spatial.getWorldTransform();
                }
            }
            throw new IllegalStateException("Invalid space type for target object: " + this.space.toString());
        }
        switch (this.space) {
            case CONSTRAINT_SPACE_LOCAL: {
                Transform localTransform = new Transform(this.bone.getLocalPosition(), this.bone.getLocalRotation());
                localTransform.setScale(this.bone.getLocalScale());
                return localTransform;
            }
            case CONSTRAINT_SPACE_WORLD: {
                Transform worldTransform = new Transform(this.bone.getWorldBindPosition(), this.bone.getWorldBindRotation());
                worldTransform.setScale(this.bone.getWorldBindScale());
                return worldTransform;
            }
            case CONSTRAINT_SPACE_POSE: {
                Transform poseTransform = new Transform(this.bone.getLocalPosition(), this.bone.getLocalRotation());
                poseTransform.setScale(this.bone.getLocalScale());
                return poseTransform;
            }
            case CONSTRAINT_SPACE_PARLOCAL: {
                Transform parentLocalTransform = new Transform(this.bone.getLocalPosition(), this.bone.getLocalRotation());
                parentLocalTransform.setScale(this.bone.getLocalScale());
                return parentLocalTransform;
            }
        }
        throw new IllegalStateException("Invalid space type for target object: " + this.space.toString());
    }

    public void applyTransform(Transform transform) {
        if (this.spatial != null) {
            switch (this.space) {
                case CONSTRAINT_SPACE_LOCAL: {
                    Transform ownerLocalTransform = this.spatial.getLocalTransform();
                    ownerLocalTransform.getTranslation().addLocal(transform.getTranslation());
                    ownerLocalTransform.getRotation().multLocal(transform.getRotation());
                    ownerLocalTransform.getScale().multLocal(transform.getScale());
                    break;
                }
                case CONSTRAINT_SPACE_WORLD: {
                    Matrix4f m = this.getParentWorldTransformMatrix();
                    m.invertLocal();
                    Matrix4f matrix = this.toMatrix(transform);
                    m.multLocal(matrix);
                    float scaleX = (float)Math.sqrt(m.m00 * m.m00 + m.m10 * m.m10 + m.m20 * m.m20);
                    float scaleY = (float)Math.sqrt(m.m01 * m.m01 + m.m11 * m.m11 + m.m21 * m.m21);
                    float scaleZ = (float)Math.sqrt(m.m02 * m.m02 + m.m12 * m.m12 + m.m22 * m.m22);
                    transform.setTranslation(m.toTranslationVector());
                    transform.setRotation(m.toRotationQuat());
                    transform.setScale(scaleX, scaleY, scaleZ);
                    this.spatial.setLocalTransform(transform);
                    break;
                }
                case CONSTRAINT_SPACE_POSE: 
                case CONSTRAINT_SPACE_PARLOCAL: {
                    throw new IllegalStateException("Invalid space type (" + this.space.toString() + ") for owner object.");
                }
                default: {
                    throw new IllegalStateException("Invalid space type for target object: " + this.space.toString());
                }
            }
        } else {
            switch (this.space) {
                case CONSTRAINT_SPACE_LOCAL: {
                    this.bone.setBindTransforms(transform.getTranslation(), transform.getRotation(), transform.getScale());
                    break;
                }
                case CONSTRAINT_SPACE_WORLD: {
                    Matrix4f m = this.getParentWorldTransformMatrix();
                    transform.setTranslation(m.mult(transform.getTranslation()));
                    transform.setRotation(m.mult(transform.getRotation(), null));
                    transform.setScale(transform.getScale());
                    this.bone.setBindTransforms(transform.getTranslation(), transform.getRotation(), transform.getScale());
                    break;
                }
                case CONSTRAINT_SPACE_PARLOCAL: {
                    Vector3f parentLocalTranslation = this.bone.getLocalPosition().add(transform.getTranslation());
                    Quaternion parentLocalRotation = this.bone.getLocalRotation().mult(transform.getRotation());
                    this.bone.setBindTransforms(parentLocalTranslation, parentLocalRotation, transform.getScale());
                    break;
                }
                case CONSTRAINT_SPACE_POSE: {
                    this.bone.setBindTransforms(transform.getTranslation(), transform.getRotation(), transform.getScale());
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid space type for target object: " + this.space.toString());
                }
            }
        }
    }

    public Matrix4f getWorldTransformMatrix() {
        if (this.spatial != null) {
            Matrix4f result = new Matrix4f();
            Transform t = this.spatial.getWorldTransform();
            result.setTransform(t.getTranslation(), t.getScale(), t.getRotation().toRotationMatrix());
            return result;
        }
        Matrix4f result = new Matrix4f();
        result.setTransform(this.bone.getWorldBindPosition(), this.bone.getWorldBindScale(), this.bone.getWorldBindRotation().toRotationMatrix());
        return result;
    }

    public Matrix4f getParentWorldTransformMatrix() {
        Matrix4f result = new Matrix4f();
        if (this.spatial != null) {
            if (this.spatial.getParent() != null) {
                Transform t = this.spatial.getParent().getWorldTransform();
                result.setTransform(t.getTranslation(), t.getScale(), t.getRotation().toRotationMatrix());
            }
        } else {
            Bone parent = this.bone.getParent();
            if (parent != null) {
                result.setTransform(parent.getWorldBindPosition(), parent.getWorldBindScale(), parent.getWorldBindRotation().toRotationMatrix());
            }
        }
        return result;
    }

    protected Matrix4f toMatrix(Transform transform) {
        Matrix4f result = Matrix4f.IDENTITY;
        if (transform != null) {
            result = new Matrix4f();
            result.setTranslation(transform.getTranslation());
            result.setRotationQuaternion(transform.getRotation());
            result.setScale(transform.getScale());
        }
        return result;
    }
}

