/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import com.jme3.animation.Animation;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.constraints.BlenderTrack;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.ogre.AnimData;

class ConstraintSizeLimit
extends Constraint {
    private static final int LIMIT_XMIN = 1;
    private static final int LIMIT_XMAX = 2;
    private static final int LIMIT_YMIN = 4;
    private static final int LIMIT_YMAX = 8;
    private static final int LIMIT_ZMIN = 16;
    private static final int LIMIT_ZMAX = 32;
    protected float[][] limits = new float[3][2];
    protected int flag = ((Number)this.data.getFieldValue("flag")).intValue();

    public ConstraintSizeLimit(Structure constraintStructure, Long ownerOMA, Ipo influenceIpo, BlenderContext blenderContext) throws BlenderFileException {
        super(constraintStructure, ownerOMA, influenceIpo, blenderContext);
        if (blenderContext.getBlenderKey().isFixUpAxis()) {
            this.limits[0][0] = ((Number)this.data.getFieldValue("xmin")).floatValue();
            this.limits[0][1] = ((Number)this.data.getFieldValue("xmax")).floatValue();
            this.limits[2][0] = -((Number)this.data.getFieldValue("ymin")).floatValue();
            this.limits[2][1] = -((Number)this.data.getFieldValue("ymax")).floatValue();
            this.limits[1][0] = ((Number)this.data.getFieldValue("zmin")).floatValue();
            this.limits[1][1] = ((Number)this.data.getFieldValue("zmax")).floatValue();
            int ymin = this.flag & 4;
            int ymax = this.flag & 8;
            int zmin = this.flag & 0x10;
            int zmax = this.flag & 0x20;
            this.flag &= 3;
            this.flag |= ymin << 2;
            this.flag |= ymax << 2;
            this.flag |= zmin >> 2;
            this.flag |= zmax >> 2;
        } else {
            this.limits[0][0] = ((Number)this.data.getFieldValue("xmin")).floatValue();
            this.limits[0][1] = ((Number)this.data.getFieldValue("xmax")).floatValue();
            this.limits[1][0] = ((Number)this.data.getFieldValue("ymin")).floatValue();
            this.limits[1][1] = ((Number)this.data.getFieldValue("ymax")).floatValue();
            this.limits[2][0] = ((Number)this.data.getFieldValue("zmin")).floatValue();
            this.limits[2][1] = ((Number)this.data.getFieldValue("zmax")).floatValue();
        }
    }

    protected void bakeConstraint() {
        Object owner = this.owner.getObject();
        AnimData animData = this.blenderContext.getAnimData(this.owner.getOma());
        if (animData != null) {
            for (Animation animation : animData.anims) {
                BlenderTrack track = this.getTrack(owner, animData.skeleton, animation);
                Vector3f[] scales = track.getScales();
                int maxFrames = scales.length;
                for (int frame = 0; frame < maxFrames; ++frame) {
                    this.sizeLimit(scales[frame], this.ipo.calculateValue(frame));
                }
                track.setKeyframes(track.getTimes(), track.getTranslations(), track.getRotations(), scales);
            }
        }
        if (owner instanceof Spatial) {
            Transform ownerTransform = this.owner.getTransform();
            this.sizeLimit(ownerTransform.getScale(), this.ipo.calculateValue(0));
            this.owner.applyTransform(ownerTransform);
        }
    }

    private void sizeLimit(Vector3f scale, float influence) {
        if ((this.flag & 1) != 0 && scale.x < this.limits[0][0]) {
            scale.x -= (scale.x - this.limits[0][0]) * influence;
        }
        if ((this.flag & 2) != 0 && scale.x > this.limits[0][1]) {
            scale.x -= (scale.x - this.limits[0][1]) * influence;
        }
        if ((this.flag & 4) != 0 && scale.y < this.limits[1][0]) {
            scale.y -= (scale.y - this.limits[1][0]) * influence;
        }
        if ((this.flag & 8) != 0 && scale.y > this.limits[1][1]) {
            scale.y -= (scale.y - this.limits[1][1]) * influence;
        }
        if ((this.flag & 0x10) != 0 && scale.z < this.limits[2][0]) {
            scale.z -= (scale.z - this.limits[2][0]) * influence;
        }
        if ((this.flag & 0x20) != 0 && scale.z > this.limits[2][1]) {
            scale.z -= (scale.z - this.limits[2][1]) * influence;
        }
    }
}

