/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import com.jme3.animation.Animation;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.constraints.BlenderTrack;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.ogre.AnimData;

class ConstraintSizeLike
extends Constraint {
    private static final int SIZELIKE_X = 1;
    private static final int SIZELIKE_Y = 2;
    private static final int SIZELIKE_Z = 4;
    private static final int LOCLIKE_OFFSET = 128;
    protected int flag;

    public ConstraintSizeLike(Structure constraintStructure, Long ownerOMA, Ipo influenceIpo, BlenderContext blenderContext) throws BlenderFileException {
        super(constraintStructure, ownerOMA, influenceIpo, blenderContext);
        this.flag = ((Number)this.data.getFieldValue("flag")).intValue();
        if (blenderContext.getBlenderKey().isFixUpAxis()) {
            int y = this.flag & 2;
            int z = this.flag & 4;
            this.flag &= 0x81;
            this.flag |= y << 1;
            this.flag |= z >> 1;
        }
    }

    protected void bakeConstraint() {
        Transform targetTransform;
        Object owner = this.owner.getObject();
        AnimData animData = this.blenderContext.getAnimData(this.owner.getOma());
        if (animData != null) {
            targetTransform = this.target.getTransform();
            Vector3f targetScale = targetTransform.getScale();
            for (Animation animation : animData.anims) {
                BlenderTrack track = this.getTrack(owner, animData.skeleton, animation);
                Vector3f[] scales = track.getScales();
                int maxFrames = scales.length;
                for (int frame = 0; frame < maxFrames; ++frame) {
                    this.sizeLike(scales[frame], targetScale, this.ipo.calculateValue(frame));
                }
                track.setKeyframes(track.getTimes(), track.getTranslations(), track.getRotations(), scales);
            }
        }
        if (owner instanceof Spatial) {
            targetTransform = this.target.getTransform();
            Transform ownerTransform = this.owner.getTransform();
            this.sizeLike(ownerTransform.getScale(), targetTransform.getScale(), this.ipo.calculateValue(0));
            this.owner.applyTransform(ownerTransform);
        }
    }

    private void sizeLike(Vector3f ownerScale, Vector3f targetScale, float influence) {
        Vector3f offset = Vector3f.ZERO;
        if ((this.flag & 0x80) != 0) {
            offset = ownerScale.clone();
        }
        if ((this.flag & 1) != 0) {
            ownerScale.x = targetScale.x * influence + (1.0f - influence) * ownerScale.x;
        }
        if ((this.flag & 2) != 0) {
            ownerScale.y = targetScale.y * influence + (1.0f - influence) * ownerScale.y;
        }
        if ((this.flag & 4) != 0) {
            ownerScale.z = targetScale.z * influence + (1.0f - influence) * ownerScale.z;
        }
        ownerScale.addLocal(offset);
    }
}

