/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import com.jme3.animation.Animation;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.constraints.BlenderTrack;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.ogre.AnimData;
import java.nio.FloatBuffer;
import java.util.ArrayList;

class ConstraintShrinkWrap
extends Constraint {
    public ConstraintShrinkWrap(Structure constraintStructure, Long ownerOMA, Ipo influenceIpo, BlenderContext blenderContext) throws BlenderFileException {
        super(constraintStructure, ownerOMA, influenceIpo, blenderContext);
    }

    protected void bakeConstraint() {
        ArrayList<Vector3f> pts = new ArrayList<Vector3f>();
        Node target = (Node)this.target.getObject();
        for (Spatial spatial : target.getChildren()) {
            if (!(spatial instanceof Geometry)) continue;
            Mesh mesh = ((Geometry)spatial).getMesh();
            FloatBuffer floatBuffer = mesh.getFloatBuffer(VertexBuffer.Type.Position);
            for (int i = 0; i < floatBuffer.limit(); i += 3) {
                pts.add(new Vector3f(floatBuffer.get(i), floatBuffer.get(i + 1), floatBuffer.get(i + 2)));
            }
        }
        AnimData animData = this.blenderContext.getAnimData(this.owner.getOma());
        if (animData != null) {
            Object owner = this.owner.getObject();
            for (Animation animation : animData.anims) {
                BlenderTrack track = this.getTrack(owner, animData.skeleton, animation);
                Vector3f[] translations = track.getTranslations();
                Quaternion[] rotations = track.getRotations();
                int maxFrames = translations.length;
                for (int frame = 0; frame < maxFrames; ++frame) {
                    Vector3f currentTranslation = translations[frame];
                    Vector3f minDistancePoint = null;
                    float distance = Float.MAX_VALUE;
                    for (Vector3f p : pts) {
                        float temp = currentTranslation.distance(p);
                        if (!(temp < distance)) continue;
                        distance = temp;
                        minDistancePoint = p;
                    }
                    translations[frame] = minDistancePoint.clone();
                }
                track.setKeyframes(track.getTimes(), translations, rotations, track.getScales());
            }
        }
    }
}

