/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import com.jme3.animation.Animation;
import com.jme3.animation.Bone;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.constraints.BlenderTrack;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.ogre.AnimData;

class ConstraintRotLimit
extends Constraint {
    private static final int LIMIT_XROT = 1;
    private static final int LIMIT_YROT = 2;
    private static final int LIMIT_ZROT = 4;
    protected float[][] limits = new float[3][2];
    protected int flag = ((Number)this.data.getFieldValue("flag")).intValue();
    protected boolean updated;

    public ConstraintRotLimit(Structure constraintStructure, Long ownerOMA, Ipo influenceIpo, BlenderContext blenderContext) throws BlenderFileException {
        super(constraintStructure, ownerOMA, influenceIpo, blenderContext);
        if (blenderContext.getBlenderKey().isFixUpAxis() && this.owner.spatial != null) {
            this.limits[0][0] = ((Number)this.data.getFieldValue("xmin")).floatValue();
            this.limits[0][1] = ((Number)this.data.getFieldValue("xmax")).floatValue();
            this.limits[2][0] = -((Number)this.data.getFieldValue("ymin")).floatValue();
            this.limits[2][1] = -((Number)this.data.getFieldValue("ymax")).floatValue();
            this.limits[1][0] = ((Number)this.data.getFieldValue("zmin")).floatValue();
            this.limits[1][1] = ((Number)this.data.getFieldValue("zmax")).floatValue();
            int limitY = this.flag & 2;
            int limitZ = this.flag & 4;
            this.flag &= 1;
            this.flag |= limitY << 1;
            this.flag |= limitZ >> 1;
        } else {
            this.limits[0][0] = ((Number)this.data.getFieldValue("xmin")).floatValue();
            this.limits[0][1] = ((Number)this.data.getFieldValue("xmax")).floatValue();
            this.limits[1][0] = ((Number)this.data.getFieldValue("ymin")).floatValue();
            this.limits[1][1] = ((Number)this.data.getFieldValue("ymax")).floatValue();
            this.limits[2][0] = ((Number)this.data.getFieldValue("zmin")).floatValue();
            this.limits[2][1] = ((Number)this.data.getFieldValue("zmax")).floatValue();
        }
        if (blenderContext.getBlenderVersion() <= 249) {
            for (int i = 0; i < this.limits.length; ++i) {
                float[] fArray = this.limits[i];
                fArray[0] = fArray[0] * ((float)Math.PI / 180);
                float[] fArray2 = this.limits[i];
                fArray2[1] = fArray2[1] * ((float)Math.PI / 180);
            }
        }
    }

    protected void bakeConstraint() {
        this.update();
        Object owner = this.owner.getObject();
        AnimData animData = this.blenderContext.getAnimData(this.owner.getOma());
        if (animData != null) {
            for (Animation animation : animData.anims) {
                BlenderTrack track = this.getTrack(owner, animData.skeleton, animation);
                Quaternion[] rotations = track.getRotations();
                float[] angles = new float[3];
                int maxFrames = rotations.length;
                for (int frame = 0; frame < maxFrames; ++frame) {
                    rotations[frame].toAngles(angles);
                    this.rotLimit(angles, this.ipo.calculateValue(frame));
                    rotations[frame].fromAngles(angles);
                }
                track.setKeyframes(track.getTimes(), track.getTranslations(), rotations, track.getScales());
            }
        }
        if (owner instanceof Spatial) {
            Transform ownerTransform = this.owner.getTransform();
            float[] angles = ownerTransform.getRotation().toAngles(null);
            this.rotLimit(angles, this.ipo.calculateValue(0));
            ownerTransform.getRotation().fromAngles(angles);
            this.owner.applyTransform(ownerTransform);
        }
    }

    private void rotLimit(float[] angles, float influence) {
        float difference;
        if ((this.flag & 1) != 0) {
            difference = 0.0f;
            if (angles[0] < this.limits[0][0]) {
                difference = (angles[0] - this.limits[0][0]) * influence;
            } else if (angles[0] > this.limits[0][1]) {
                difference = (angles[0] - this.limits[0][1]) * influence;
            }
            angles[0] = angles[0] - difference;
        }
        if ((this.flag & 2) != 0) {
            difference = 0.0f;
            if (angles[1] < this.limits[1][0]) {
                difference = (angles[1] - this.limits[1][0]) * influence;
            } else if (angles[1] > this.limits[1][1]) {
                difference = (angles[1] - this.limits[1][1]) * influence;
            }
            angles[1] = angles[1] - difference;
        }
        if ((this.flag & 4) != 0) {
            difference = 0.0f;
            if (angles[2] < this.limits[2][0]) {
                difference = (angles[2] - this.limits[2][0]) * influence;
            } else if (angles[2] > this.limits[2][1]) {
                difference = (angles[2] - this.limits[2][1]) * influence;
            }
            angles[2] = angles[2] - difference;
        }
    }

    private void update() {
        if (!this.updated) {
            int i;
            this.updated = true;
            if (this.owner != null) {
                this.owner.update();
            }
            if (this.target != null) {
                this.target.update();
            }
            if (this.owner.getObject() instanceof Bone) {
                for (i = 0; i < this.limits.length; ++i) {
                    float[] fArray = this.limits[i];
                    fArray[0] = fArray[0] * -1.0f;
                    float[] fArray2 = this.limits[i];
                    fArray2[1] = fArray2[1] * -1.0f;
                }
            }
            for (i = 0; i < this.limits.length; ++i) {
                if (!(this.limits[i][0] > this.limits[i][1])) continue;
                float temp = this.limits[i][0];
                this.limits[i][0] = this.limits[i][1];
                this.limits[i][1] = temp;
            }
        }
    }
}

