/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import com.jme3.animation.Animation;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.constraints.BlenderTrack;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.ogre.AnimData;

class ConstraintRotLike
extends Constraint {
    private static final int ROTLIKE_X = 1;
    private static final int ROTLIKE_Y = 2;
    private static final int ROTLIKE_Z = 4;
    private static final int ROTLIKE_X_INVERT = 16;
    private static final int ROTLIKE_Y_INVERT = 32;
    private static final int ROTLIKE_Z_INVERT = 64;
    private static final int ROTLIKE_OFFSET = 128;
    protected int flag;

    public ConstraintRotLike(Structure constraintStructure, Long ownerOMA, Ipo influenceIpo, BlenderContext blenderContext) throws BlenderFileException {
        super(constraintStructure, ownerOMA, influenceIpo, blenderContext);
        this.flag = ((Number)this.data.getFieldValue("flag")).intValue();
    }

    protected void bakeConstraint() {
        Transform targetTransform;
        Object owner = this.owner.getObject();
        AnimData animData = this.blenderContext.getAnimData(this.owner.getOma());
        if (animData != null) {
            targetTransform = this.target.getTransform();
            Quaternion targetRotation = targetTransform.getRotation();
            for (Animation animation : animData.anims) {
                BlenderTrack track = this.getTrack(owner, animData.skeleton, animation);
                float[] targetAngles = targetRotation.toAngles(null);
                Quaternion[] rotations = track.getRotations();
                int maxFrames = rotations.length;
                float[] angles = new float[3];
                for (int frame = 0; frame < maxFrames; ++frame) {
                    rotations[frame].toAngles(angles);
                    this.rotLike(rotations[frame], angles, targetAngles, this.ipo.calculateValue(frame));
                }
                track.setKeyframes(track.getTimes(), track.getTranslations(), rotations, track.getScales());
            }
        }
        if (owner instanceof Spatial) {
            targetTransform = this.target.getTransform();
            Transform ownerTransform = this.owner.getTransform();
            Quaternion ownerRotation = ownerTransform.getRotation();
            this.rotLike(ownerRotation, ownerRotation.toAngles(null), targetTransform.getRotation().toAngles(null), this.ipo.calculateValue(0));
            this.owner.applyTransform(ownerTransform);
        }
    }

    private void rotLike(Quaternion ownerRotation, float[] ownerAngles, float[] targetAngles, float influence) {
        Quaternion startRotation = ownerRotation.clone();
        Quaternion offset = Quaternion.IDENTITY;
        if ((this.flag & 0x80) != 0) {
            offset = startRotation;
        }
        if ((this.flag & 1) != 0) {
            ownerAngles[0] = targetAngles[0];
            if ((this.flag & 0x10) != 0) {
                ownerAngles[0] = -ownerAngles[0];
            }
        }
        if ((this.flag & 2) != 0) {
            ownerAngles[1] = targetAngles[1];
            if ((this.flag & 0x20) != 0) {
                ownerAngles[1] = -ownerAngles[1];
            }
        }
        if ((this.flag & 4) != 0) {
            ownerAngles[2] = targetAngles[2];
            if ((this.flag & 0x40) != 0) {
                ownerAngles[2] = -ownerAngles[2];
            }
        }
        ownerRotation.fromAngles(ownerAngles).multLocal(offset);
        if (influence < 1.0f) {
            // empty if block
        }
    }
}

