/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import com.jme3.animation.Animation;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.constraints.BlenderTrack;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.ogre.AnimData;

class ConstraintLocLike
extends Constraint {
    private static final int LOCLIKE_X = 1;
    private static final int LOCLIKE_Y = 2;
    private static final int LOCLIKE_Z = 4;
    private static final int LOCLIKE_X_INVERT = 16;
    private static final int LOCLIKE_Y_INVERT = 32;
    private static final int LOCLIKE_Z_INVERT = 64;
    private static final int LOCLIKE_OFFSET = 128;
    protected int flag;

    public ConstraintLocLike(Structure constraintStructure, Long ownerOMA, Ipo influenceIpo, BlenderContext blenderContext) throws BlenderFileException {
        super(constraintStructure, ownerOMA, influenceIpo, blenderContext);
        this.flag = ((Number)this.data.getFieldValue("flag")).intValue();
        if (blenderContext.getBlenderKey().isFixUpAxis()) {
            int y = this.flag & 2;
            int invY = this.flag & 0x20;
            int z = this.flag & 4;
            int invZ = this.flag & 0x40;
            this.flag &= 0x91;
            this.flag |= y << 2;
            this.flag |= invY << 2;
            this.flag |= z >> 2;
            this.flag |= invZ >> 2;
        }
    }

    protected void bakeConstraint() {
        Transform targetTransform;
        Object owner = this.owner.getObject();
        AnimData animData = this.blenderContext.getAnimData(this.owner.getOma());
        if (animData != null) {
            targetTransform = this.target.getTransform();
            for (Animation animation : animData.anims) {
                BlenderTrack blenderTrack = this.getTrack(owner, animData.skeleton, animation);
                Vector3f[] translations = blenderTrack.getTranslations();
                int maxFrames = translations.length;
                for (int frame = 0; frame < maxFrames; ++frame) {
                    this.locLike(translations[frame], targetTransform.getTranslation(), this.ipo.calculateValue(frame));
                }
                blenderTrack.setKeyframes(blenderTrack.getTimes(), translations, blenderTrack.getRotations(), blenderTrack.getScales());
            }
        }
        if (owner instanceof Spatial) {
            targetTransform = this.target.getTransform();
            Transform ownerTransform = this.owner.getTransform();
            Vector3f ownerLocation = ownerTransform.getTranslation();
            this.locLike(ownerLocation, targetTransform.getTranslation(), this.ipo.calculateValue(0));
            this.owner.applyTransform(ownerTransform);
        }
    }

    private void locLike(Vector3f ownerLocation, Vector3f targetLocation, float influence) {
        Vector3f startLocation = ownerLocation.clone();
        Vector3f offset = Vector3f.ZERO;
        if ((this.flag & 0x80) != 0) {
            offset = startLocation;
        }
        if ((this.flag & 1) != 0) {
            ownerLocation.x = targetLocation.x;
            if ((this.flag & 0x10) != 0) {
                ownerLocation.x = -ownerLocation.x;
            }
        }
        if ((this.flag & 2) != 0) {
            ownerLocation.y = targetLocation.y;
            if ((this.flag & 0x20) != 0) {
                ownerLocation.y = -ownerLocation.y;
            }
        }
        if ((this.flag & 4) != 0) {
            ownerLocation.z = targetLocation.z;
            if ((this.flag & 0x40) != 0) {
                ownerLocation.z = -ownerLocation.z;
            }
        }
        ownerLocation.addLocal(offset);
        if (influence < 1.0f) {
            startLocation.subtractLocal(ownerLocation).normalizeLocal().mult(influence);
            ownerLocation.addLocal(startLocation);
        }
    }
}

