/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.animations.IpoHelper;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.constraints.ConstraintAction;
import com.jme3.scene.plugins.blender.constraints.ConstraintChildOf;
import com.jme3.scene.plugins.blender.constraints.ConstraintClampTo;
import com.jme3.scene.plugins.blender.constraints.ConstraintDampTrack;
import com.jme3.scene.plugins.blender.constraints.ConstraintDistLimit;
import com.jme3.scene.plugins.blender.constraints.ConstraintFollowPath;
import com.jme3.scene.plugins.blender.constraints.ConstraintInverseKinematics;
import com.jme3.scene.plugins.blender.constraints.ConstraintLocLike;
import com.jme3.scene.plugins.blender.constraints.ConstraintLocLimit;
import com.jme3.scene.plugins.blender.constraints.ConstraintLockTrack;
import com.jme3.scene.plugins.blender.constraints.ConstraintMinMax;
import com.jme3.scene.plugins.blender.constraints.ConstraintNull;
import com.jme3.scene.plugins.blender.constraints.ConstraintPython;
import com.jme3.scene.plugins.blender.constraints.ConstraintRigidBodyJoint;
import com.jme3.scene.plugins.blender.constraints.ConstraintRotLike;
import com.jme3.scene.plugins.blender.constraints.ConstraintRotLimit;
import com.jme3.scene.plugins.blender.constraints.ConstraintSameVolume;
import com.jme3.scene.plugins.blender.constraints.ConstraintShrinkWrap;
import com.jme3.scene.plugins.blender.constraints.ConstraintSizeLike;
import com.jme3.scene.plugins.blender.constraints.ConstraintSizeLimit;
import com.jme3.scene.plugins.blender.constraints.ConstraintSplineInverseKinematic;
import com.jme3.scene.plugins.blender.constraints.ConstraintStretchTo;
import com.jme3.scene.plugins.blender.constraints.ConstraintTrackTo;
import com.jme3.scene.plugins.blender.constraints.ConstraintTransLike;
import com.jme3.scene.plugins.blender.constraints.ConstraintTransform;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ConstraintHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(ConstraintHelper.class.getName());
    private static final Map<String, Class<? extends Constraint>> constraintClasses = new HashMap<String, Class<? extends Constraint>>(22);

    public ConstraintHelper(String blenderVersion, BlenderContext blenderContext, boolean fixUpAxis) {
        super(blenderVersion, fixUpAxis);
    }

    public void loadConstraints(Structure objectStructure, BlenderContext blenderContext) throws BlenderFileException {
        Pointer pPose;
        LOGGER.fine("Loading constraints.");
        IpoHelper ipoHelper = (IpoHelper)blenderContext.getHelper(IpoHelper.class);
        HashMap constraintsIpos = new HashMap();
        Pointer pActions = (Pointer)objectStructure.getFieldValue("action");
        if (pActions.isNotNull()) {
            List<Structure> actions = pActions.fetchData(blenderContext.getInputStream());
            for (Structure action : actions) {
                Structure chanbase = (Structure)action.getFieldValue("chanbase");
                List<Structure> actionChannels = chanbase.evaluateListBase(blenderContext);
                for (Structure actionChannel : actionChannels) {
                    HashMap<String, Ipo> ipos = new HashMap<String, Ipo>();
                    Structure constChannels = (Structure)actionChannel.getFieldValue("constraintChannels");
                    List<Structure> constraintChannels = constChannels.evaluateListBase(blenderContext);
                    for (Structure constraintChannel : constraintChannels) {
                        Pointer pIpo = (Pointer)constraintChannel.getFieldValue("ipo");
                        if (!pIpo.isNotNull()) continue;
                        String constraintName = constraintChannel.getFieldValue("name").toString();
                        Ipo ipo = ipoHelper.fromIpoStructure(pIpo.fetchData(blenderContext.getInputStream()).get(0), blenderContext);
                        ipos.put(constraintName, ipo);
                    }
                    String actionName = actionChannel.getFieldValue("name").toString();
                    constraintsIpos.put(actionName, ipos);
                }
            }
        }
        if ((pPose = (Pointer)objectStructure.getFieldValue("pose")).isNotNull()) {
            List<Structure> poseChannels = ((Structure)pPose.fetchData(blenderContext.getInputStream()).get(0).getFieldValue("chanbase")).evaluateListBase(blenderContext);
            for (Structure poseChannel : poseChannels) {
                ArrayList<Constraint> constraintsList = new ArrayList<Constraint>();
                Long boneOMA = ((Pointer)poseChannel.getFieldValue("bone")).getOldMemoryAddress();
                String name = blenderContext.getFileBlock(boneOMA).getStructure(blenderContext).getFieldValue("name").toString();
                List<Structure> constraints = ((Structure)poseChannel.getFieldValue("constraints")).evaluateListBase(blenderContext);
                for (Structure constraint : constraints) {
                    Ipo ipo;
                    String constraintName = constraint.getFieldValue("name").toString();
                    Map ipoMap = (Map)constraintsIpos.get(name);
                    Ipo ipo2 = ipo = ipoMap == null ? null : (Ipo)ipoMap.get(constraintName);
                    if (ipo == null) {
                        float enforce = ((Number)constraint.getFieldValue("enforce")).floatValue();
                        ipo = ipoHelper.fromValue(enforce);
                    }
                    constraintsList.add(this.createConstraint(constraint, boneOMA, ipo, blenderContext));
                }
                blenderContext.addConstraints(boneOMA, constraintsList);
            }
        }
        List<Structure> constraints = ((Structure)objectStructure.getFieldValue("constraints")).evaluateListBase(blenderContext);
        ArrayList<Constraint> constraintsList = new ArrayList<Constraint>(constraints.size());
        for (Structure constraint : constraints) {
            Ipo ipo;
            String constraintName = constraint.getFieldValue("name").toString();
            String objectName = objectStructure.getName();
            Map objectConstraintsIpos = (Map)constraintsIpos.get(objectName);
            Ipo ipo3 = ipo = objectConstraintsIpos != null ? (Ipo)objectConstraintsIpos.get(constraintName) : null;
            if (ipo == null) {
                float enforce = ((Number)constraint.getFieldValue("enforce")).floatValue();
                ipo = ipoHelper.fromValue(enforce);
            }
            constraintsList.add(this.createConstraint(constraint, objectStructure.getOldMemoryAddress(), ipo, blenderContext));
        }
        blenderContext.addConstraints(objectStructure.getOldMemoryAddress(), constraintsList);
    }

    protected Constraint createConstraint(Structure constraintStructure, Long ownerOMA, Ipo influenceIpo, BlenderContext blenderContext) throws BlenderFileException {
        String constraintClassName = this.getConstraintClassName(constraintStructure, blenderContext);
        Class<? extends Constraint> constraintClass = constraintClasses.get(constraintClassName);
        if (constraintClass != null) {
            try {
                return (Constraint)constraintClass.getDeclaredConstructors()[0].newInstance(constraintStructure, ownerOMA, influenceIpo, blenderContext);
            }
            catch (IllegalArgumentException e) {
                throw new BlenderFileException(e.getLocalizedMessage(), e);
            }
            catch (SecurityException e) {
                throw new BlenderFileException(e.getLocalizedMessage(), e);
            }
            catch (InstantiationException e) {
                throw new BlenderFileException(e.getLocalizedMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new BlenderFileException(e.getLocalizedMessage(), e);
            }
            catch (InvocationTargetException e) {
                throw new BlenderFileException(e.getLocalizedMessage(), e);
            }
        }
        throw new BlenderFileException("Unknown constraint type: " + constraintClassName);
    }

    protected String getConstraintClassName(Structure constraintStructure, BlenderContext blenderContext) throws BlenderFileException {
        Pointer pData = (Pointer)constraintStructure.getFieldValue("data");
        if (pData.isNotNull()) {
            Structure data = pData.fetchData(blenderContext.getInputStream()).get(0);
            return data.getType();
        }
        return constraintStructure.getType();
    }

    public boolean shouldBeLoaded(Structure structure, BlenderContext blenderContext) {
        return true;
    }

    static {
        constraintClasses.put("bActionConstraint", ConstraintAction.class);
        constraintClasses.put("bChildOfConstraint", ConstraintChildOf.class);
        constraintClasses.put("bClampToConstraint", ConstraintClampTo.class);
        constraintClasses.put("bDistLimitConstraint", ConstraintDistLimit.class);
        constraintClasses.put("bFollowPathConstraint", ConstraintFollowPath.class);
        constraintClasses.put("bKinematicConstraint", ConstraintInverseKinematics.class);
        constraintClasses.put("bLockTrackConstraint", ConstraintLockTrack.class);
        constraintClasses.put("bLocateLikeConstraint", ConstraintLocLike.class);
        constraintClasses.put("bLocLimitConstraint", ConstraintLocLimit.class);
        constraintClasses.put("bMinMaxConstraint", ConstraintMinMax.class);
        constraintClasses.put("bNullConstraint", ConstraintNull.class);
        constraintClasses.put("bPythonConstraint", ConstraintPython.class);
        constraintClasses.put("bRigidBodyJointConstraint", ConstraintRigidBodyJoint.class);
        constraintClasses.put("bRotateLikeConstraint", ConstraintRotLike.class);
        constraintClasses.put("bShrinkWrapConstraint", ConstraintShrinkWrap.class);
        constraintClasses.put("bSizeLikeConstraint", ConstraintSizeLike.class);
        constraintClasses.put("bSizeLimitConstraint", ConstraintSizeLimit.class);
        constraintClasses.put("bStretchToConstraint", ConstraintStretchTo.class);
        constraintClasses.put("bTransformConstraint", ConstraintTransform.class);
        constraintClasses.put("bRotLimitConstraint", ConstraintRotLimit.class);
        constraintClasses.put("bSplineIKConstraint", ConstraintSplineInverseKinematic.class);
        constraintClasses.put("bDampTrackConstraint", ConstraintDampTrack.class);
        constraintClasses.put("bPivotConstraint", ConstraintDampTrack.class);
        constraintClasses.put("bTrackToConstraint", ConstraintTrackTo.class);
        constraintClasses.put("bSameVolumeConstraint", ConstraintSameVolume.class);
        constraintClasses.put("bTransLikeConstraint", ConstraintTransLike.class);
    }
}

