/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import com.jme3.animation.Animation;
import com.jme3.math.Matrix4f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.constraints.BlenderTrack;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.ogre.AnimData;

class ConstraintDistLimit
extends Constraint {
    private static final int LIMITDIST_INSIDE = 0;
    private static final int LIMITDIST_OUTSIDE = 1;
    private static final int LIMITDIST_ONSURFACE = 2;
    protected int mode;
    protected float dist;

    public ConstraintDistLimit(Structure constraintStructure, Long ownerOMA, Ipo influenceIpo, BlenderContext blenderContext) throws BlenderFileException {
        super(constraintStructure, ownerOMA, influenceIpo, blenderContext);
        this.mode = ((Number)this.data.getFieldValue("mode")).intValue();
        this.dist = ((Number)this.data.getFieldValue("dist")).floatValue();
    }

    protected void bakeConstraint() {
        Object owner = this.owner.getObject();
        AnimData animData = this.blenderContext.getAnimData(this.owner.getOma());
        if (animData != null && owner instanceof Spatial) {
            Vector3f targetLocation = ((Spatial)owner).getWorldTranslation();
            for (Animation animation : animData.anims) {
                BlenderTrack blenderTrack = this.getTrack(owner, animData.skeleton, animation);
                int maxFrames = blenderTrack.getTimes().length;
                Vector3f[] translations = blenderTrack.getTranslations();
                for (int frame = 0; frame < maxFrames; ++frame) {
                    Vector3f v = translations[frame].subtract(targetLocation);
                    this.distLimit(v, targetLocation, this.ipo.calculateValue(frame));
                    translations[frame].addLocal(v);
                }
                blenderTrack.setKeyframes(blenderTrack.getTimes(), translations, blenderTrack.getRotations(), blenderTrack.getScales());
            }
        }
        if (owner instanceof Spatial) {
            Matrix4f targetWorldMatrix = this.target.getWorldTransformMatrix();
            Vector3f targetLocation = targetWorldMatrix.toTranslationVector();
            Matrix4f m = this.owner.getParentWorldTransformMatrix();
            m.invertLocal();
            Matrix4f ownerWorldMatrix = this.owner.getWorldTransformMatrix();
            Vector3f ownerLocation = ownerWorldMatrix.toTranslationVector();
            this.distLimit(ownerLocation, targetLocation, this.ipo.calculateValue(0));
            ((Spatial)owner).setLocalTranslation(m.mult(ownerLocation));
        }
    }

    private void distLimit(Vector3f currentLocation, Vector3f targetLocation, float influence) {
        Vector3f v = currentLocation.subtract(targetLocation);
        float currentDistance = v.length();
        switch (this.mode) {
            case 0: {
                if (!(currentDistance >= this.dist)) break;
                v.normalizeLocal();
                v.multLocal(this.dist + (currentDistance - this.dist) * (1.0f - influence));
                currentLocation.set(v.addLocal(targetLocation));
                break;
            }
            case 2: {
                if (currentDistance > this.dist) {
                    v.normalizeLocal();
                    v.multLocal(this.dist + (currentDistance - this.dist) * (1.0f - influence));
                    currentLocation.set(v.addLocal(targetLocation));
                    break;
                }
                if (!(currentDistance < this.dist)) break;
                v.normalizeLocal().multLocal(this.dist * influence);
                currentLocation.set(targetLocation.add(v));
                break;
            }
            case 1: {
                if (!(currentDistance <= this.dist)) break;
                v = targetLocation.subtract(currentLocation).normalizeLocal().multLocal(this.dist * influence);
                currentLocation.set(targetLocation.add(v));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown distance limit constraint mode: " + this.mode);
            }
        }
    }
}

