/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import com.jme3.animation.Animation;
import com.jme3.animation.Bone;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SpatialTrack;
import com.jme3.animation.Track;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.constraints.BlenderTrack;
import com.jme3.scene.plugins.blender.constraints.Feature;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.objects.ObjectHelper;

public abstract class Constraint {
    protected final String name;
    protected final Feature owner;
    protected final Feature target;
    protected final Structure data;
    protected final Ipo ipo;
    protected final BlenderContext blenderContext;

    public Constraint(Structure constraintStructure, Long ownerOMA, Ipo influenceIpo, BlenderContext blenderContext) throws BlenderFileException {
        this.blenderContext = blenderContext;
        this.name = constraintStructure.getFieldValue("name").toString();
        Pointer pData = (Pointer)constraintStructure.getFieldValue("data");
        if (pData.isNotNull()) {
            this.data = pData.fetchData(blenderContext.getInputStream()).get(0);
            Pointer pTar = (Pointer)this.data.getFieldValue("tar");
            if (pTar != null && pTar.isNotNull()) {
                Structure targetStructure = pTar.fetchData(blenderContext.getInputStream()).get(0);
                Long targetOMA = pTar.getOldMemoryAddress();
                Space targetSpace = Space.valueOf(((Number)constraintStructure.getFieldValue("tarspace")).byteValue());
                ObjectHelper objectHelper = (ObjectHelper)blenderContext.getHelper(ObjectHelper.class);
                Spatial target = (Spatial)objectHelper.toObject(targetStructure, blenderContext);
                this.target = new Feature(target, targetSpace, targetOMA, blenderContext);
            } else {
                this.target = null;
            }
        } else {
            throw new BlenderFileException("The constraint has no data specified!");
        }
        Space ownerSpace = Space.valueOf(((Number)constraintStructure.getFieldValue("ownspace")).byteValue());
        this.owner = new Feature(ownerSpace, ownerOMA, blenderContext);
        this.ipo = influenceIpo;
    }

    public void bake() {
        this.owner.update();
        if (this.target != null) {
            this.target.update();
        }
        this.bakeConstraint();
    }

    protected abstract void bakeConstraint();

    protected BlenderTrack getTrack(Object owner, Skeleton skeleton, Animation animation) {
        if (owner instanceof Bone) {
            int boneIndex = skeleton.getBoneIndex((Bone)owner);
            for (Track track : animation.getTracks()) {
                if (((BoneTrack)track).getTargetBoneIndex() != boneIndex) continue;
                return new BlenderTrack((BoneTrack)track);
            }
            throw new IllegalStateException("Cannot find track for: " + owner);
        }
        return new BlenderTrack((SpatialTrack)animation.getTracks()[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Space {
        CONSTRAINT_SPACE_WORLD,
        CONSTRAINT_SPACE_LOCAL,
        CONSTRAINT_SPACE_POSE,
        CONSTRAINT_SPACE_PARLOCAL,
        CONSTRAINT_SPACE_INVALID;


        public static Space valueOf(byte c) {
            switch (c) {
                case 0: {
                    return CONSTRAINT_SPACE_WORLD;
                }
                case 1: {
                    return CONSTRAINT_SPACE_LOCAL;
                }
                case 2: {
                    return CONSTRAINT_SPACE_POSE;
                }
                case 3: {
                    return CONSTRAINT_SPACE_PARLOCAL;
                }
            }
            return CONSTRAINT_SPACE_INVALID;
        }
    }
}

