/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.cameras;

import com.jme3.renderer.Camera;
import com.jme3.scene.CameraNode;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CameraHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(CameraHelper.class.getName());
    protected static final int DEFAULT_CAM_WIDTH = 640;
    protected static final int DEFAULT_CAM_HEIGHT = 480;

    public CameraHelper(String blenderVersion, boolean fixUpAxis) {
        super(blenderVersion, fixUpAxis);
    }

    public CameraNode toCamera(Structure structure) throws BlenderFileException {
        if (this.blenderVersion >= 250) {
            return this.toCamera250(structure);
        }
        return this.toCamera249(structure);
    }

    private CameraNode toCamera250(Structure structure) throws BlenderFileException {
        Camera camera = new Camera(640, 480);
        int type = ((Number)structure.getFieldValue("type")).intValue();
        if (type != 0 && type != 1) {
            LOGGER.log(Level.WARNING, "Unknown camera type: {0}. Perspective camera is being used!", type);
            type = 0;
        }
        camera.setParallelProjection(type == 1);
        float aspect = 0.0f;
        float clipsta = ((Number)structure.getFieldValue("clipsta")).floatValue();
        float clipend = ((Number)structure.getFieldValue("clipend")).floatValue();
        aspect = type == 0 ? ((Number)structure.getFieldValue("lens")).floatValue() : ((Number)structure.getFieldValue("ortho_scale")).floatValue();
        camera.setFrustumPerspective(45.0f, aspect, clipsta, clipend);
        return new CameraNode(null, camera);
    }

    private CameraNode toCamera249(Structure structure) throws BlenderFileException {
        Camera camera = new Camera(640, 480);
        int type = ((Number)structure.getFieldValue("type")).intValue();
        if (type != 0 && type != 1) {
            LOGGER.log(Level.WARNING, "Unknown camera type: {0}. Perspective camera is being used!", type);
            type = 0;
        }
        camera.setParallelProjection(type == 1);
        float aspect = 0.0f;
        float clipsta = ((Number)structure.getFieldValue("clipsta")).floatValue();
        float clipend = ((Number)structure.getFieldValue("clipend")).floatValue();
        aspect = type == 0 ? ((Number)structure.getFieldValue("lens")).floatValue() : ((Number)structure.getFieldValue("ortho_scale")).floatValue();
        camera.setFrustumPerspective(aspect, (float)(camera.getWidth() / camera.getHeight()), clipsta, clipend);
        return new CameraNode(null, camera);
    }

    public boolean shouldBeLoaded(Structure structure, BlenderContext blenderContext) {
        return (blenderContext.getBlenderKey().getFeaturesToLoad() & 0x20) != 0;
    }
}

