/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.animations;

import com.jme3.animation.BoneTrack;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.curves.BezierCurve;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.BlenderInputStream;
import com.jme3.scene.plugins.blender.file.FileBlockHeader;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import java.util.List;
import java.util.logging.Logger;

public class IpoHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(IpoHelper.class.getName());

    public IpoHelper(String blenderVersion, boolean fixUpAxis) {
        super(blenderVersion, fixUpAxis);
    }

    public Ipo fromIpoStructure(Structure ipoStructure, BlenderContext blenderContext) throws BlenderFileException {
        Structure curvebase = (Structure)ipoStructure.getFieldValue("curve");
        Ipo result = null;
        List<Structure> curves = curvebase.evaluateListBase(blenderContext);
        if (curves.size() > 0) {
            BezierCurve[] bezierCurves = new BezierCurve[curves.size()];
            int frame = 0;
            for (Structure curve : curves) {
                Pointer pBezTriple = (Pointer)curve.getFieldValue("bezt");
                List<Structure> bezTriples = pBezTriple.fetchData(blenderContext.getInputStream());
                int type = ((Number)curve.getFieldValue("adrcode")).intValue();
                bezierCurves[frame++] = new BezierCurve(type, bezTriples, 2);
            }
            curves.clear();
            result = new Ipo(bezierCurves, this.fixUpAxis);
            blenderContext.addLoadedFeatures(ipoStructure.getOldMemoryAddress(), ipoStructure.getName(), ipoStructure, result);
        }
        return result;
    }

    public Ipo fromAction(Structure actionStructure, BlenderContext blenderContext) throws BlenderFileException {
        Ipo result = null;
        List<Structure> curves = ((Structure)actionStructure.getFieldValue("curves")).evaluateListBase(blenderContext);
        if (curves.size() > 0) {
            BezierCurve[] bezierCurves = new BezierCurve[curves.size()];
            int frame = 0;
            for (Structure curve : curves) {
                Pointer pBezTriple = (Pointer)curve.getFieldValue("bezt");
                List<Structure> bezTriples = pBezTriple.fetchData(blenderContext.getInputStream());
                int type = this.getCurveType(curve, blenderContext);
                bezierCurves[frame++] = new BezierCurve(type, bezTriples, 2);
            }
            curves.clear();
            result = new Ipo(bezierCurves, this.fixUpAxis);
        }
        return result;
    }

    public int getCurveType(Structure structure, BlenderContext blenderContext) {
        BlenderInputStream bis = blenderContext.getInputStream();
        int currentPosition = bis.getPosition();
        Pointer pRnaPath = (Pointer)structure.getFieldValue("rna_path");
        FileBlockHeader dataFileBlock = blenderContext.getFileBlock(pRnaPath.getOldMemoryAddress());
        bis.setPosition(dataFileBlock.getBlockPosition());
        String rnaPath = bis.readString();
        bis.setPosition(currentPosition);
        int arrayIndex = ((Number)structure.getFieldValue("array_index")).intValue();
        if (rnaPath.endsWith("location")) {
            return 1 + arrayIndex;
        }
        if (rnaPath.endsWith("rotation_quaternion")) {
            return 25 + arrayIndex;
        }
        if (rnaPath.endsWith("scale")) {
            return 13 + arrayIndex;
        }
        if (rnaPath.endsWith("rotation") || rnaPath.endsWith("rotation_euler")) {
            return 7 + arrayIndex;
        }
        LOGGER.warning("Unknown curve rna path: " + rnaPath);
        return -1;
    }

    public Ipo fromValue(float constValue) {
        return new ConstIpo(constValue);
    }

    public boolean shouldBeLoaded(Structure structure, BlenderContext blenderContext) {
        return true;
    }

    private class ConstIpo
    extends Ipo {
        private float constValue;

        public ConstIpo(float constValue) {
            super(null, false);
            this.constValue = constValue;
        }

        public float calculateValue(int frame) {
            return this.constValue;
        }

        public float calculateValue(int frame, int curveIndex) {
            return this.constValue;
        }

        public int getCurvesAmount() {
            return 0;
        }

        public BoneTrack calculateTrack(int boneIndex, int startFrame, int stopFrame, int fps, boolean boneTrack) {
            throw new IllegalStateException("Constatnt ipo object cannot be used for calculating bone tracks!");
        }
    }
}

