/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.animations;

import com.jme3.animation.BoneTrack;
import com.jme3.animation.SpatialTrack;
import com.jme3.animation.Track;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.blender.curves.BezierCurve;
import java.util.logging.Logger;

public class Ipo {
    private static final Logger LOGGER = Logger.getLogger(Ipo.class.getName());
    public static final int AC_LOC_X = 1;
    public static final int AC_LOC_Y = 2;
    public static final int AC_LOC_Z = 3;
    public static final int OB_ROT_X = 7;
    public static final int OB_ROT_Y = 8;
    public static final int OB_ROT_Z = 9;
    public static final int AC_SIZE_X = 13;
    public static final int AC_SIZE_Y = 14;
    public static final int AC_SIZE_Z = 15;
    public static final int AC_QUAT_W = 25;
    public static final int AC_QUAT_X = 26;
    public static final int AC_QUAT_Y = 27;
    public static final int AC_QUAT_Z = 28;
    private BezierCurve[] bezierCurves;
    private Track calculatedTrack;
    protected boolean fixUpAxis;

    public Ipo(BezierCurve[] bezierCurves, boolean fixUpAxis) {
        this.bezierCurves = bezierCurves;
        this.fixUpAxis = fixUpAxis;
    }

    public float calculateValue(int frame) {
        return this.calculateValue(frame, 0);
    }

    public float calculateValue(int frame, int curveIndex) {
        return this.bezierCurves[curveIndex].evaluate(frame, 1);
    }

    public int getCurvesAmount() {
        return this.bezierCurves.length;
    }

    public int getLastFrame() {
        int result = 1;
        for (int i = 0; i < this.bezierCurves.length; ++i) {
            int tempResult = this.bezierCurves[i].getLastFrame();
            if (tempResult <= result) continue;
            result = tempResult;
        }
        return result;
    }

    public Track calculateTrack(int targetIndex, int startFrame, int stopFrame, int fps, boolean spatialTrack) {
        if (this.calculatedTrack == null) {
            int framesAmount = stopFrame - startFrame;
            float start = ((float)startFrame - 1.0f) / (float)fps;
            float timeBetweenFrames = 1.0f / (float)fps;
            float[] times = new float[framesAmount + 1];
            Vector3f[] translations = new Vector3f[framesAmount + 1];
            float[] translation = new float[3];
            Quaternion[] rotations = new Quaternion[framesAmount + 1];
            float[] quaternionRotation = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
            float[] objectRotation = new float[3];
            Vector3f[] scales = new Vector3f[framesAmount + 1];
            float[] scale = new float[]{1.0f, 1.0f, 1.0f};
            float degreeToRadiansFactor = 0.17453292f;
            for (int frame = startFrame; frame <= stopFrame; ++frame) {
                int index = frame - startFrame;
                times[index] = start + (float)(frame - 1) * timeBetweenFrames;
                block16: for (int j = 0; j < this.bezierCurves.length; ++j) {
                    double value = this.bezierCurves[j].evaluate(frame, 1);
                    switch (this.bezierCurves[j].getType()) {
                        case 1: {
                            translation[0] = (float)value;
                            continue block16;
                        }
                        case 2: {
                            if (this.fixUpAxis && spatialTrack) {
                                translation[2] = (float)(-value);
                                continue block16;
                            }
                            translation[1] = (float)value;
                            continue block16;
                        }
                        case 3: {
                            translation[this.fixUpAxis && spatialTrack ? 1 : 2] = (float)value;
                            continue block16;
                        }
                        case 7: {
                            objectRotation[0] = (float)value * degreeToRadiansFactor;
                            continue block16;
                        }
                        case 8: {
                            if (this.fixUpAxis) {
                                objectRotation[2] = (float)(-value) * degreeToRadiansFactor;
                                continue block16;
                            }
                            objectRotation[1] = (float)value * degreeToRadiansFactor;
                            continue block16;
                        }
                        case 9: {
                            objectRotation[this.fixUpAxis ? 1 : 2] = (float)value * degreeToRadiansFactor;
                            continue block16;
                        }
                        case 13: {
                            scale[0] = (float)value;
                            continue block16;
                        }
                        case 14: {
                            if (this.fixUpAxis && spatialTrack) {
                                scale[2] = (float)value;
                                continue block16;
                            }
                            scale[1] = (float)value;
                            continue block16;
                        }
                        case 15: {
                            scale[this.fixUpAxis && spatialTrack ? 1 : 2] = (float)value;
                            continue block16;
                        }
                        case 25: {
                            quaternionRotation[3] = (float)value;
                            continue block16;
                        }
                        case 26: {
                            quaternionRotation[0] = (float)value;
                            continue block16;
                        }
                        case 27: {
                            if (this.fixUpAxis) {
                                quaternionRotation[2] = -((float)value);
                                continue block16;
                            }
                            quaternionRotation[1] = (float)value;
                            continue block16;
                        }
                        case 28: {
                            if (this.fixUpAxis) {
                                quaternionRotation[1] = (float)value;
                                continue block16;
                            }
                            quaternionRotation[2] = (float)value;
                            continue block16;
                        }
                        default: {
                            LOGGER.warning("Unknown ipo curve type: " + this.bezierCurves[j].getType());
                        }
                    }
                }
                translations[index] = new Vector3f(translation[0], translation[1], translation[2]);
                rotations[index] = spatialTrack ? new Quaternion().fromAngles(objectRotation) : new Quaternion(quaternionRotation[0], quaternionRotation[1], quaternionRotation[2], quaternionRotation[3]);
                scales[index] = new Vector3f(scale[0], scale[1], scale[2]);
            }
            this.calculatedTrack = spatialTrack ? new SpatialTrack(times, translations, rotations, scales) : new BoneTrack(targetIndex, times, translations, rotations, scales);
        }
        return this.calculatedTrack;
    }
}

