/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.animations;

import com.jme3.animation.Bone;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.DynamicArray;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.objects.ObjectHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoneContext {
    private Structure boneStructure;
    private Structure poseChannel;
    private String boneName;
    private boolean fixUpAxis;
    private Matrix4f armatureMatrix;
    private BoneContext parent;
    private List<BoneContext> children = new ArrayList<BoneContext>();
    private Bone bone;
    private Transform poseTransform = new Transform();
    private Matrix4f restMatrix;
    private Matrix4f inverseTotalTransformation;
    private Matrix4f inverseParentMatrix;

    public BoneContext(Structure boneStructure, Matrix4f objectToArmatureMatrix, Map<Long, Structure> bonesPoseChannels, BlenderContext blenderContext) throws BlenderFileException {
        this(boneStructure, null, objectToArmatureMatrix, bonesPoseChannels, blenderContext);
    }

    private BoneContext(Structure boneStructure, BoneContext parent, Matrix4f objectToArmatureMatrix, Map<Long, Structure> bonesPoseChannels, BlenderContext blenderContext) throws BlenderFileException {
        this.parent = parent;
        this.boneStructure = boneStructure;
        this.boneName = boneStructure.getFieldValue("name").toString();
        ObjectHelper objectHelper = (ObjectHelper)blenderContext.getHelper(ObjectHelper.class);
        this.armatureMatrix = objectHelper.getMatrix(boneStructure, "arm_mat", true);
        this.fixUpAxis = blenderContext.getBlenderKey().isFixUpAxis();
        this.computeRestMatrix(objectToArmatureMatrix);
        List<Structure> childbase = ((Structure)boneStructure.getFieldValue("childbase")).evaluateListBase(blenderContext);
        for (Structure child : childbase) {
            this.children.add(new BoneContext(child, this, objectToArmatureMatrix, bonesPoseChannels, blenderContext));
        }
        this.poseChannel = bonesPoseChannels.get(boneStructure.getOldMemoryAddress());
        blenderContext.setBoneContext(boneStructure.getOldMemoryAddress(), this);
    }

    private void computeRestMatrix(Matrix4f objectToArmatureMatrix) {
        this.inverseParentMatrix = this.parent != null ? this.parent.inverseTotalTransformation.clone() : (this.fixUpAxis ? objectToArmatureMatrix.clone() : Matrix4f.IDENTITY.clone());
        this.restMatrix = this.armatureMatrix.clone();
        this.inverseTotalTransformation = this.restMatrix.invert();
        this.restMatrix = this.inverseParentMatrix.mult(this.restMatrix);
        for (BoneContext child : this.children) {
            child.computeRestMatrix(objectToArmatureMatrix);
        }
    }

    private void computePoseTransform() {
        DynamicArray loc = (DynamicArray)this.poseChannel.getFieldValue("loc");
        DynamicArray size = (DynamicArray)this.poseChannel.getFieldValue("size");
        DynamicArray quat = (DynamicArray)this.poseChannel.getFieldValue("quat");
        if (this.fixUpAxis) {
            this.poseTransform.setTranslation(((Number)loc.get(0)).floatValue(), -((Number)loc.get(2)).floatValue(), ((Number)loc.get(1)).floatValue());
            this.poseTransform.setRotation(new Quaternion(((Number)quat.get(1)).floatValue(), ((Number)quat.get(3)).floatValue(), -((Number)quat.get(2)).floatValue(), ((Number)quat.get(0)).floatValue()));
            this.poseTransform.setScale(((Number)size.get(0)).floatValue(), ((Number)size.get(2)).floatValue(), ((Number)size.get(1)).floatValue());
        } else {
            this.poseTransform.setTranslation(((Number)loc.get(0)).floatValue(), ((Number)loc.get(1)).floatValue(), ((Number)loc.get(2)).floatValue());
            this.poseTransform.setRotation(new Quaternion(((Number)quat.get(0)).floatValue(), ((Number)quat.get(1)).floatValue(), ((Number)quat.get(2)).floatValue(), ((Number)quat.get(3)).floatValue()));
            this.poseTransform.setScale(((Number)size.get(0)).floatValue(), ((Number)size.get(1)).floatValue(), ((Number)size.get(2)).floatValue());
        }
        Transform localTransform = new Transform(this.bone.getLocalPosition(), this.bone.getLocalRotation());
        localTransform.setScale(this.bone.getLocalScale());
        localTransform.getTranslation().addLocal(this.poseTransform.getTranslation());
        localTransform.getRotation().multLocal(this.poseTransform.getRotation());
        localTransform.getScale().multLocal(this.poseTransform.getScale());
        this.poseTransform.set(localTransform);
    }

    public Bone buildBone(List<Bone> bones, Map<Bone, Long> boneOMAs, BlenderContext blenderContext) {
        Long boneOMA = this.boneStructure.getOldMemoryAddress();
        this.bone = new Bone(this.boneName);
        bones.add(this.bone);
        boneOMAs.put(this.bone, boneOMA);
        blenderContext.addLoadedFeatures(boneOMA, this.boneName, this.boneStructure, this.bone);
        Matrix4f pose = this.restMatrix.clone();
        ObjectHelper objectHelper = (ObjectHelper)blenderContext.getHelper(ObjectHelper.class);
        Vector3f poseLocation = pose.toTranslationVector();
        Quaternion rotation = pose.toRotationQuat();
        Vector3f scale = objectHelper.getScale(pose);
        this.bone.setBindTransforms(poseLocation, rotation, scale);
        for (BoneContext child : this.children) {
            this.bone.addChild(child.buildBone(bones, boneOMAs, blenderContext));
        }
        this.computePoseTransform();
        return this.bone;
    }

    public Transform getPoseTransform() {
        return this.poseTransform;
    }

    public Bone getBone() {
        return this.bone;
    }
}

