/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.animations;

import com.jme3.animation.Bone;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.Skeleton;
import com.jme3.math.Matrix4f;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.BoneContext;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.animations.IpoHelper;
import com.jme3.scene.plugins.blender.curves.BezierCurve;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArmatureHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(ArmatureHelper.class.getName());
    private Map<Bone, Long> bonesOMAs = new HashMap<Bone, Long>();

    public ArmatureHelper(String blenderVersion, boolean fixUpAxis) {
        super(blenderVersion, fixUpAxis);
    }

    public void buildBones(Structure boneStructure, Bone parent, List<Bone> result, Matrix4f arbt, Map<Long, Structure> bonesPoseChannels, BlenderContext blenderContext) throws BlenderFileException {
        BoneContext bc = new BoneContext(boneStructure, arbt, bonesPoseChannels, blenderContext);
        bc.buildBone(result, this.bonesOMAs, blenderContext);
    }

    public Long getBoneOMA(Bone bone) {
        Long result = this.bonesOMAs.get(bone);
        if (result == null) {
            result = 0L;
        }
        return result;
    }

    public Map<Integer, Integer> getGroupToBoneIndexMap(Structure defBaseStructure, Skeleton skeleton, BlenderContext blenderContext) throws BlenderFileException {
        HashMap<Integer, Integer> result = null;
        if (skeleton.getBoneCount() != 0) {
            result = new HashMap<Integer, Integer>();
            List<Structure> deformGroups = defBaseStructure.evaluateListBase(blenderContext);
            int groupIndex = 0;
            for (Structure deformGroup : deformGroups) {
                String deformGroupName = deformGroup.getFieldValue("name").toString();
                int boneIndex = this.getBoneIndex(skeleton, deformGroupName);
                if (boneIndex >= 0) {
                    result.put(groupIndex, boneIndex);
                }
                ++groupIndex;
            }
        }
        return result;
    }

    @Override
    public boolean shouldBeLoaded(Structure structure, BlenderContext blenderContext) {
        return true;
    }

    public BoneTrack[] getTracks(Structure actionStructure, Skeleton skeleton, BlenderContext blenderContext) throws BlenderFileException {
        if (this.blenderVersion < 250) {
            return this.getTracks249(actionStructure, skeleton, blenderContext);
        }
        return this.getTracks250(actionStructure, skeleton, blenderContext);
    }

    private BoneTrack[] getTracks250(Structure actionStructure, Skeleton skeleton, BlenderContext blenderContext) throws BlenderFileException {
        LOGGER.log(Level.INFO, "Getting tracks!");
        IpoHelper ipoHelper = (IpoHelper)blenderContext.getHelper(IpoHelper.class);
        int fps = blenderContext.getBlenderKey().getFps();
        Structure groups = (Structure)actionStructure.getFieldValue("groups");
        List<Structure> actionGroups = groups.evaluateListBase(blenderContext);
        ArrayList<BoneTrack> tracks = new ArrayList<BoneTrack>();
        for (Structure actionGroup : actionGroups) {
            String name = actionGroup.getFieldValue("name").toString();
            int boneIndex = this.getBoneIndex(skeleton, name);
            if (boneIndex < 0) continue;
            List<Structure> channels = ((Structure)actionGroup.getFieldValue("channels")).evaluateListBase(blenderContext);
            BezierCurve[] bezierCurves = new BezierCurve[channels.size()];
            int channelCounter = 0;
            for (Structure c : channels) {
                int type = ipoHelper.getCurveType(c, blenderContext);
                Pointer pBezTriple = (Pointer)c.getFieldValue("bezt");
                List<Structure> bezTriples = pBezTriple.fetchData(blenderContext.getInputStream());
                bezierCurves[channelCounter++] = new BezierCurve(type, bezTriples, 2);
            }
            Ipo ipo = new Ipo(bezierCurves, this.fixUpAxis);
            tracks.add((BoneTrack)ipo.calculateTrack(boneIndex, 0, ipo.getLastFrame(), fps, false));
        }
        return tracks.toArray(new BoneTrack[tracks.size()]);
    }

    private BoneTrack[] getTracks249(Structure actionStructure, Skeleton skeleton, BlenderContext blenderContext) throws BlenderFileException {
        LOGGER.log(Level.INFO, "Getting tracks!");
        IpoHelper ipoHelper = (IpoHelper)blenderContext.getHelper(IpoHelper.class);
        int fps = blenderContext.getBlenderKey().getFps();
        Structure chanbase = (Structure)actionStructure.getFieldValue("chanbase");
        List<Structure> actionChannels = chanbase.evaluateListBase(blenderContext);
        ArrayList<BoneTrack> tracks = new ArrayList<BoneTrack>();
        for (Structure bActionChannel : actionChannels) {
            Pointer p;
            String name = bActionChannel.getFieldValue("name").toString();
            int boneIndex = this.getBoneIndex(skeleton, name);
            if (boneIndex < 0 || (p = (Pointer)bActionChannel.getFieldValue("ipo")).isNull()) continue;
            Structure ipoStructure = p.fetchData(blenderContext.getInputStream()).get(0);
            Ipo ipo = ipoHelper.fromIpoStructure(ipoStructure, blenderContext);
            tracks.add((BoneTrack)ipo.calculateTrack(boneIndex, 0, ipo.getLastFrame(), fps, false));
        }
        return tracks.toArray(new BoneTrack[tracks.size()]);
    }

    private int getBoneIndex(Skeleton skeleton, String boneName) {
        int result = -1;
        for (int i = 0; i < skeleton.getBoneCount() && result == -1; ++i) {
            if (!boneName.equals(skeleton.getBone(i).getName())) continue;
            result = i;
        }
        return result;
    }
}

