/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset;

import com.jme3.asset.ModelKey;
import com.jme3.bounding.BoundingVolume;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResults;
import com.jme3.collision.UnsupportedCollisionException;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.light.AmbientLight;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.scene.CameraNode;
import com.jme3.scene.LightNode;
import com.jme3.scene.Node;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.ogre.AnimData;
import com.jme3.texture.Texture;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.lwjgl.opengl.GL11;

public class BlenderKey
extends ModelKey {
    protected static final int DEFAULT_FPS = 25;
    protected int fps = 25;
    protected int featuresToLoad = -1;
    protected boolean loadUnlinkedAssets;
    protected String assetRootPath;
    protected boolean fixUpAxis = true;
    protected int generatedTexturePPU = 128;
    protected String usedWorld;
    protected Material defaultMaterial;
    protected RenderState.FaceCullMode faceCullMode = RenderState.FaceCullMode.Off;
    protected int layersToLoad = -1;
    protected boolean loadObjectProperties = true;
    protected int maxTextureSize = -1;
    protected boolean loadGeneratedTextures;

    public BlenderKey() {
    }

    public BlenderKey(String name) {
        super(name);
    }

    public int getFps() {
        return this.fps;
    }

    public void setFps(int fps) {
        this.fps = fps;
    }

    public RenderState.FaceCullMode getFaceCullMode() {
        return this.faceCullMode;
    }

    public void setFaceCullMode(RenderState.FaceCullMode faceCullMode) {
        this.faceCullMode = faceCullMode;
    }

    public void setLayersToLoad(int layersToLoad) {
        this.layersToLoad = layersToLoad;
    }

    public int getLayersToLoad() {
        return this.layersToLoad;
    }

    public void setLoadObjectProperties(boolean loadObjectProperties) {
        this.loadObjectProperties = loadObjectProperties;
    }

    public boolean isLoadObjectProperties() {
        return this.loadObjectProperties;
    }

    public int getMaxTextureSize() {
        if (this.maxTextureSize <= 0) {
            try {
                this.maxTextureSize = GL11.glGetInteger((int)3379);
            }
            catch (Exception e) {
                return 8192;
            }
        }
        return this.maxTextureSize;
    }

    public void setMaxTextureSize(int maxTextureSize) {
        this.maxTextureSize = maxTextureSize;
    }

    public void setLoadGeneratedTextures(boolean loadGeneratedTextures) {
        this.loadGeneratedTextures = loadGeneratedTextures;
    }

    public boolean isLoadGeneratedTextures() {
        return this.loadGeneratedTextures;
    }

    public void setAssetRootPath(String assetRootPath) {
        this.assetRootPath = assetRootPath;
    }

    public String getAssetRootPath() {
        return this.assetRootPath;
    }

    public void includeInLoading(int featuresToLoad) {
        this.featuresToLoad |= featuresToLoad;
    }

    public void excludeFromLoading(int featuresNotToLoad) {
        this.featuresToLoad &= ~featuresNotToLoad;
    }

    public int getFeaturesToLoad() {
        return this.featuresToLoad;
    }

    public boolean isLoadUnlinkedAssets() {
        return this.loadUnlinkedAssets;
    }

    public void setLoadUnlinkedAssets(boolean loadUnlinkedAssets) {
        this.loadUnlinkedAssets = loadUnlinkedAssets;
    }

    public LoadingResults prepareLoadingResults() {
        return new LoadingResults(this.featuresToLoad);
    }

    public void setFixUpAxis(boolean fixUpAxis) {
        this.fixUpAxis = fixUpAxis;
    }

    public boolean isFixUpAxis() {
        return this.fixUpAxis;
    }

    public void setGeneratedTexturePPU(int generatedTexturePPU) {
        this.generatedTexturePPU = generatedTexturePPU;
    }

    public int getGeneratedTexturePPU() {
        return this.generatedTexturePPU;
    }

    public void setUsedWorld(String usedWorld) {
        this.usedWorld = usedWorld;
    }

    public String getUsedWorld() {
        return this.usedWorld;
    }

    public void setDefaultMaterial(Material defaultMaterial) {
        this.defaultMaterial = defaultMaterial;
    }

    public Material getDefaultMaterial() {
        return this.defaultMaterial;
    }

    public void write(JmeExporter e) throws IOException {
        super.write(e);
        OutputCapsule oc = e.getCapsule((Savable)this);
        oc.write(this.fps, "fps", 25);
        oc.write(this.featuresToLoad, "features-to-load", -1);
        oc.write(this.loadUnlinkedAssets, "load-unlinked-assets", false);
        oc.write(this.assetRootPath, "asset-root-path", null);
        oc.write(this.fixUpAxis, "fix-up-axis", true);
        oc.write(this.generatedTexturePPU, "generated-texture-ppu", 128);
        oc.write(this.usedWorld, "used-world", null);
        oc.write((Savable)this.defaultMaterial, "default-material", null);
        oc.write((Enum)this.faceCullMode, "face-cull-mode", (Enum)RenderState.FaceCullMode.Off);
        oc.write(this.layersToLoad, "layers-to-load", -1);
    }

    public void read(JmeImporter e) throws IOException {
        super.read(e);
        InputCapsule ic = e.getCapsule((Savable)this);
        this.fps = ic.readInt("fps", 25);
        this.featuresToLoad = ic.readInt("features-to-load", -1);
        this.loadUnlinkedAssets = ic.readBoolean("load-unlinked-assets", false);
        this.assetRootPath = ic.readString("asset-root-path", null);
        this.fixUpAxis = ic.readBoolean("fix-up-axis", true);
        this.generatedTexturePPU = ic.readInt("generated-texture-ppu", 128);
        this.usedWorld = ic.readString("used-world", null);
        this.defaultMaterial = (Material)ic.readSavable("default-material", null);
        this.faceCullMode = (RenderState.FaceCullMode)ic.readEnum("face-cull-mode", RenderState.FaceCullMode.class, (Enum)RenderState.FaceCullMode.Off);
        this.layersToLoad = ic.readInt("layers-to=load", -1);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.assetRootPath == null ? 0 : this.assetRootPath.hashCode());
        result = 31 * result + (this.defaultMaterial == null ? 0 : this.defaultMaterial.hashCode());
        result = 31 * result + (this.faceCullMode == null ? 0 : this.faceCullMode.hashCode());
        result = 31 * result + this.featuresToLoad;
        result = 31 * result + (this.fixUpAxis ? 1231 : 1237);
        result = 31 * result + this.fps;
        result = 31 * result + this.generatedTexturePPU;
        result = 31 * result + this.layersToLoad;
        result = 31 * result + (this.loadUnlinkedAssets ? 1231 : 1237);
        result = 31 * result + (this.usedWorld == null ? 0 : this.usedWorld.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        BlenderKey other = (BlenderKey)((Object)obj);
        if (this.assetRootPath == null ? other.assetRootPath != null : !this.assetRootPath.equals(other.assetRootPath)) {
            return false;
        }
        if (this.defaultMaterial == null ? other.defaultMaterial != null : !this.defaultMaterial.equals(other.defaultMaterial)) {
            return false;
        }
        if (this.faceCullMode != other.faceCullMode) {
            return false;
        }
        if (this.featuresToLoad != other.featuresToLoad) {
            return false;
        }
        if (this.fixUpAxis != other.fixUpAxis) {
            return false;
        }
        if (this.fps != other.fps) {
            return false;
        }
        if (this.generatedTexturePPU != other.generatedTexturePPU) {
            return false;
        }
        if (this.layersToLoad != other.layersToLoad) {
            return false;
        }
        if (this.loadUnlinkedAssets != other.loadUnlinkedAssets) {
            return false;
        }
        return !(this.usedWorld == null ? other.usedWorld != null : !this.usedWorld.equals(other.usedWorld));
    }

    public static class WorldData {
        private AmbientLight ambientLight;

        public AmbientLight getAmbientLight() {
            return this.ambientLight;
        }

        public void setAmbientLight(AmbientLight ambientLight) {
            this.ambientLight = ambientLight;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LoadingResults
    extends Spatial {
        private final int featuresToLoad;
        private List<Node> scenes;
        private List<Node> objects;
        private List<Material> materials;
        private List<Texture> textures;
        private List<AnimData> animations;
        private List<CameraNode> cameras;
        private List<LightNode> lights;

        private LoadingResults(int featuresToLoad) {
            this.featuresToLoad = featuresToLoad;
            if ((featuresToLoad & 0xFFFF) != 0) {
                this.scenes = new ArrayList<Node>();
            }
            if ((featuresToLoad & 0xB) != 0) {
                this.objects = new ArrayList<Node>();
                if ((featuresToLoad & 3) != 0) {
                    this.materials = new ArrayList<Material>();
                    if ((featuresToLoad & 1) != 0) {
                        this.textures = new ArrayList<Texture>();
                    }
                }
                if ((featuresToLoad & 4) != 0) {
                    this.animations = new ArrayList<AnimData>();
                }
            }
            if ((featuresToLoad & 0x20) != 0) {
                this.cameras = new ArrayList<CameraNode>();
            }
            if ((featuresToLoad & 0x10) != 0) {
                this.lights = new ArrayList<LightNode>();
            }
        }

        public int getLoadedFeatures() {
            return this.featuresToLoad;
        }

        public void addScene(Node scene) {
            if (this.scenes != null) {
                this.scenes.add(scene);
            }
        }

        public void addObject(Node object) {
            if (this.objects != null) {
                this.objects.add(object);
            }
        }

        public void addMaterial(Material material) {
            if (this.materials != null) {
                this.materials.add(material);
            }
        }

        public void addTexture(Texture texture) {
            if (this.textures != null) {
                this.textures.add(texture);
            }
        }

        public void addCamera(CameraNode camera) {
            if (this.cameras != null) {
                this.cameras.add(camera);
            }
        }

        public void addLight(LightNode light) {
            if (this.lights != null) {
                this.lights.add(light);
            }
        }

        public List<Node> getScenes() {
            return this.scenes;
        }

        public List<Node> getObjects() {
            return this.objects;
        }

        public List<Material> getMaterials() {
            return this.materials;
        }

        public List<Texture> getTextures() {
            return this.textures;
        }

        public List<AnimData> getAnimations() {
            return this.animations;
        }

        public List<CameraNode> getCameras() {
            return this.cameras;
        }

        public List<LightNode> getLights() {
            return this.lights;
        }

        public int collideWith(Collidable other, CollisionResults results) throws UnsupportedCollisionException {
            return 0;
        }

        public void updateModelBound() {
        }

        public void setModelBound(BoundingVolume modelBound) {
        }

        public int getVertexCount() {
            return 0;
        }

        public int getTriangleCount() {
            return 0;
        }

        public Spatial deepClone() {
            return null;
        }

        public void depthFirstTraversal(SceneGraphVisitor visitor) {
        }

        protected void breadthFirstTraversal(SceneGraphVisitor visitor, Queue<Spatial> queue) {
        }
    }

    public static interface FeaturesToLoad {
        public static final int SCENES = 65535;
        public static final int OBJECTS = 11;
        public static final int ANIMATIONS = 4;
        public static final int MATERIALS = 3;
        public static final int TEXTURES = 1;
        public static final int CAMERAS = 32;
        public static final int LIGHTS = 16;
        public static final int ALL = -1;
    }
}

