/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system.lwjgl;

import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.system.lwjgl.LwjglAbstractDisplay;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.ContextAttribs;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.PixelFormat;

public class LwjglDisplay
extends LwjglAbstractDisplay {
    private static final Logger logger = Logger.getLogger(LwjglDisplay.class.getName());
    private final AtomicBoolean needRestart = new AtomicBoolean(false);
    private PixelFormat pixelFormat;

    protected DisplayMode getFullscreenDisplayMode(int width, int height, int bpp, int freq) {
        try {
            DisplayMode[] modes;
            for (DisplayMode mode : modes = Display.getAvailableDisplayModes()) {
                if (mode.getWidth() != width || mode.getHeight() != height || mode.getBitsPerPixel() != bpp && (bpp != 24 || mode.getBitsPerPixel() != 32) || mode.getFrequency() != freq) continue;
                return mode;
            }
        }
        catch (LWJGLException ex) {
            this.listener.handleError("Failed to acquire fullscreen display mode!", (Throwable)ex);
        }
        return null;
    }

    protected void createContext(AppSettings settings) throws LWJGLException {
        DisplayMode displayMode;
        if (settings.getWidth() <= 0 || settings.getHeight() <= 0) {
            displayMode = Display.getDesktopDisplayMode();
            settings.setResolution(displayMode.getWidth(), displayMode.getHeight());
        } else if (settings.isFullscreen()) {
            displayMode = this.getFullscreenDisplayMode(settings.getWidth(), settings.getHeight(), settings.getBitsPerPixel(), settings.getFrequency());
            if (displayMode == null) {
                throw new RuntimeException("Unable to find fullscreen display mode matching settings");
            }
        } else {
            displayMode = new DisplayMode(settings.getWidth(), settings.getHeight());
        }
        int samples = this.getNumSamplesToUse();
        PixelFormat pf = new PixelFormat(settings.getBitsPerPixel(), 0, settings.getDepthBits(), settings.getStencilBits(), samples, 0, 0, 0, settings.useStereo3D());
        this.frameRate = settings.getFrameRate();
        logger.log(Level.INFO, "Selected display mode: {0}", displayMode);
        boolean pixelFormatChanged = false;
        if (this.created.get() && (this.pixelFormat.getBitsPerPixel() != pf.getBitsPerPixel() || this.pixelFormat.getDepthBits() != pf.getDepthBits() || this.pixelFormat.getStencilBits() != pf.getStencilBits() || this.pixelFormat.getSamples() != pf.getSamples())) {
            this.renderer.resetGLObjects();
            Display.destroy();
            pixelFormatChanged = true;
        }
        this.pixelFormat = pf;
        Display.setTitle((String)settings.getTitle());
        if (displayMode != null) {
            if (settings.isFullscreen()) {
                Display.setDisplayModeAndFullscreen((DisplayMode)displayMode);
            } else {
                Display.setFullscreen((boolean)false);
                Display.setDisplayMode((DisplayMode)displayMode);
            }
        } else {
            Display.setFullscreen((boolean)settings.isFullscreen());
        }
        if (settings.getIcons() != null) {
            Display.setIcon((ByteBuffer[])this.imagesToByteBuffers(settings.getIcons()));
        }
        Display.setVSyncEnabled((boolean)settings.isVSync());
        if (this.created.get() && !pixelFormatChanged) {
            Display.releaseContext();
            Display.makeCurrent();
            Display.update();
        }
        if (!this.created.get() || pixelFormatChanged) {
            ContextAttribs attr = this.createContextAttribs();
            if (attr != null) {
                Display.create((PixelFormat)this.pixelFormat, (ContextAttribs)attr);
            } else {
                Display.create((PixelFormat)this.pixelFormat);
            }
            this.renderable.set(true);
            if (pixelFormatChanged && this.pixelFormat.getSamples() > 1 && GLContext.getCapabilities().GL_ARB_multisample) {
                GL11.glEnable((int)32925);
            }
        }
    }

    protected void destroyContext() {
        try {
            this.renderer.cleanup();
            Display.releaseContext();
            Display.destroy();
        }
        catch (LWJGLException ex) {
            this.listener.handleError("Failed to destroy context", (Throwable)ex);
        }
    }

    public void create(boolean waitFor) {
        if (this.created.get()) {
            logger.warning("create() called when display is already created!");
            return;
        }
        new Thread((Runnable)this, "LWJGL Renderer Thread").start();
        if (waitFor) {
            this.waitFor(true);
        }
    }

    public void runLoop() {
        if (this.needRestart.getAndSet(false)) {
            try {
                this.createContext(this.settings);
            }
            catch (LWJGLException ex) {
                logger.log(Level.SEVERE, "Failed to set display settings!", ex);
            }
            this.listener.reshape(this.settings.getWidth(), this.settings.getHeight());
            logger.info("Display restarted.");
        }
        super.runLoop();
    }

    public void restart() {
        if (this.created.get()) {
            this.needRestart.set(true);
        } else {
            logger.warning("Display is not created, cannot restart window.");
        }
    }

    public JmeContext.Type getType() {
        return JmeContext.Type.Display;
    }

    public void setTitle(String title) {
        if (this.created.get()) {
            Display.setTitle((String)title);
        }
    }

    private ByteBuffer[] imagesToByteBuffers(Object[] images) {
        ByteBuffer[] out = new ByteBuffer[images.length];
        for (int i = 0; i < images.length; ++i) {
            BufferedImage image = (BufferedImage)images[i];
            out[i] = this.imageToByteBuffer(image);
        }
        return out;
    }

    private ByteBuffer imageToByteBuffer(BufferedImage image) {
        if (image.getType() != 3) {
            BufferedImage convertedImage = new BufferedImage(image.getWidth(), image.getHeight(), 3);
            Graphics2D g = convertedImage.createGraphics();
            double width = (double)image.getWidth() * 1.0;
            double height = (double)image.getHeight() * 1.0;
            g.drawImage(image, (int)(((double)convertedImage.getWidth() - width) / 2.0), (int)(((double)convertedImage.getHeight() - height) / 2.0), (int)width, (int)height, null);
            g.dispose();
            image = convertedImage;
        }
        byte[] imageBuffer = new byte[image.getWidth() * image.getHeight() * 4];
        int counter = 0;
        for (int i = 0; i < image.getHeight(); ++i) {
            for (int j = 0; j < image.getWidth(); ++j) {
                int colorSpace = image.getRGB(j, i);
                imageBuffer[counter + 0] = (byte)(colorSpace << 8 >> 24);
                imageBuffer[counter + 1] = (byte)(colorSpace << 16 >> 24);
                imageBuffer[counter + 2] = (byte)(colorSpace << 24 >> 24);
                imageBuffer[counter + 3] = (byte)(colorSpace >> 24);
                counter += 4;
            }
        }
        return ByteBuffer.wrap(imageBuffer);
    }
}

