/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer.lwjgl;

import com.jme3.renderer.RendererException;
import com.jme3.texture.Image;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.ARBTextureMultisample;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GLContext;

class TextureUtil {
    private static final GLImageFormat[] formatToGL = new GLImageFormat[Image.Format.values().length];

    TextureUtil() {
    }

    private static void setFormat(Image.Format format, int glInternalFormat, int glFormat, int glDataType, boolean glCompressed) {
        TextureUtil.formatToGL[format.ordinal()] = new GLImageFormat(glInternalFormat, glFormat, glDataType, glCompressed);
    }

    public static GLImageFormat getImageFormat(ContextCapabilities caps, Image.Format fmt) {
        switch (fmt) {
            case ABGR8: {
                if (caps.GL_EXT_abgr) break;
                return null;
            }
            case BGR8: {
                if (caps.OpenGL12 || caps.GL_EXT_bgra) break;
                return null;
            }
            case DXT1: 
            case DXT1A: 
            case DXT3: 
            case DXT5: {
                if (caps.GL_EXT_texture_compression_s3tc) break;
                return null;
            }
            case Depth: 
            case Depth16: 
            case Depth24: 
            case Depth32: {
                if (caps.OpenGL14 || caps.GL_ARB_depth_texture) break;
                return null;
            }
            case Depth24Stencil8: {
                if (caps.OpenGL30) break;
                return null;
            }
            case Luminance16F: 
            case Luminance16FAlpha16F: 
            case Luminance32F: {
                if (caps.GL_ARB_texture_float) break;
                return null;
            }
            case RGB16F: 
            case RGB32F: 
            case RGBA16F: 
            case RGBA32F: {
                if (caps.OpenGL30 || caps.GL_ARB_texture_float) break;
                return null;
            }
            case Depth32F: {
                if (caps.OpenGL30 || caps.GL_NV_depth_buffer_float) break;
                return null;
            }
            case LATC: 
            case LTC: {
                if (caps.GL_EXT_texture_compression_latc) break;
                return null;
            }
            case RGB9E5: 
            case RGB16F_to_RGB9E5: {
                if (caps.OpenGL30 || caps.GL_EXT_texture_shared_exponent) break;
                return null;
            }
            case RGB111110F: 
            case RGB16F_to_RGB111110F: {
                if (caps.OpenGL30 || caps.GL_EXT_packed_float) break;
                return null;
            }
        }
        return formatToGL[fmt.ordinal()];
    }

    public static GLImageFormat getImageFormatWithError(Image.Format fmt) {
        GLImageFormat glFmt = TextureUtil.getImageFormat(GLContext.getCapabilities(), fmt);
        if (glFmt == null) {
            throw new RendererException("Image format '" + fmt + "' is unsupported by the video hardware.");
        }
        return glFmt;
    }

    public static void uploadTexture(Image image, int target, int index, int border) {
        Image.Format fmt = image.getFormat();
        GLImageFormat glFmt = TextureUtil.getImageFormatWithError(fmt);
        ByteBuffer data = index >= 0 && image.getData() != null && image.getData().size() > 0 ? image.getData(index) : null;
        int width = image.getWidth();
        int height = image.getHeight();
        int depth = image.getDepth();
        if (data != null) {
            GL11.glPixelStorei((int)3317, (int)1);
        }
        int[] mipSizes = image.getMipMapSizes();
        int pos = 0;
        if (mipSizes == null) {
            mipSizes = data != null ? new int[]{data.capacity()} : new int[]{width * height * fmt.getBitsPerPixel() / 8};
        }
        boolean subtex = false;
        int samples = image.getMultiSamples();
        for (int i = 0; i < mipSizes.length; ++i) {
            int mipWidth = Math.max(1, width >> i);
            int mipHeight = Math.max(1, height >> i);
            int mipDepth = Math.max(1, depth >> i);
            if (data != null) {
                data.position(pos);
                data.limit(pos + mipSizes[i]);
            }
            if (glFmt.compressed && data != null) {
                if (target == 32879) {
                    GL13.glCompressedTexImage3D((int)target, (int)i, (int)glFmt.internalFormat, (int)mipWidth, (int)mipHeight, (int)mipDepth, (int)border, (ByteBuffer)data);
                } else {
                    GL13.glCompressedTexImage2D((int)target, (int)i, (int)glFmt.internalFormat, (int)mipWidth, (int)mipHeight, (int)border, (ByteBuffer)data);
                }
            } else if (target == 32879) {
                GL12.glTexImage3D((int)target, (int)i, (int)glFmt.internalFormat, (int)mipWidth, (int)mipHeight, (int)mipDepth, (int)border, (int)glFmt.format, (int)glFmt.dataType, (ByteBuffer)data);
            } else if (target == 35866) {
                if (index == -1) {
                    GL12.glTexImage3D((int)target, (int)0, (int)glFmt.internalFormat, (int)mipWidth, (int)mipHeight, (int)image.getData().size(), (int)border, (int)glFmt.format, (int)glFmt.dataType, (ByteBuffer)data);
                } else {
                    GL12.glTexSubImage3D((int)target, (int)i, (int)0, (int)0, (int)index, (int)width, (int)height, (int)1, (int)glFmt.format, (int)glFmt.dataType, (ByteBuffer)data);
                }
            } else if (subtex) {
                if (samples > 1) {
                    throw new IllegalStateException("Cannot update multisample textures");
                }
                GL11.glTexSubImage2D((int)target, (int)i, (int)0, (int)0, (int)mipWidth, (int)mipHeight, (int)glFmt.format, (int)glFmt.dataType, (ByteBuffer)data);
            } else if (samples > 1) {
                ARBTextureMultisample.glTexImage2DMultisample((int)target, (int)samples, (int)glFmt.internalFormat, (int)mipWidth, (int)mipHeight, (boolean)true);
            } else {
                GL11.glTexImage2D((int)target, (int)i, (int)glFmt.internalFormat, (int)mipWidth, (int)mipHeight, (int)border, (int)glFmt.format, (int)glFmt.dataType, (ByteBuffer)data);
            }
            pos += mipSizes[i];
        }
    }

    static {
        TextureUtil.setFormat(Image.Format.Alpha8, 32828, 6406, 5121, false);
        TextureUtil.setFormat(Image.Format.Alpha16, 32830, 6406, 5123, false);
        TextureUtil.setFormat(Image.Format.Luminance8, 32832, 6409, 5121, false);
        TextureUtil.setFormat(Image.Format.Luminance16, 32834, 6409, 5123, false);
        TextureUtil.setFormat(Image.Format.Luminance16F, 34846, 6409, 5131, false);
        TextureUtil.setFormat(Image.Format.Luminance32F, 34840, 6409, 5126, false);
        TextureUtil.setFormat(Image.Format.Luminance8Alpha8, 32837, 6410, 5121, false);
        TextureUtil.setFormat(Image.Format.Luminance16Alpha16, 32840, 6410, 5123, false);
        TextureUtil.setFormat(Image.Format.Luminance16FAlpha16F, 34847, 6410, 5131, false);
        TextureUtil.setFormat(Image.Format.Depth, 6402, 6402, 5121, false);
        TextureUtil.setFormat(Image.Format.Depth16, 33189, 6402, 5123, false);
        TextureUtil.setFormat(Image.Format.Depth24, 33190, 6402, 5125, false);
        TextureUtil.setFormat(Image.Format.Depth32, 33191, 6402, 5125, false);
        TextureUtil.setFormat(Image.Format.Depth32F, 36267, 6402, 5126, false);
        TextureUtil.setFormat(Image.Format.Depth24Stencil8, 35056, 34041, 34042, false);
        TextureUtil.setFormat(Image.Format.BGR8, 32849, 32992, 5121, false);
        TextureUtil.setFormat(Image.Format.RGB8, 32849, 6407, 5121, false);
        TextureUtil.setFormat(Image.Format.RGB16, 32852, 6407, 5123, false);
        TextureUtil.setFormat(Image.Format.RGB16F, 34843, 6407, 5131, false);
        TextureUtil.setFormat(Image.Format.RGB32F, 34837, 6407, 5126, false);
        TextureUtil.setFormat(Image.Format.RGB111110F, 35898, 6407, 35899, false);
        TextureUtil.setFormat(Image.Format.RGB9E5, 35901, 6407, 35902, false);
        TextureUtil.setFormat(Image.Format.RGB16F_to_RGB111110F, 35898, 6407, 5131, false);
        TextureUtil.setFormat(Image.Format.RGB16F_to_RGB9E5, 35901, 6407, 5131, false);
        TextureUtil.setFormat(Image.Format.ABGR8, 32856, 32768, 5121, false);
        TextureUtil.setFormat(Image.Format.RGB5A1, 32855, 6408, 32820, false);
        TextureUtil.setFormat(Image.Format.ARGB4444, 32854, 32768, 32819, false);
        TextureUtil.setFormat(Image.Format.RGBA8, 32856, 6408, 5121, false);
        TextureUtil.setFormat(Image.Format.RGBA16, 32859, 6408, 5123, false);
        TextureUtil.setFormat(Image.Format.RGBA16F, 34842, 6408, 5131, false);
        TextureUtil.setFormat(Image.Format.RGBA32F, 34836, 6408, 5126, false);
        TextureUtil.setFormat(Image.Format.DXT1, 33776, 6407, 5121, true);
        TextureUtil.setFormat(Image.Format.DXT1A, 33777, 6408, 5121, true);
        TextureUtil.setFormat(Image.Format.DXT3, 33778, 6408, 5121, true);
        TextureUtil.setFormat(Image.Format.DXT5, 33779, 6408, 5121, true);
        TextureUtil.setFormat(Image.Format.LTC, 35952, 6409, 5121, true);
        TextureUtil.setFormat(Image.Format.LATC, 35954, 6410, 5121, true);
    }

    static class GLImageFormat {
        int internalFormat;
        int format;
        int dataType;
        boolean compressed;

        public GLImageFormat(int internalFormat, int format, int dataType, boolean compressed) {
            this.internalFormat = internalFormat;
            this.format = format;
            this.dataType = dataType;
            this.compressed = compressed;
        }
    }
}

