/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.export.xml;

import com.jme3.export.JmeExporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.export.SavableClassUtil;
import com.jme3.util.IntMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.Map;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMOutputCapsule
implements OutputCapsule {
    private static final String dataAttributeName = "data";
    private Document doc;
    private Element currentElement;
    private JmeExporter exporter;
    private Map<Savable, Element> writtenSavables = new IdentityHashMap<Savable, Element>();

    public DOMOutputCapsule(Document doc, JmeExporter exporter) {
        this.doc = doc;
        this.exporter = exporter;
        this.currentElement = null;
    }

    public Document getDoc() {
        return this.doc;
    }

    private Element appendElement(String name) {
        Element ret = this.doc.createElement(name);
        if (this.currentElement == null) {
            ret.setAttribute("format_version", Integer.toString(2));
            this.doc.appendChild(ret);
        } else {
            this.currentElement.appendChild(ret);
        }
        this.currentElement = ret;
        return ret;
    }

    private static String encodeString(String s) {
        if (s == null) {
            return null;
        }
        s = s.replaceAll("\\&", "&amp;").replaceAll("\\\"", "&quot;").replaceAll("\\<", "&lt;");
        return s;
    }

    public void write(byte value, String name, byte defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.currentElement.setAttribute(name, String.valueOf(value));
    }

    public void write(byte[] value, String name, byte[] defVal) throws IOException {
        StringBuilder buf = new StringBuilder();
        if (value == null) {
            value = defVal;
        }
        for (byte b : value) {
            buf.append(b);
            buf.append(" ");
        }
        buf.setLength(buf.length() - 1);
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.length));
        el.setAttribute(dataAttributeName, buf.toString());
        this.currentElement = (Element)this.currentElement.getParentNode();
    }

    public void write(byte[][] value, String name, byte[][] defVal) throws IOException {
        StringBuilder buf = new StringBuilder();
        if (value == null) {
            value = defVal;
        }
        byte[][] arr$ = value;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            byte[] bs;
            for (byte b : bs = arr$[i$]) {
                buf.append(b);
                buf.append(" ");
            }
            buf.append(" ");
        }
        buf.setLength(buf.length() - 2);
        Element el = this.appendElement(name);
        el.setAttribute("size_outer", String.valueOf(value.length));
        el.setAttribute("size_inner", String.valueOf(value[0].length));
        el.setAttribute(dataAttributeName, buf.toString());
        this.currentElement = (Element)this.currentElement.getParentNode();
    }

    public void write(int value, String name, int defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.currentElement.setAttribute(name, String.valueOf(value));
    }

    public void write(int[] value, String name, int[] defVal) throws IOException {
        StringBuilder buf = new StringBuilder();
        if (value == null) {
            return;
        }
        if (Arrays.equals(value, defVal)) {
            return;
        }
        for (int b : value) {
            buf.append(b);
            buf.append(" ");
        }
        buf.setLength(Math.max(0, buf.length() - 1));
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.length));
        el.setAttribute(dataAttributeName, buf.toString());
        this.currentElement = (Element)this.currentElement.getParentNode();
    }

    public void write(int[][] value, String name, int[][] defVal) throws IOException {
        if (value == null) {
            return;
        }
        if (Arrays.deepEquals((Object[])value, (Object[])defVal)) {
            return;
        }
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.length));
        for (int i = 0; i < value.length; ++i) {
            int[] array = value[i];
            this.write(array, "array_" + i, defVal == null ? null : defVal[i]);
        }
        this.currentElement = (Element)el.getParentNode();
    }

    public void write(float value, String name, float defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.currentElement.setAttribute(name, String.valueOf(value));
    }

    public void write(float[] value, String name, float[] defVal) throws IOException {
        StringBuilder buf = new StringBuilder();
        if (value == null) {
            value = defVal;
        }
        if (value != null) {
            for (float b : value) {
                buf.append(b);
                buf.append(" ");
            }
            buf.setLength(buf.length() - 1);
        }
        Element el = this.appendElement(name);
        el.setAttribute("size", value == null ? "0" : String.valueOf(value.length));
        el.setAttribute(dataAttributeName, buf.toString());
        this.currentElement = (Element)this.currentElement.getParentNode();
    }

    public void write(float[][] value, String name, float[][] defVal) throws IOException {
        StringBuilder buf = new StringBuilder();
        if (value == null) {
            return;
        }
        if (Arrays.deepEquals((Object[])value, (Object[])defVal)) {
            return;
        }
        float[][] arr$ = value;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            float[] bs;
            for (float b : bs = arr$[i$]) {
                buf.append(b);
                buf.append(" ");
            }
        }
        buf.setLength(buf.length() - 1);
        Element el = this.appendElement(name);
        el.setAttribute("size_outer", String.valueOf(value.length));
        el.setAttribute("size_inner", String.valueOf(value[0].length));
        el.setAttribute(dataAttributeName, buf.toString());
        this.currentElement = (Element)this.currentElement.getParentNode();
    }

    public void write(double value, String name, double defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.currentElement.setAttribute(name, String.valueOf(value));
    }

    public void write(double[] value, String name, double[] defVal) throws IOException {
        StringBuilder buf = new StringBuilder();
        if (value == null) {
            value = defVal;
        }
        for (double b : value) {
            buf.append(b);
            buf.append(" ");
        }
        buf.setLength(buf.length() - 1);
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.length));
        el.setAttribute(dataAttributeName, buf.toString());
        this.currentElement = (Element)this.currentElement.getParentNode();
    }

    public void write(double[][] value, String name, double[][] defVal) throws IOException {
        if (value == null) {
            return;
        }
        if (Arrays.deepEquals((Object[])value, (Object[])defVal)) {
            return;
        }
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.length));
        for (int i = 0; i < value.length; ++i) {
            double[] array = value[i];
            this.write(array, "array_" + i, defVal == null ? null : defVal[i]);
        }
        this.currentElement = (Element)el.getParentNode();
    }

    public void write(long value, String name, long defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.currentElement.setAttribute(name, String.valueOf(value));
    }

    public void write(long[] value, String name, long[] defVal) throws IOException {
        StringBuilder buf = new StringBuilder();
        if (value == null) {
            value = defVal;
        }
        for (long b : value) {
            buf.append(b);
            buf.append(" ");
        }
        buf.setLength(buf.length() - 1);
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.length));
        el.setAttribute(dataAttributeName, buf.toString());
        this.currentElement = (Element)this.currentElement.getParentNode();
    }

    public void write(long[][] value, String name, long[][] defVal) throws IOException {
        if (value == null) {
            return;
        }
        if (Arrays.deepEquals((Object[])value, (Object[])defVal)) {
            return;
        }
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.length));
        for (int i = 0; i < value.length; ++i) {
            long[] array = value[i];
            this.write(array, "array_" + i, defVal == null ? null : defVal[i]);
        }
        this.currentElement = (Element)el.getParentNode();
    }

    public void write(short value, String name, short defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.currentElement.setAttribute(name, String.valueOf(value));
    }

    public void write(short[] value, String name, short[] defVal) throws IOException {
        StringBuilder buf = new StringBuilder();
        if (value == null) {
            value = defVal;
        }
        for (short b : value) {
            buf.append(b);
            buf.append(" ");
        }
        buf.setLength(buf.length() - 1);
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.length));
        el.setAttribute(dataAttributeName, buf.toString());
        this.currentElement = (Element)this.currentElement.getParentNode();
    }

    public void write(short[][] value, String name, short[][] defVal) throws IOException {
        if (value == null) {
            return;
        }
        if (Arrays.deepEquals((Object[])value, (Object[])defVal)) {
            return;
        }
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.length));
        for (int i = 0; i < value.length; ++i) {
            short[] array = value[i];
            this.write(array, "array_" + i, defVal == null ? null : defVal[i]);
        }
        this.currentElement = (Element)el.getParentNode();
    }

    public void write(boolean value, String name, boolean defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.currentElement.setAttribute(name, String.valueOf(value));
    }

    public void write(boolean[] value, String name, boolean[] defVal) throws IOException {
        StringBuilder buf = new StringBuilder();
        if (value == null) {
            value = defVal;
        }
        for (boolean b : value) {
            buf.append(b);
            buf.append(" ");
        }
        buf.setLength(Math.max(0, buf.length() - 1));
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.length));
        el.setAttribute(dataAttributeName, buf.toString());
        this.currentElement = (Element)this.currentElement.getParentNode();
    }

    public void write(boolean[][] value, String name, boolean[][] defVal) throws IOException {
        if (value == null) {
            return;
        }
        if (Arrays.deepEquals((Object[])value, (Object[])defVal)) {
            return;
        }
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.length));
        for (int i = 0; i < value.length; ++i) {
            boolean[] array = value[i];
            this.write(array, "array_" + i, defVal == null ? null : defVal[i]);
        }
        this.currentElement = (Element)el.getParentNode();
    }

    public void write(String value, String name, String defVal) throws IOException {
        if (value == null || value.equals(defVal)) {
            return;
        }
        this.currentElement.setAttribute(name, DOMOutputCapsule.encodeString(value));
    }

    public void write(String[] value, String name, String[] defVal) throws IOException {
        Element el = this.appendElement(name);
        if (value == null) {
            value = defVal;
        }
        el.setAttribute("size", String.valueOf(value.length));
        for (int i = 0; i < value.length; ++i) {
            String b = value[i];
            this.appendElement("String_" + i);
            String val = DOMOutputCapsule.encodeString(b);
            this.currentElement.setAttribute("value", val);
            this.currentElement = el;
        }
        this.currentElement = (Element)this.currentElement.getParentNode();
    }

    public void write(String[][] value, String name, String[][] defVal) throws IOException {
        if (value == null) {
            return;
        }
        if (Arrays.deepEquals((Object[])value, (Object[])defVal)) {
            return;
        }
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.length));
        for (int i = 0; i < value.length; ++i) {
            String[] array = value[i];
            this.write(array, "array_" + i, defVal == null ? null : defVal[i]);
        }
        this.currentElement = (Element)el.getParentNode();
    }

    public void write(BitSet value, String name, BitSet defVal) throws IOException {
        if (value == null || value.equals(defVal)) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        int i = value.nextSetBit(0);
        while (i >= 0) {
            buf.append(i);
            buf.append(" ");
            i = value.nextSetBit(i + 1);
        }
        buf.setLength(Math.max(0, buf.length() - 1));
        this.currentElement.setAttribute(name, buf.toString());
    }

    public void write(Savable object, String name, Savable defVal) throws IOException {
        if (object == null) {
            return;
        }
        if (object.equals(defVal)) {
            return;
        }
        Element old = this.currentElement;
        Element el = this.writtenSavables.get(object);
        String className = null;
        if (!object.getClass().getName().equals(name)) {
            className = object.getClass().getName();
        }
        try {
            this.doc.createElement(name);
        }
        catch (DOMException e) {
            name = "Object";
            className = object.getClass().getName();
        }
        if (el != null) {
            String refID = el.getAttribute("reference_ID");
            if (refID.length() == 0) {
                refID = object.getClass().getName() + "@" + object.hashCode();
                el.setAttribute("reference_ID", refID);
            }
            el = this.appendElement(name);
            el.setAttribute("ref", refID);
        } else {
            el = this.appendElement(name);
            int[] versions = SavableClassUtil.getSavableVersions(object.getClass());
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < versions.length; ++i) {
                sb.append(versions[i]);
                if (i == versions.length - 1) continue;
                sb.append(", ");
            }
            el.setAttribute("savable_versions", sb.toString());
            this.writtenSavables.put(object, el);
            object.write(this.exporter);
        }
        if (className != null) {
            el.setAttribute("class", className);
        }
        this.currentElement = old;
    }

    public void write(Savable[] objects, String name, Savable[] defVal) throws IOException {
        if (objects == null) {
            return;
        }
        if (Arrays.equals(objects, defVal)) {
            return;
        }
        Element old = this.currentElement;
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(objects.length));
        for (int i = 0; i < objects.length; ++i) {
            Savable o = objects[i];
            if (o == null) {
                if (name.equals("renderStateList")) continue;
                Element before = this.currentElement;
                this.appendElement("null");
                this.currentElement = before;
                continue;
            }
            this.write(o, o.getClass().getName(), null);
        }
        this.currentElement = old;
    }

    public void write(Savable[][] value, String name, Savable[][] defVal) throws IOException {
        if (value == null) {
            return;
        }
        if (Arrays.deepEquals((Object[])value, (Object[])defVal)) {
            return;
        }
        Element el = this.appendElement(name);
        el.setAttribute("size_outer", String.valueOf(value.length));
        el.setAttribute("size_inner", String.valueOf(value[0].length));
        Savable[][] arr$ = value;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Savable[] bs;
            for (Savable b : bs = arr$[i$]) {
                this.write(b, b.getClass().getSimpleName(), null);
            }
        }
        this.currentElement = (Element)this.currentElement.getParentNode();
    }

    public void writeSavableArrayList(ArrayList array, String name, ArrayList defVal) throws IOException {
        Element el;
        if (array == null) {
            return;
        }
        if (array.equals(defVal)) {
            return;
        }
        Element old = this.currentElement;
        this.currentElement = el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(array.size()));
        for (Object o : array) {
            if (o == null) continue;
            if (o instanceof Savable) {
                Savable s = (Savable)o;
                this.write(s, s.getClass().getName(), null);
                continue;
            }
            throw new ClassCastException("Not a Savable instance: " + o);
        }
        this.currentElement = old;
    }

    public void writeSavableArrayListArray(ArrayList[] objects, String name, ArrayList[] defVal) throws IOException {
        if (objects == null) {
            return;
        }
        if (Arrays.equals(objects, defVal)) {
            return;
        }
        Element old = this.currentElement;
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(objects.length));
        for (int i = 0; i < objects.length; ++i) {
            ArrayList o = objects[i];
            if (o == null) {
                Element before = this.currentElement;
                this.appendElement("null");
                this.currentElement = before;
                continue;
            }
            StringBuilder buf = new StringBuilder("SavableArrayList_");
            buf.append(i);
            this.writeSavableArrayList(o, buf.toString(), null);
        }
        this.currentElement = old;
    }

    public void writeSavableArrayListArray2D(ArrayList[][] value, String name, ArrayList[][] defVal) throws IOException {
        if (value == null) {
            return;
        }
        if (Arrays.deepEquals((Object[])value, (Object[])defVal)) {
            return;
        }
        Element el = this.appendElement(name);
        int size = value.length;
        el.setAttribute("size", String.valueOf(size));
        for (int i = 0; i < size; ++i) {
            ArrayList[] vi = value[i];
            this.writeSavableArrayListArray(vi, "SavableArrayListArray_" + i, null);
        }
        this.currentElement = (Element)el.getParentNode();
    }

    public void writeFloatBufferArrayList(ArrayList<FloatBuffer> array, String name, ArrayList<FloatBuffer> defVal) throws IOException {
        if (array == null) {
            return;
        }
        if (array.equals(defVal)) {
            return;
        }
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(array.size()));
        for (FloatBuffer o : array) {
            this.write(o, "FloatBuffer", null);
        }
        this.currentElement = (Element)el.getParentNode();
    }

    public void writeSavableMap(Map<? extends Savable, ? extends Savable> map, String name, Map<? extends Savable, ? extends Savable> defVal) throws IOException {
        if (map == null) {
            return;
        }
        if (((Object)map).equals(defVal)) {
            return;
        }
        Element stringMap = this.appendElement(name);
        for (Savable savable : map.keySet()) {
            Element mapEntry = this.appendElement("MapEntry");
            this.write(savable, "Key", null);
            Savable value = map.get(savable);
            this.write(value, "Value", null);
            this.currentElement = stringMap;
        }
        this.currentElement = (Element)stringMap.getParentNode();
    }

    public void writeStringSavableMap(Map<String, ? extends Savable> map, String name, Map<String, ? extends Savable> defVal) throws IOException {
        if (map == null) {
            return;
        }
        if (((Object)map).equals(defVal)) {
            return;
        }
        Element stringMap = this.appendElement(name);
        for (String key : map.keySet()) {
            Element mapEntry = this.appendElement("MapEntry");
            mapEntry.setAttribute("key", key);
            Savable s = map.get(key);
            this.write(s, "Savable", null);
            this.currentElement = stringMap;
        }
        this.currentElement = (Element)stringMap.getParentNode();
    }

    public void writeIntSavableMap(IntMap<? extends Savable> map, String name, IntMap<? extends Savable> defVal) throws IOException {
        if (map == null) {
            return;
        }
        if (map.equals(defVal)) {
            return;
        }
        Element stringMap = this.appendElement(name);
        for (IntMap.Entry entry : map) {
            int key = entry.getKey();
            Element mapEntry = this.appendElement("MapEntry");
            mapEntry.setAttribute("key", Integer.toString(key));
            Savable s = (Savable)entry.getValue();
            this.write(s, "Savable", null);
            this.currentElement = stringMap;
        }
        this.currentElement = (Element)stringMap.getParentNode();
    }

    public void write(FloatBuffer value, String name, FloatBuffer defVal) throws IOException {
        if (value == null) {
            return;
        }
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.limit()));
        StringBuilder buf = new StringBuilder();
        int pos = value.position();
        value.rewind();
        int ctr = 0;
        while (value.hasRemaining()) {
            ++ctr;
            buf.append(value.get());
            buf.append(" ");
        }
        if (ctr != value.limit()) {
            throw new IOException("'" + name + "' buffer contention resulted in write data consistency.  " + ctr + " values written when should have written " + value.limit());
        }
        buf.setLength(Math.max(0, buf.length() - 1));
        value.position(pos);
        el.setAttribute(dataAttributeName, buf.toString());
        this.currentElement = (Element)el.getParentNode();
    }

    public void write(IntBuffer value, String name, IntBuffer defVal) throws IOException {
        if (value == null) {
            return;
        }
        if (value.equals(defVal)) {
            return;
        }
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.limit()));
        StringBuilder buf = new StringBuilder();
        int pos = value.position();
        value.rewind();
        int ctr = 0;
        while (value.hasRemaining()) {
            ++ctr;
            buf.append(value.get());
            buf.append(" ");
        }
        if (ctr != value.limit()) {
            throw new IOException("'" + name + "' buffer contention resulted in write data consistency.  " + ctr + " values written when should have written " + value.limit());
        }
        buf.setLength(buf.length() - 1);
        value.position(pos);
        el.setAttribute(dataAttributeName, buf.toString());
        this.currentElement = (Element)el.getParentNode();
    }

    public void write(ByteBuffer value, String name, ByteBuffer defVal) throws IOException {
        if (value == null) {
            return;
        }
        if (value.equals(defVal)) {
            return;
        }
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.limit()));
        StringBuilder buf = new StringBuilder();
        int pos = value.position();
        value.rewind();
        int ctr = 0;
        while (value.hasRemaining()) {
            ++ctr;
            buf.append(value.get());
            buf.append(" ");
        }
        if (ctr != value.limit()) {
            throw new IOException("'" + name + "' buffer contention resulted in write data consistency.  " + ctr + " values written when should have written " + value.limit());
        }
        buf.setLength(buf.length() - 1);
        value.position(pos);
        el.setAttribute(dataAttributeName, buf.toString());
        this.currentElement = (Element)el.getParentNode();
    }

    public void write(ShortBuffer value, String name, ShortBuffer defVal) throws IOException {
        if (value == null) {
            return;
        }
        if (value.equals(defVal)) {
            return;
        }
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(value.limit()));
        StringBuilder buf = new StringBuilder();
        int pos = value.position();
        value.rewind();
        int ctr = 0;
        while (value.hasRemaining()) {
            ++ctr;
            buf.append(value.get());
            buf.append(" ");
        }
        if (ctr != value.limit()) {
            throw new IOException("'" + name + "' buffer contention resulted in write data consistency.  " + ctr + " values written when should have written " + value.limit());
        }
        buf.setLength(buf.length() - 1);
        value.position(pos);
        el.setAttribute(dataAttributeName, buf.toString());
        this.currentElement = (Element)el.getParentNode();
    }

    public void write(Enum value, String name, Enum defVal) throws IOException {
        if (value == defVal) {
            return;
        }
        this.currentElement.setAttribute(name, String.valueOf(value));
    }

    public void writeByteBufferArrayList(ArrayList<ByteBuffer> array, String name, ArrayList<ByteBuffer> defVal) throws IOException {
        if (array == null) {
            return;
        }
        if (array.equals(defVal)) {
            return;
        }
        Element el = this.appendElement(name);
        el.setAttribute("size", String.valueOf(array.size()));
        for (ByteBuffer o : array) {
            this.write(o, "ByteBuffer", null);
        }
        this.currentElement = (Element)el.getParentNode();
    }
}

