/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.control;

import com.jme3.animation.AnimControl;
import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SkeletonControl;
import com.jme3.asset.AssetManager;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.PhysicsCollisionEvent;
import com.jme3.bullet.collision.PhysicsCollisionListener;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.collision.RagdollCollisionListener;
import com.jme3.bullet.collision.shapes.BoxCollisionShape;
import com.jme3.bullet.collision.shapes.HullCollisionShape;
import com.jme3.bullet.control.PhysicsControl;
import com.jme3.bullet.control.ragdoll.HumanoidRagdollPreset;
import com.jme3.bullet.control.ragdoll.RagdollPreset;
import com.jme3.bullet.control.ragdoll.RagdollUtils;
import com.jme3.bullet.joints.SixDofJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.util.TempVars;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KinematicRagdollControl
implements PhysicsControl,
PhysicsCollisionListener {
    protected static final Logger logger = Logger.getLogger(KinematicRagdollControl.class.getName());
    protected Map<String, PhysicsBoneLink> boneLinks = new HashMap<String, PhysicsBoneLink>();
    protected Skeleton skeleton;
    protected PhysicsSpace space;
    protected boolean enabled = true;
    protected boolean debug = false;
    protected PhysicsRigidBody baseRigidBody;
    protected float weightThreshold = -1.0f;
    protected Spatial targetModel;
    protected Vector3f initScale;
    protected Mode mode = Mode.Kinematic;
    protected boolean blendedControl = false;
    protected float blendTime = 1.0f;
    protected float blendStart = 0.0f;
    protected List<RagdollCollisionListener> listeners;
    protected float eventDispatchImpulseThreshold = 10.0f;
    protected RagdollPreset preset = new HumanoidRagdollPreset();
    protected Set<String> boneList = new TreeSet<String>();
    protected Vector3f modelPosition = new Vector3f();
    protected Quaternion modelRotation = new Quaternion();
    protected float rootMass = 15.0f;
    protected float totalMass = 0.0f;
    protected boolean added = false;

    public KinematicRagdollControl() {
    }

    public KinematicRagdollControl(float weightThreshold) {
        this.weightThreshold = weightThreshold;
    }

    public KinematicRagdollControl(RagdollPreset preset, float weightThreshold) {
        this.preset = preset;
        this.weightThreshold = weightThreshold;
    }

    public KinematicRagdollControl(RagdollPreset preset) {
        this.preset = preset;
    }

    public void update(float tpf) {
        if (!this.enabled) {
            return;
        }
        TempVars vars = TempVars.get();
        Quaternion tmpRot1 = vars.quat1;
        Quaternion tmpRot2 = vars.quat2;
        if (this.mode == Mode.Ragdoll && this.targetModel.getLocalTranslation().equals((Object)this.modelPosition)) {
            for (PhysicsBoneLink link : this.boneLinks.values()) {
                Vector3f position = vars.vect1;
                Vector3f p = link.rigidBody.getMotionState().getWorldLocation();
                this.targetModel.getWorldTransform().transformInverseVector(p, position);
                Quaternion q = link.rigidBody.getMotionState().getWorldRotationQuat();
                tmpRot1.set(q).multLocal(link.initalWorldRotation);
                tmpRot2.set(this.targetModel.getWorldRotation()).inverseLocal().mult(tmpRot1, tmpRot1);
                tmpRot1.normalizeLocal();
                if (link.bone.getParent() == null) {
                    this.modelPosition.set(p).subtractLocal(link.bone.getWorldBindPosition());
                    this.targetModel.getParent().getWorldTransform().transformInverseVector(this.modelPosition, this.modelPosition);
                    this.modelRotation.set(q).multLocal(tmpRot2.set(link.bone.getWorldBindRotation()).inverseLocal());
                    this.targetModel.setLocalTranslation(this.modelPosition);
                    this.targetModel.setLocalRotation(this.modelRotation);
                    link.bone.setUserTransformsWorld(position, tmpRot1);
                    continue;
                }
                if (this.boneList.isEmpty()) {
                    link.bone.setUserTransformsWorld(position, tmpRot1);
                    continue;
                }
                RagdollUtils.setTransform(link.bone, position, tmpRot1, false, this.boneList);
            }
        } else {
            for (PhysicsBoneLink link : this.boneLinks.values()) {
                Vector3f position = vars.vect1;
                if (this.blendedControl) {
                    Vector3f position2 = vars.vect2;
                    position.set(link.startBlendingPos);
                    tmpRot1.set(link.startBlendingRot);
                    tmpRot2.set(tmpRot1).nlerp(link.bone.getModelSpaceRotation(), this.blendStart / this.blendTime);
                    position2.set(position).interpolate(link.bone.getModelSpacePosition(), this.blendStart / this.blendTime);
                    tmpRot1.set(tmpRot2);
                    position.set(position2);
                    if (this.boneList.isEmpty()) {
                        link.bone.setUserControl(true);
                        link.bone.setUserTransformsWorld(position, tmpRot1);
                        link.bone.setUserControl(false);
                    } else {
                        RagdollUtils.setTransform(link.bone, position, tmpRot1, true, this.boneList);
                    }
                }
                this.matchPhysicObjectToBone(link, position, tmpRot1);
                this.modelPosition.set(this.targetModel.getLocalTranslation());
            }
            if (this.blendedControl) {
                this.blendStart += tpf;
                if (this.blendStart > this.blendTime) {
                    this.blendedControl = false;
                }
            }
        }
        vars.release();
    }

    private void matchPhysicObjectToBone(PhysicsBoneLink link, Vector3f position, Quaternion tmpRot1) {
        this.targetModel.getWorldTransform().transformVector(link.bone.getModelSpacePosition(), position);
        tmpRot1.set(link.bone.getModelSpaceRotation()).multLocal(link.bone.getWorldBindInverseRotation());
        this.targetModel.getWorldRotation().mult(tmpRot1, tmpRot1);
        tmpRot1.normalizeLocal();
        link.rigidBody.setPhysicsLocation(position);
        link.rigidBody.setPhysicsRotation(tmpRot1);
    }

    public Control cloneForSpatial(Spatial spatial) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void reBuild() {
        this.setSpatial(this.targetModel);
        this.addToPhysicsSpace();
    }

    public void setSpatial(Spatial model) {
        if (model == null) {
            this.removeFromPhysicsSpace();
            this.clearData();
            return;
        }
        this.targetModel = model;
        Node parent = model.getParent();
        Vector3f initPosition = model.getLocalTranslation().clone();
        Quaternion initRotation = model.getLocalRotation().clone();
        this.initScale = model.getLocalScale().clone();
        model.removeFromParent();
        model.setLocalTranslation(Vector3f.ZERO);
        model.setLocalRotation(Quaternion.IDENTITY);
        model.setLocalScale(1.0f);
        SkeletonControl sc = (SkeletonControl)model.getControl(SkeletonControl.class);
        model.removeControl((Control)sc);
        model.addControl((Control)sc);
        this.removeFromPhysicsSpace();
        this.clearData();
        this.scanSpatial(model);
        if (parent != null) {
            parent.attachChild(model);
        }
        model.setLocalTranslation(initPosition);
        model.setLocalRotation(initRotation);
        model.setLocalScale(this.initScale);
        logger.log(Level.INFO, "Created physics ragdoll for skeleton {0}", this.skeleton);
    }

    public void addBoneName(String name) {
        this.boneList.add(name);
    }

    private void scanSpatial(Spatial model) {
        AnimControl animControl = (AnimControl)model.getControl(AnimControl.class);
        Map<Integer, List<Float>> pointsMap = null;
        if (this.weightThreshold == -1.0f) {
            pointsMap = RagdollUtils.buildPointMap(model);
        }
        this.skeleton = animControl.getSkeleton();
        this.skeleton.resetAndUpdate();
        for (int i = 0; i < this.skeleton.getRoots().length; ++i) {
            Bone childBone = this.skeleton.getRoots()[i];
            if (childBone.getParent() != null) continue;
            logger.log(Level.INFO, "Found root bone in skeleton {0}", this.skeleton);
            this.baseRigidBody = new PhysicsRigidBody(new BoxCollisionShape(Vector3f.UNIT_XYZ.mult(0.1f)), 1.0f);
            this.baseRigidBody.setKinematic(this.mode == Mode.Kinematic);
            this.boneRecursion(model, childBone, this.baseRigidBody, 1, pointsMap);
        }
    }

    private void boneRecursion(Spatial model, Bone bone, PhysicsRigidBody parent, int reccount, Map<Integer, List<Float>> pointsMap) {
        PhysicsRigidBody parentShape = parent;
        if (this.boneList.isEmpty() || this.boneList.contains(bone.getName())) {
            PhysicsBoneLink link = new PhysicsBoneLink();
            link.bone = bone;
            HullCollisionShape shape = null;
            shape = pointsMap != null ? RagdollUtils.makeShapeFromPointMap(pointsMap, RagdollUtils.getBoneIndices(link.bone, this.skeleton, this.boneList), this.initScale, link.bone.getModelSpacePosition()) : RagdollUtils.makeShapeFromVerticeWeights(model, RagdollUtils.getBoneIndices(link.bone, this.skeleton, this.boneList), this.initScale, link.bone.getModelSpacePosition(), this.weightThreshold);
            PhysicsRigidBody shapeNode = new PhysicsRigidBody(shape, this.rootMass / (float)reccount);
            shapeNode.setKinematic(this.mode == Mode.Kinematic);
            this.totalMass += this.rootMass / (float)reccount;
            link.rigidBody = shapeNode;
            link.initalWorldRotation = bone.getModelSpaceRotation().clone();
            if (parent != null) {
                Vector3f posToParent = new Vector3f();
                if (bone.getParent() != null) {
                    bone.getModelSpacePosition().subtract(bone.getParent().getModelSpacePosition(), posToParent).multLocal(this.initScale);
                }
                SixDofJoint joint = new SixDofJoint(parent, shapeNode, posToParent, new Vector3f(0.0f, 0.0f, 0.0f), true);
                this.preset.setupJointForBone(bone.getName(), joint);
                link.joint = joint;
                joint.setCollisionBetweenLinkedBodys(false);
            }
            this.boneLinks.put(bone.getName(), link);
            shapeNode.setUserObject(link);
            parentShape = shapeNode;
        }
        for (Bone childBone : bone.getChildren()) {
            this.boneRecursion(model, childBone, parentShape, reccount + 1, pointsMap);
        }
    }

    public void setJointLimit(String boneName, float maxX, float minX, float maxY, float minY, float maxZ, float minZ) {
        PhysicsBoneLink link = this.boneLinks.get(boneName);
        if (link != null) {
            RagdollUtils.setJointLimit(link.joint, maxX, minX, maxY, minY, maxZ, minZ);
        } else {
            logger.log(Level.WARNING, "Not joint was found for bone {0}. make sure you call spatial.addControl(ragdoll) before setting joints limit", boneName);
        }
    }

    public SixDofJoint getJoint(String boneName) {
        PhysicsBoneLink link = this.boneLinks.get(boneName);
        if (link != null) {
            return link.joint;
        }
        logger.log(Level.WARNING, "Not joint was found for bone {0}. make sure you call spatial.addControl(ragdoll) before setting joints limit", boneName);
        return null;
    }

    private void clearData() {
        this.boneLinks.clear();
        this.baseRigidBody = null;
    }

    private void addToPhysicsSpace() {
        if (this.space == null) {
            return;
        }
        if (this.baseRigidBody != null) {
            this.space.add(this.baseRigidBody);
            this.added = true;
        }
        for (PhysicsBoneLink physicsBoneLink : this.boneLinks.values()) {
            if (physicsBoneLink.rigidBody == null) continue;
            this.space.add(physicsBoneLink.rigidBody);
            if (physicsBoneLink.joint != null) {
                this.space.add(physicsBoneLink.joint);
            }
            this.added = true;
        }
    }

    protected void removeFromPhysicsSpace() {
        if (this.space == null) {
            return;
        }
        if (this.baseRigidBody != null) {
            this.space.remove(this.baseRigidBody);
        }
        for (PhysicsBoneLink physicsBoneLink : this.boneLinks.values()) {
            if (physicsBoneLink.joint == null) continue;
            this.space.remove(physicsBoneLink.joint);
            if (physicsBoneLink.rigidBody == null) continue;
            this.space.remove(physicsBoneLink.rigidBody);
        }
        this.added = false;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        if (!enabled && this.space != null) {
            this.removeFromPhysicsSpace();
        } else if (enabled && this.space != null) {
            this.addToPhysicsSpace();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected void attachDebugShape(AssetManager manager) {
        for (PhysicsBoneLink physicsBoneLink : this.boneLinks.values()) {
            physicsBoneLink.rigidBody.createDebugShape(manager);
        }
        this.debug = true;
    }

    protected void detachDebugShape() {
        for (PhysicsBoneLink physicsBoneLink : this.boneLinks.values()) {
            physicsBoneLink.rigidBody.detachDebugShape();
        }
        this.debug = false;
    }

    public void render(RenderManager rm, ViewPort vp) {
        if (this.enabled && this.space != null && this.space.getDebugManager() != null) {
            if (!this.debug) {
                this.attachDebugShape(this.space.getDebugManager());
            }
            for (PhysicsBoneLink physicsBoneLink : this.boneLinks.values()) {
                Spatial debugShape = physicsBoneLink.rigidBody.debugShape();
                if (debugShape == null) continue;
                debugShape.setLocalTranslation(physicsBoneLink.rigidBody.getMotionState().getWorldLocation());
                debugShape.setLocalRotation(physicsBoneLink.rigidBody.getMotionState().getWorldRotationQuat());
                debugShape.updateGeometricState();
                rm.renderScene(debugShape, vp);
            }
        }
    }

    @Override
    public void setPhysicsSpace(PhysicsSpace space) {
        if (space == null) {
            this.removeFromPhysicsSpace();
            this.space = space;
        } else {
            if (this.space == space) {
                return;
            }
            this.space = space;
            this.addToPhysicsSpace();
            this.space.addCollisionListener(this);
        }
    }

    @Override
    public PhysicsSpace getPhysicsSpace() {
        return this.space;
    }

    public void write(JmeExporter ex) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void read(JmeImporter im) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void collision(PhysicsCollisionEvent event) {
        PhysicsBoneLink link;
        PhysicsCollisionObject objA = event.getObjectA();
        PhysicsCollisionObject objB = event.getObjectB();
        if (event.getNodeA() == null && event.getNodeB() == null) {
            return;
        }
        if (event.getAppliedImpulse() < this.eventDispatchImpulseThreshold) {
            return;
        }
        boolean hit = false;
        Bone hitBone = null;
        PhysicsCollisionObject hitObject = null;
        if (objA.getUserObject() instanceof PhysicsBoneLink && (link = (PhysicsBoneLink)objA.getUserObject()) != null) {
            hit = true;
            hitBone = link.bone;
            hitObject = objB;
        }
        if (objB.getUserObject() instanceof PhysicsBoneLink && (link = (PhysicsBoneLink)objB.getUserObject()) != null) {
            hit = true;
            hitBone = link.bone;
            hitObject = objA;
        }
        if (hit && this.listeners != null) {
            for (RagdollCollisionListener listener : this.listeners) {
                listener.collide(hitBone, hitObject, event);
            }
        }
    }

    protected void setMode(Mode mode) {
        this.mode = mode;
        AnimControl animControl = (AnimControl)this.targetModel.getControl(AnimControl.class);
        animControl.setEnabled(mode == Mode.Kinematic);
        this.baseRigidBody.setKinematic(mode == Mode.Kinematic);
        TempVars vars = TempVars.get();
        for (PhysicsBoneLink link : this.boneLinks.values()) {
            link.rigidBody.setKinematic(mode == Mode.Kinematic);
            if (mode != Mode.Ragdoll) continue;
            Quaternion tmpRot1 = vars.quat1;
            Vector3f position = vars.vect1;
            this.matchPhysicObjectToBone(link, position, tmpRot1);
        }
        vars.release();
        for (Bone bone : this.skeleton.getRoots()) {
            RagdollUtils.setUserControl(bone, mode == Mode.Ragdoll);
        }
    }

    public void blendToKinematicMode(float blendTime) {
        if (this.mode == Mode.Kinematic) {
            return;
        }
        this.blendedControl = true;
        this.blendTime = blendTime;
        this.mode = Mode.Kinematic;
        AnimControl animControl = (AnimControl)this.targetModel.getControl(AnimControl.class);
        animControl.setEnabled(true);
        TempVars vars = TempVars.get();
        for (PhysicsBoneLink link : this.boneLinks.values()) {
            Vector3f p = link.rigidBody.getMotionState().getWorldLocation();
            Vector3f position = vars.vect1;
            this.targetModel.getWorldTransform().transformInverseVector(p, position);
            Quaternion q = link.rigidBody.getMotionState().getWorldRotationQuat();
            Quaternion q2 = vars.quat1;
            Quaternion q3 = vars.quat2;
            q2.set(q).multLocal(link.initalWorldRotation).normalizeLocal();
            q3.set(this.targetModel.getWorldRotation()).inverseLocal().mult(q2, q2);
            q2.normalizeLocal();
            link.startBlendingPos.set(position);
            link.startBlendingRot.set(q2);
            link.rigidBody.setKinematic(true);
        }
        vars.release();
        for (Bone bone : this.skeleton.getRoots()) {
            RagdollUtils.setUserControl(bone, false);
        }
        this.blendStart = 0.0f;
    }

    public void setKinematicMode() {
        if (this.mode != Mode.Kinematic) {
            this.setMode(Mode.Kinematic);
        }
    }

    public void setRagdollMode() {
        if (this.mode != Mode.Ragdoll) {
            this.setMode(Mode.Ragdoll);
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    public void addCollisionListener(RagdollCollisionListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<RagdollCollisionListener>();
        }
        this.listeners.add(listener);
    }

    public void setRootMass(float rootMass) {
        this.rootMass = rootMass;
    }

    public float getTotalMass() {
        return this.totalMass;
    }

    public float getWeightThreshold() {
        return this.weightThreshold;
    }

    public void setWeightThreshold(float weightThreshold) {
        this.weightThreshold = weightThreshold;
    }

    public float getEventDispatchImpulseThreshold() {
        return this.eventDispatchImpulseThreshold;
    }

    public void setEventDispatchImpulseThreshold(float eventDispatchImpulseThreshold) {
        this.eventDispatchImpulseThreshold = eventDispatchImpulseThreshold;
    }

    public void setCcdMotionThreshold(float value) {
        for (PhysicsBoneLink link : this.boneLinks.values()) {
            link.rigidBody.setCcdMotionThreshold(value);
        }
    }

    public void setCcdSweptSphereRadius(float value) {
        for (PhysicsBoneLink link : this.boneLinks.values()) {
            link.rigidBody.setCcdSweptSphereRadius(value);
        }
    }

    public PhysicsRigidBody getBoneRigidBody(String boneName) {
        PhysicsBoneLink link = this.boneLinks.get(boneName);
        if (link != null) {
            return link.rigidBody;
        }
        return null;
    }

    public class PhysicsBoneLink {
        protected Bone bone;
        protected PhysicsRigidBody rigidBody;
        protected Quaternion initalWorldRotation;
        protected SixDofJoint joint;
        protected Quaternion startBlendingRot = new Quaternion();
        protected Vector3f startBlendingPos = new Vector3f();

        public Bone getBone() {
            return this.bone;
        }

        public PhysicsRigidBody getRigidBody() {
            return this.rigidBody;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        Kinematic,
        Ragdoll;

    }
}

