/*
 * Decompiled with CFR 0.152.
 */
package jme3tools.optimize;

import com.jme3.material.Material;
import com.jme3.math.Matrix4f;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeometryBatchFactory {
    private static final Logger logger = Logger.getLogger(GeometryBatchFactory.class.getName());

    private static void doTransformVerts(FloatBuffer inBuf, int offset, FloatBuffer outBuf, Matrix4f transform) {
        Vector3f pos = new Vector3f();
        offset *= 3;
        for (int i = 0; i < inBuf.limit() / 3; ++i) {
            pos.x = inBuf.get(i * 3 + 0);
            pos.y = inBuf.get(i * 3 + 1);
            pos.z = inBuf.get(i * 3 + 2);
            transform.mult(pos, pos);
            outBuf.put(offset + i * 3 + 0, pos.x);
            outBuf.put(offset + i * 3 + 1, pos.y);
            outBuf.put(offset + i * 3 + 2, pos.z);
        }
    }

    private static void doTransformNorms(FloatBuffer inBuf, int offset, FloatBuffer outBuf, Matrix4f transform) {
        Vector3f norm = new Vector3f();
        offset *= 3;
        for (int i = 0; i < inBuf.limit() / 3; ++i) {
            norm.x = inBuf.get(i * 3 + 0);
            norm.y = inBuf.get(i * 3 + 1);
            norm.z = inBuf.get(i * 3 + 2);
            transform.multNormal(norm, norm);
            outBuf.put(offset + i * 3 + 0, norm.x);
            outBuf.put(offset + i * 3 + 1, norm.y);
            outBuf.put(offset + i * 3 + 2, norm.z);
        }
    }

    private static void doTransformTangents(FloatBuffer inBuf, int offset, int components, FloatBuffer outBuf, Matrix4f transform) {
        Vector3f tan = new Vector3f();
        offset *= components;
        for (int i = 0; i < inBuf.limit() / components; ++i) {
            tan.x = inBuf.get(i * components + 0);
            tan.y = inBuf.get(i * components + 1);
            tan.z = inBuf.get(i * components + 2);
            transform.multNormal(tan, tan);
            outBuf.put(offset + i * components + 0, tan.x);
            outBuf.put(offset + i * components + 1, tan.y);
            outBuf.put(offset + i * components + 2, tan.z);
            if (components != 4) continue;
            outBuf.put(offset + i * components + 3, inBuf.get(i * components + 3));
        }
    }

    public static void mergeGeometries(Collection<Geometry> geometries, Mesh outMesh) {
        int[] compsForBuf = new int[VertexBuffer.Type.values().length];
        VertexBuffer.Format[] formatForBuf = new VertexBuffer.Format[compsForBuf.length];
        int totalVerts = 0;
        int totalTris = 0;
        int totalLodLevels = 0;
        Mesh.Mode mode = null;
        for (Geometry geom : geometries) {
            int components;
            Mesh.Mode listMode;
            totalVerts += geom.getVertexCount();
            totalTris += geom.getTriangleCount();
            totalLodLevels = Math.min(totalLodLevels, geom.getMesh().getNumLodLevels());
            switch (geom.getMesh().getMode()) {
                case Points: {
                    listMode = Mesh.Mode.Points;
                    components = 1;
                    break;
                }
                case LineLoop: 
                case LineStrip: 
                case Lines: {
                    listMode = Mesh.Mode.Lines;
                    components = 2;
                    break;
                }
                case TriangleFan: 
                case TriangleStrip: 
                case Triangles: {
                    listMode = Mesh.Mode.Triangles;
                    components = 3;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            for (VertexBuffer vb : geom.getMesh().getBufferList().getArray()) {
                compsForBuf[vb.getBufferType().ordinal()] = vb.getNumComponents();
                formatForBuf[vb.getBufferType().ordinal()] = vb.getFormat();
            }
            if (mode != null && mode != listMode) {
                throw new UnsupportedOperationException("Cannot combine different primitive types: " + (Object)((Object)mode) + " != " + (Object)((Object)listMode));
            }
            mode = listMode;
            compsForBuf[VertexBuffer.Type.Index.ordinal()] = components;
        }
        outMesh.setMode(mode);
        formatForBuf[VertexBuffer.Type.Index.ordinal()] = totalVerts >= 65536 ? VertexBuffer.Format.UnsignedInt : VertexBuffer.Format.UnsignedShort;
        for (int i = 0; i < compsForBuf.length; ++i) {
            if (compsForBuf[i] == 0) continue;
            Buffer data = i == VertexBuffer.Type.Index.ordinal() ? VertexBuffer.createBuffer(formatForBuf[i], compsForBuf[i], totalTris) : VertexBuffer.createBuffer(formatForBuf[i], compsForBuf[i], totalVerts);
            VertexBuffer vb = new VertexBuffer(VertexBuffer.Type.values()[i]);
            vb.setupData(VertexBuffer.Usage.Static, compsForBuf[i], formatForBuf[i], data);
            outMesh.setBuffer(vb);
        }
        int globalVertIndex = 0;
        int globalTriIndex = 0;
        for (Geometry geom : geometries) {
            Mesh inMesh = geom.getMesh();
            geom.computeWorldMatrix();
            Matrix4f worldMatrix = geom.getWorldMatrix();
            int geomVertCount = inMesh.getVertexCount();
            int geomTriCount = inMesh.getTriangleCount();
            for (int bufType = 0; bufType < compsForBuf.length; ++bufType) {
                FloatBuffer outPos;
                VertexBuffer inBuf = inMesh.getBuffer(VertexBuffer.Type.values()[bufType]);
                VertexBuffer outBuf = outMesh.getBuffer(VertexBuffer.Type.values()[bufType]);
                if (inBuf == null || outBuf == null) continue;
                if (VertexBuffer.Type.Index.ordinal() == bufType) {
                    int components = compsForBuf[bufType];
                    IndexBuffer inIdx = inMesh.getIndicesAsList();
                    IndexBuffer outIdx = outMesh.getIndexBuffer();
                    for (int tri = 0; tri < geomTriCount; ++tri) {
                        for (int comp = 0; comp < components; ++comp) {
                            int idx = inIdx.get(tri * components + comp) + globalVertIndex;
                            outIdx.put((globalTriIndex + tri) * components + comp, idx);
                        }
                    }
                    continue;
                }
                if (VertexBuffer.Type.Position.ordinal() == bufType) {
                    FloatBuffer inPos = (FloatBuffer)inBuf.getDataReadOnly();
                    outPos = (FloatBuffer)outBuf.getData();
                    GeometryBatchFactory.doTransformVerts(inPos, globalVertIndex, outPos, worldMatrix);
                    continue;
                }
                if (VertexBuffer.Type.Normal.ordinal() == bufType) {
                    FloatBuffer inPos = (FloatBuffer)inBuf.getDataReadOnly();
                    outPos = (FloatBuffer)outBuf.getData();
                    GeometryBatchFactory.doTransformNorms(inPos, globalVertIndex, outPos, worldMatrix);
                    continue;
                }
                if (VertexBuffer.Type.Tangent.ordinal() == bufType) {
                    FloatBuffer inPos = (FloatBuffer)inBuf.getDataReadOnly();
                    outPos = (FloatBuffer)outBuf.getData();
                    int components = inBuf.getNumComponents();
                    GeometryBatchFactory.doTransformTangents(inPos, globalVertIndex, components, outPos, worldMatrix);
                    continue;
                }
                inBuf.copyElements(0, outBuf, globalVertIndex, geomVertCount);
            }
            globalVertIndex += geomVertCount;
            globalTriIndex += geomTriCount;
        }
    }

    public static void makeLods(Collection<Geometry> geometries, Mesh outMesh) {
        int lodLevels = Integer.MAX_VALUE;
        for (Geometry g : geometries) {
            lodLevels = Math.min(lodLevels, g.getMesh().getNumLodLevels());
        }
        if (lodLevels == Integer.MAX_VALUE || lodLevels == 0) {
            return;
        }
        int[] lodSizes = new int[lodLevels];
        for (Geometry g : geometries) {
            for (int i = 0; i < lodLevels; ++i) {
                int n = i;
                lodSizes[n] = lodSizes[n] + g.getMesh().getLodLevel(i).getData().limit();
            }
        }
        IndexBuffer[] lods = new IndexBuffer[lodLevels];
        int[] bufferPos = new int[lodLevels];
        boolean numOfVertices = false;
        boolean curGeom = false;
        for (int lodLevel = 0; lodLevel < lodLevels; ++lodLevel) {
        }
    }

    public static List<Geometry> makeBatches(Collection<Geometry> geometries) {
        return GeometryBatchFactory.makeBatches(geometries, false);
    }

    public static List<Geometry> makeBatches(Collection<Geometry> geometries, boolean useLods) {
        ArrayList<Geometry> retVal = new ArrayList<Geometry>();
        HashMap<Material, ArrayList<Geometry>> matToGeom = new HashMap<Material, ArrayList<Geometry>>();
        for (Geometry geom : geometries) {
            List<Geometry> outList = (ArrayList<Geometry>)matToGeom.get(geom.getMaterial());
            if (outList == null) {
                for (Material mat : matToGeom.keySet()) {
                    if (!geom.getMaterial().contentEquals(mat)) continue;
                    outList = (List)matToGeom.get(mat);
                }
            }
            if (outList == null) {
                outList = new ArrayList<Geometry>();
                matToGeom.put(geom.getMaterial(), (ArrayList<Geometry>)outList);
            }
            outList.add(geom);
        }
        int batchNum = 0;
        for (Map.Entry entry : matToGeom.entrySet()) {
            Material mat = (Material)entry.getKey();
            List geomsForMat = (List)entry.getValue();
            Mesh mesh = new Mesh();
            GeometryBatchFactory.mergeGeometries(geomsForMat, mesh);
            if (useLods) {
                GeometryBatchFactory.makeLods(geomsForMat, mesh);
            }
            mesh.updateCounts();
            mesh.updateBound();
            Geometry out = new Geometry("batch[" + batchNum++ + "]", mesh);
            out.setMaterial(mat);
            retVal.add(out);
        }
        return retVal;
    }

    public static void gatherGeoms(Spatial scene, List<Geometry> geoms) {
        if (scene instanceof Node) {
            Node node = (Node)scene;
            for (Spatial child : node.getChildren()) {
                GeometryBatchFactory.gatherGeoms(child, geoms);
            }
        } else if (scene instanceof Geometry) {
            geoms.add((Geometry)scene);
        }
    }

    public static Spatial optimize(Node scene) {
        return GeometryBatchFactory.optimize(scene, false);
    }

    public static Node optimize(Node scene, boolean useLods) {
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        GeometryBatchFactory.gatherGeoms(scene, geoms);
        List<Geometry> batchedGeoms = GeometryBatchFactory.makeBatches(geoms, useLods);
        for (Geometry geom : batchedGeoms) {
            scene.attachChild(geom);
        }
        for (Geometry geometry : geoms) {
            geometry.removeFromParent();
        }
        scene.setLocalTransform(Transform.IDENTITY);
        return scene;
    }

    public static void printMesh(Mesh mesh) {
        for (int bufType = 0; bufType < VertexBuffer.Type.values().length; ++bufType) {
            VertexBuffer outBuf = mesh.getBuffer(VertexBuffer.Type.values()[bufType]);
            if (outBuf == null) continue;
            System.out.println((Object)((Object)outBuf.getBufferType()) + ": ");
            for (int vert = 0; vert < outBuf.getNumElements(); ++vert) {
                String str = "[";
                for (int comp = 0; comp < outBuf.getNumComponents(); ++comp) {
                    Object val = outBuf.getElementComponent(vert, comp);
                    outBuf.setElementComponent(vert, comp, val);
                    val = outBuf.getElementComponent(vert, comp);
                    str = str + val;
                    if (comp == outBuf.getNumComponents() - 1) continue;
                    str = str + ", ";
                }
                str = str + "]";
                System.out.println(str);
            }
            System.out.println("------");
        }
    }

    public static void main(String[] args) {
        Mesh mesh = new Mesh();
        mesh.setBuffer(VertexBuffer.Type.Position, 3, new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f});
        mesh.setBuffer(VertexBuffer.Type.Index, 2, new short[]{0, 1, 1, 2, 2, 3, 3, 0});
        Geometry g1 = new Geometry("g1", mesh);
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        geoms.add(g1);
        Mesh outMesh = new Mesh();
        GeometryBatchFactory.mergeGeometries(geoms, outMesh);
        GeometryBatchFactory.printMesh(outMesh);
    }
}

