/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class JmeFormatter
extends Formatter {
    private Date calendar = new Date();
    private String lineSeperator;
    private MessageFormat format;
    private Object[] args = new Object[1];
    private StringBuffer store = new StringBuffer();

    public JmeFormatter() {
        this.lineSeperator = System.getProperty("line.separator");
        this.format = new MessageFormat("{0,time}");
    }

    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        this.calendar.setTime(record.getMillis());
        this.args[0] = this.calendar;
        this.store.setLength(0);
        this.format.format(this.args, this.store, (FieldPosition)null);
        String clazz = null;
        try {
            clazz = Class.forName(record.getSourceClassName()).getSimpleName();
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        sb.append(record.getLevel().getLocalizedName()).append(" ");
        sb.append(clazz).append(" ");
        sb.append(this.store.toString()).append(" ");
        sb.append(this.formatMessage(record)).append(this.lineSeperator);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return sb.toString();
    }
}

