/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.util.TempVars;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class BufferUtils {
    private static boolean trackDirectMemory = false;
    private static ReferenceQueue<Buffer> removeCollected = new ReferenceQueue();
    private static ConcurrentHashMap<BufferInfo, BufferInfo> trackedBuffers = new ConcurrentHashMap();
    static ClearReferences cleanupthread;
    private static final AtomicBoolean loadedMethods;
    private static Method cleanerMethod;
    private static Method cleanMethod;
    private static Method viewedBufferMethod;
    private static Method freeMethod;

    public static void setTrackDirectMemoryEnabled(boolean enabled) {
        trackDirectMemory = enabled;
    }

    public static Buffer clone(Buffer buf) {
        if (buf instanceof FloatBuffer) {
            return BufferUtils.clone((FloatBuffer)buf);
        }
        if (buf instanceof ShortBuffer) {
            return BufferUtils.clone((ShortBuffer)buf);
        }
        if (buf instanceof ByteBuffer) {
            return BufferUtils.clone((ByteBuffer)buf);
        }
        if (buf instanceof IntBuffer) {
            return BufferUtils.clone((IntBuffer)buf);
        }
        if (buf instanceof DoubleBuffer) {
            return BufferUtils.clone((DoubleBuffer)buf);
        }
        throw new UnsupportedOperationException();
    }

    private static void onBufferAllocated(Buffer buffer) {
        if (trackDirectMemory) {
            if (cleanupthread == null) {
                cleanupthread = new ClearReferences();
                cleanupthread.start();
            }
            if (buffer instanceof ByteBuffer) {
                BufferInfo info = new BufferInfo(ByteBuffer.class, buffer.capacity(), buffer, removeCollected);
                trackedBuffers.put(info, info);
            } else if (buffer instanceof FloatBuffer) {
                BufferInfo info = new BufferInfo(FloatBuffer.class, buffer.capacity() * 4, buffer, removeCollected);
                trackedBuffers.put(info, info);
            } else if (buffer instanceof IntBuffer) {
                BufferInfo info = new BufferInfo(IntBuffer.class, buffer.capacity() * 4, buffer, removeCollected);
                trackedBuffers.put(info, info);
            } else if (buffer instanceof ShortBuffer) {
                BufferInfo info = new BufferInfo(ShortBuffer.class, buffer.capacity() * 2, buffer, removeCollected);
                trackedBuffers.put(info, info);
            } else if (buffer instanceof DoubleBuffer) {
                BufferInfo info = new BufferInfo(DoubleBuffer.class, buffer.capacity() * 8, buffer, removeCollected);
                trackedBuffers.put(info, info);
            }
        }
    }

    public static FloatBuffer createFloatBuffer(Vector3f ... data) {
        if (data == null) {
            return null;
        }
        FloatBuffer buff = BufferUtils.createFloatBuffer(3 * data.length);
        for (Vector3f element : data) {
            if (element != null) {
                buff.put(element.x).put(element.y).put(element.z);
                continue;
            }
            buff.put(0.0f).put(0.0f).put(0.0f);
        }
        buff.flip();
        return buff;
    }

    public static FloatBuffer createFloatBuffer(Quaternion ... data) {
        if (data == null) {
            return null;
        }
        FloatBuffer buff = BufferUtils.createFloatBuffer(4 * data.length);
        for (Quaternion element : data) {
            if (element != null) {
                buff.put(element.getX()).put(element.getY()).put(element.getZ()).put(element.getW());
                continue;
            }
            buff.put(0.0f).put(0.0f).put(0.0f);
        }
        buff.flip();
        return buff;
    }

    public static FloatBuffer createFloatBuffer(Vector4f ... data) {
        if (data == null) {
            return null;
        }
        FloatBuffer buff = BufferUtils.createFloatBuffer(4 * data.length);
        for (int x = 0; x < data.length; ++x) {
            if (data[x] != null) {
                buff.put(data[x].getX()).put(data[x].getY()).put(data[x].getZ()).put(data[x].getW());
                continue;
            }
            buff.put(0.0f).put(0.0f).put(0.0f);
        }
        buff.flip();
        return buff;
    }

    public static FloatBuffer createFloatBuffer(float ... data) {
        if (data == null) {
            return null;
        }
        FloatBuffer buff = BufferUtils.createFloatBuffer(data.length);
        buff.clear();
        buff.put(data);
        buff.flip();
        return buff;
    }

    public static FloatBuffer createVector3Buffer(int vertices) {
        FloatBuffer vBuff = BufferUtils.createFloatBuffer(3 * vertices);
        return vBuff;
    }

    public static FloatBuffer createVector3Buffer(FloatBuffer buf, int vertices) {
        if (buf != null && buf.limit() == 3 * vertices) {
            buf.rewind();
            return buf;
        }
        return BufferUtils.createFloatBuffer(3 * vertices);
    }

    public static void setInBuffer(ColorRGBA color, FloatBuffer buf, int index) {
        buf.position(index * 4);
        buf.put(color.r);
        buf.put(color.g);
        buf.put(color.b);
        buf.put(color.a);
    }

    public static void setInBuffer(Quaternion quat, FloatBuffer buf, int index) {
        buf.position(index * 4);
        buf.put(quat.getX());
        buf.put(quat.getY());
        buf.put(quat.getZ());
        buf.put(quat.getW());
    }

    public static void setInBuffer(Vector4f vec, FloatBuffer buf, int index) {
        buf.position(index * 4);
        buf.put(vec.getX());
        buf.put(vec.getY());
        buf.put(vec.getZ());
        buf.put(vec.getW());
    }

    public static void setInBuffer(Vector3f vector, FloatBuffer buf, int index) {
        if (buf == null) {
            return;
        }
        if (vector == null) {
            buf.put(index * 3, 0.0f);
            buf.put(index * 3 + 1, 0.0f);
            buf.put(index * 3 + 2, 0.0f);
        } else {
            buf.put(index * 3, vector.x);
            buf.put(index * 3 + 1, vector.y);
            buf.put(index * 3 + 2, vector.z);
        }
    }

    public static void populateFromBuffer(Vector3f vector, FloatBuffer buf, int index) {
        vector.x = buf.get(index * 3);
        vector.y = buf.get(index * 3 + 1);
        vector.z = buf.get(index * 3 + 2);
    }

    public static Vector3f[] getVector3Array(FloatBuffer buff) {
        buff.clear();
        Vector3f[] verts = new Vector3f[buff.limit() / 3];
        for (int x = 0; x < verts.length; ++x) {
            Vector3f v;
            verts[x] = v = new Vector3f(buff.get(), buff.get(), buff.get());
        }
        return verts;
    }

    public static void copyInternalVector3(FloatBuffer buf, int fromPos, int toPos) {
        BufferUtils.copyInternal(buf, fromPos * 3, toPos * 3, 3);
    }

    public static void normalizeVector3(FloatBuffer buf, int index) {
        TempVars vars = TempVars.get();
        Vector3f tempVec3 = vars.vect1;
        BufferUtils.populateFromBuffer(tempVec3, buf, index);
        tempVec3.normalizeLocal();
        BufferUtils.setInBuffer(tempVec3, buf, index);
        vars.release();
    }

    public static void addInBuffer(Vector3f toAdd, FloatBuffer buf, int index) {
        TempVars vars = TempVars.get();
        Vector3f tempVec3 = vars.vect1;
        BufferUtils.populateFromBuffer(tempVec3, buf, index);
        tempVec3.addLocal(toAdd);
        BufferUtils.setInBuffer(tempVec3, buf, index);
        vars.release();
    }

    public static void multInBuffer(Vector3f toMult, FloatBuffer buf, int index) {
        TempVars vars = TempVars.get();
        Vector3f tempVec3 = vars.vect1;
        BufferUtils.populateFromBuffer(tempVec3, buf, index);
        tempVec3.multLocal(toMult);
        BufferUtils.setInBuffer(tempVec3, buf, index);
        vars.release();
    }

    public static boolean equals(Vector3f check, FloatBuffer buf, int index) {
        TempVars vars = TempVars.get();
        Vector3f tempVec3 = vars.vect1;
        BufferUtils.populateFromBuffer(tempVec3, buf, index);
        boolean eq = tempVec3.equals(check);
        vars.release();
        return eq;
    }

    public static FloatBuffer createFloatBuffer(Vector2f ... data) {
        if (data == null) {
            return null;
        }
        FloatBuffer buff = BufferUtils.createFloatBuffer(2 * data.length);
        for (Vector2f element : data) {
            if (element != null) {
                buff.put(element.x).put(element.y);
                continue;
            }
            buff.put(0.0f).put(0.0f);
        }
        buff.flip();
        return buff;
    }

    public static FloatBuffer createVector2Buffer(int vertices) {
        FloatBuffer vBuff = BufferUtils.createFloatBuffer(2 * vertices);
        return vBuff;
    }

    public static FloatBuffer createVector2Buffer(FloatBuffer buf, int vertices) {
        if (buf != null && buf.limit() == 2 * vertices) {
            buf.rewind();
            return buf;
        }
        return BufferUtils.createFloatBuffer(2 * vertices);
    }

    public static void setInBuffer(Vector2f vector, FloatBuffer buf, int index) {
        buf.put(index * 2, vector.x);
        buf.put(index * 2 + 1, vector.y);
    }

    public static void populateFromBuffer(Vector2f vector, FloatBuffer buf, int index) {
        vector.x = buf.get(index * 2);
        vector.y = buf.get(index * 2 + 1);
    }

    public static Vector2f[] getVector2Array(FloatBuffer buff) {
        buff.clear();
        Vector2f[] verts = new Vector2f[buff.limit() / 2];
        for (int x = 0; x < verts.length; ++x) {
            Vector2f v;
            verts[x] = v = new Vector2f(buff.get(), buff.get());
        }
        return verts;
    }

    public static void copyInternalVector2(FloatBuffer buf, int fromPos, int toPos) {
        BufferUtils.copyInternal(buf, fromPos * 2, toPos * 2, 2);
    }

    public static void normalizeVector2(FloatBuffer buf, int index) {
        TempVars vars = TempVars.get();
        Vector2f tempVec2 = vars.vect2d;
        BufferUtils.populateFromBuffer(tempVec2, buf, index);
        tempVec2.normalizeLocal();
        BufferUtils.setInBuffer(tempVec2, buf, index);
        vars.release();
    }

    public static void addInBuffer(Vector2f toAdd, FloatBuffer buf, int index) {
        TempVars vars = TempVars.get();
        Vector2f tempVec2 = vars.vect2d;
        BufferUtils.populateFromBuffer(tempVec2, buf, index);
        tempVec2.addLocal(toAdd);
        BufferUtils.setInBuffer(tempVec2, buf, index);
        vars.release();
    }

    public static void multInBuffer(Vector2f toMult, FloatBuffer buf, int index) {
        TempVars vars = TempVars.get();
        Vector2f tempVec2 = vars.vect2d;
        BufferUtils.populateFromBuffer(tempVec2, buf, index);
        tempVec2.multLocal(toMult);
        BufferUtils.setInBuffer(tempVec2, buf, index);
        vars.release();
    }

    public static boolean equals(Vector2f check, FloatBuffer buf, int index) {
        TempVars vars = TempVars.get();
        Vector2f tempVec2 = vars.vect2d;
        BufferUtils.populateFromBuffer(tempVec2, buf, index);
        boolean eq = tempVec2.equals(check);
        vars.release();
        return eq;
    }

    public static IntBuffer createIntBuffer(int ... data) {
        if (data == null) {
            return null;
        }
        IntBuffer buff = BufferUtils.createIntBuffer(data.length);
        buff.clear();
        buff.put(data);
        buff.flip();
        return buff;
    }

    public static int[] getIntArray(IntBuffer buff) {
        if (buff == null) {
            return null;
        }
        buff.clear();
        int[] inds = new int[buff.limit()];
        for (int x = 0; x < inds.length; ++x) {
            inds[x] = buff.get();
        }
        return inds;
    }

    public static float[] getFloatArray(FloatBuffer buff) {
        if (buff == null) {
            return null;
        }
        buff.clear();
        float[] inds = new float[buff.limit()];
        for (int x = 0; x < inds.length; ++x) {
            inds[x] = buff.get();
        }
        return inds;
    }

    public static DoubleBuffer createDoubleBuffer(int size) {
        DoubleBuffer buf = ByteBuffer.allocateDirect(8 * size).order(ByteOrder.nativeOrder()).asDoubleBuffer();
        buf.clear();
        BufferUtils.onBufferAllocated(buf);
        return buf;
    }

    public static DoubleBuffer createDoubleBuffer(DoubleBuffer buf, int size) {
        if (buf != null && buf.limit() == size) {
            buf.rewind();
            return buf;
        }
        buf = BufferUtils.createDoubleBuffer(size);
        return buf;
    }

    public static DoubleBuffer clone(DoubleBuffer buf) {
        if (buf == null) {
            return null;
        }
        buf.rewind();
        DoubleBuffer copy = buf.isDirect() ? BufferUtils.createDoubleBuffer(buf.limit()) : DoubleBuffer.allocate(buf.limit());
        copy.put(buf);
        return copy;
    }

    public static FloatBuffer createFloatBuffer(int size) {
        FloatBuffer buf = ByteBuffer.allocateDirect(4 * size).order(ByteOrder.nativeOrder()).asFloatBuffer();
        buf.clear();
        BufferUtils.onBufferAllocated(buf);
        return buf;
    }

    public static void copyInternal(FloatBuffer buf, int fromPos, int toPos, int length) {
        float[] data = new float[length];
        buf.position(fromPos);
        buf.get(data);
        buf.position(toPos);
        buf.put(data);
    }

    public static FloatBuffer clone(FloatBuffer buf) {
        if (buf == null) {
            return null;
        }
        buf.rewind();
        FloatBuffer copy = buf.isDirect() ? BufferUtils.createFloatBuffer(buf.limit()) : FloatBuffer.allocate(buf.limit());
        copy.put(buf);
        return copy;
    }

    public static IntBuffer createIntBuffer(int size) {
        IntBuffer buf = ByteBuffer.allocateDirect(4 * size).order(ByteOrder.nativeOrder()).asIntBuffer();
        buf.clear();
        BufferUtils.onBufferAllocated(buf);
        return buf;
    }

    public static IntBuffer createIntBuffer(IntBuffer buf, int size) {
        if (buf != null && buf.limit() == size) {
            buf.rewind();
            return buf;
        }
        buf = BufferUtils.createIntBuffer(size);
        return buf;
    }

    public static IntBuffer clone(IntBuffer buf) {
        if (buf == null) {
            return null;
        }
        buf.rewind();
        IntBuffer copy = buf.isDirect() ? BufferUtils.createIntBuffer(buf.limit()) : IntBuffer.allocate(buf.limit());
        copy.put(buf);
        return copy;
    }

    public static ByteBuffer createByteBuffer(int size) {
        ByteBuffer buf = ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder());
        buf.clear();
        BufferUtils.onBufferAllocated(buf);
        return buf;
    }

    public static ByteBuffer createByteBuffer(ByteBuffer buf, int size) {
        if (buf != null && buf.limit() == size) {
            buf.rewind();
            return buf;
        }
        buf = BufferUtils.createByteBuffer(size);
        return buf;
    }

    public static ByteBuffer createByteBuffer(byte ... data) {
        ByteBuffer bb = BufferUtils.createByteBuffer(data.length);
        bb.put(data);
        bb.flip();
        return bb;
    }

    public static ByteBuffer createByteBuffer(String data) {
        byte[] bytes = data.getBytes();
        ByteBuffer bb = BufferUtils.createByteBuffer(bytes.length);
        bb.put(bytes);
        bb.flip();
        return bb;
    }

    public static ByteBuffer clone(ByteBuffer buf) {
        if (buf == null) {
            return null;
        }
        buf.rewind();
        ByteBuffer copy = buf.isDirect() ? BufferUtils.createByteBuffer(buf.limit()) : ByteBuffer.allocate(buf.limit());
        copy.put(buf);
        return copy;
    }

    public static ShortBuffer createShortBuffer(int size) {
        ShortBuffer buf = ByteBuffer.allocateDirect(2 * size).order(ByteOrder.nativeOrder()).asShortBuffer();
        buf.clear();
        BufferUtils.onBufferAllocated(buf);
        return buf;
    }

    public static ShortBuffer createShortBuffer(ShortBuffer buf, int size) {
        if (buf != null && buf.limit() == size) {
            buf.rewind();
            return buf;
        }
        buf = BufferUtils.createShortBuffer(size);
        return buf;
    }

    public static ShortBuffer createShortBuffer(short ... data) {
        if (data == null) {
            return null;
        }
        ShortBuffer buff = BufferUtils.createShortBuffer(data.length);
        buff.clear();
        buff.put(data);
        buff.flip();
        return buff;
    }

    public static ShortBuffer clone(ShortBuffer buf) {
        if (buf == null) {
            return null;
        }
        buf.rewind();
        ShortBuffer copy = buf.isDirect() ? BufferUtils.createShortBuffer(buf.limit()) : ShortBuffer.allocate(buf.limit());
        copy.put(buf);
        return copy;
    }

    public static FloatBuffer ensureLargeEnough(FloatBuffer buffer, int required) {
        if (buffer == null || buffer.remaining() < required) {
            int position = buffer != null ? buffer.position() : 0;
            FloatBuffer newVerts = BufferUtils.createFloatBuffer(position + required);
            if (buffer != null) {
                buffer.flip();
                newVerts.put(buffer);
                newVerts.position(position);
            }
            buffer = newVerts;
        }
        return buffer;
    }

    public static ShortBuffer ensureLargeEnough(ShortBuffer buffer, int required) {
        if (buffer == null || buffer.remaining() < required) {
            int position = buffer != null ? buffer.position() : 0;
            ShortBuffer newVerts = BufferUtils.createShortBuffer(position + required);
            if (buffer != null) {
                buffer.flip();
                newVerts.put(buffer);
                newVerts.position(position);
            }
            buffer = newVerts;
        }
        return buffer;
    }

    public static ByteBuffer ensureLargeEnough(ByteBuffer buffer, int required) {
        if (buffer == null || buffer.remaining() < required) {
            int position = buffer != null ? buffer.position() : 0;
            ByteBuffer newVerts = BufferUtils.createByteBuffer(position + required);
            if (buffer != null) {
                buffer.flip();
                newVerts.put(buffer);
                newVerts.position(position);
            }
            buffer = newVerts;
        }
        return buffer;
    }

    public static void printCurrentDirectMemory(StringBuilder store) {
        boolean printStout;
        long totalHeld = 0L;
        long heapMem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        boolean bl = printStout = store == null;
        if (store == null) {
            store = new StringBuilder();
        }
        if (trackDirectMemory) {
            int fBufs = 0;
            int bBufs = 0;
            int iBufs = 0;
            int sBufs = 0;
            int dBufs = 0;
            int fBufsM = 0;
            int bBufsM = 0;
            int iBufsM = 0;
            int sBufsM = 0;
            int dBufsM = 0;
            for (BufferInfo b : trackedBuffers.values()) {
                if (b.type == ByteBuffer.class) {
                    totalHeld += (long)b.size;
                    bBufsM += b.size;
                    ++bBufs;
                    continue;
                }
                if (b.type == FloatBuffer.class) {
                    totalHeld += (long)b.size;
                    fBufsM += b.size;
                    ++fBufs;
                    continue;
                }
                if (b.type == IntBuffer.class) {
                    totalHeld += (long)b.size;
                    iBufsM += b.size;
                    ++iBufs;
                    continue;
                }
                if (b.type == ShortBuffer.class) {
                    totalHeld += (long)b.size;
                    sBufsM += b.size;
                    ++sBufs;
                    continue;
                }
                if (b.type != DoubleBuffer.class) continue;
                totalHeld += (long)b.size;
                dBufsM += b.size;
                ++dBufs;
            }
            store.append("Existing buffers: ").append(trackedBuffers.size()).append("\n");
            store.append("(b: ").append(bBufs).append("  f: ").append(fBufs).append("  i: ").append(iBufs).append("  s: ").append(sBufs).append("  d: ").append(dBufs).append(")").append("\n");
            store.append("Total   heap memory held: ").append(heapMem / 1024L).append("kb\n");
            store.append("Total direct memory held: ").append(totalHeld / 1024L).append("kb\n");
            store.append("(b: ").append(bBufsM / 1024).append("kb  f: ").append(fBufsM / 1024).append("kb  i: ").append(iBufsM / 1024).append("kb  s: ").append(sBufsM / 1024).append("kb  d: ").append(dBufsM / 1024).append("kb)").append("\n");
        } else {
            store.append("Total   heap memory held: ").append(heapMem / 1024L).append("kb\n");
            store.append("Only heap memory available, if you want to monitor direct memory use BufferUtils.setTrackDirectMemoryEnabled(true) during initialization.").append("\n");
        }
        if (printStout) {
            System.out.println(store.toString());
        }
    }

    private static Method loadMethod(String className, String methodName) {
        try {
            Method method = Class.forName(className).getMethod(methodName, new Class[0]);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (SecurityException ex) {
            return null;
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadCleanerMethods() {
        if (loadedMethods.getAndSet(true)) {
            return;
        }
        AtomicBoolean atomicBoolean = loadedMethods;
        synchronized (atomicBoolean) {
            cleanerMethod = BufferUtils.loadMethod("sun.nio.ch.DirectBuffer", "cleaner");
            cleanMethod = BufferUtils.loadMethod("sun.misc.Cleaner", "clean");
            viewedBufferMethod = BufferUtils.loadMethod("sun.nio.ch.DirectBuffer", "viewedBuffer");
            if (viewedBufferMethod == null) {
                viewedBufferMethod = BufferUtils.loadMethod("sun.nio.ch.DirectBuffer", "attachment");
            }
            ByteBuffer bb = BufferUtils.createByteBuffer(1);
            Class<?> clazz = bb.getClass();
            try {
                freeMethod = clazz.getMethod("free", new Class[0]);
            }
            catch (NoSuchMethodException ex) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public static void destroyDirectBuffer(Buffer toBeDestroyed) {
        if (!toBeDestroyed.isDirect()) {
            return;
        }
        BufferUtils.loadCleanerMethods();
        try {
            if (freeMethod != null) {
                freeMethod.invoke((Object)toBeDestroyed, new Object[0]);
            } else {
                Object cleaner = cleanerMethod.invoke((Object)toBeDestroyed, new Object[0]);
                if (cleaner != null) {
                    cleanMethod.invoke(cleaner, new Object[0]);
                } else {
                    Object viewedBuffer = viewedBufferMethod.invoke((Object)toBeDestroyed, new Object[0]);
                    if (viewedBuffer != null) {
                        BufferUtils.destroyDirectBuffer((Buffer)viewedBuffer);
                    } else {
                        Logger.getLogger(BufferUtils.class.getName()).log(Level.SEVERE, "Buffer cannot be destroyed: {0}", toBeDestroyed);
                    }
                }
            }
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(BufferUtils.class.getName()).log(Level.SEVERE, "{0}", ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(BufferUtils.class.getName()).log(Level.SEVERE, "{0}", ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(BufferUtils.class.getName()).log(Level.SEVERE, "{0}", ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(BufferUtils.class.getName()).log(Level.SEVERE, "{0}", ex);
        }
    }

    static {
        loadedMethods = new AtomicBoolean(false);
        cleanerMethod = null;
        cleanMethod = null;
        viewedBufferMethod = null;
        freeMethod = null;
    }

    private static class ClearReferences
    extends Thread {
        ClearReferences() {
            this.setDaemon(true);
        }

        public void run() {
            try {
                while (true) {
                    Reference toclean = removeCollected.remove();
                    trackedBuffers.remove(toclean);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BufferInfo
    extends PhantomReference<Buffer> {
        private Class type;
        private int size;

        public BufferInfo(Class type, int size, Buffer referent, ReferenceQueue<? super Buffer> q) {
            super(referent, q);
            this.type = type;
            this.size = size;
        }
    }
}

