/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture.image;

import com.jme3.texture.image.ImageCodec;
import java.nio.ByteBuffer;

class BitMaskImageCodec
extends ImageCodec {
    final int as;
    final int rs;
    final int gs;
    final int bs;
    boolean be = false;

    public BitMaskImageCodec(int bpp, int flags, int ac, int rc, int gc, int bc, int as, int rs, int gs, int bs) {
        super(bpp, flags, (int)((1L << ac) - 1L), (int)((1L << rc) - 1L), (int)((1L << gc) - 1L), (int)((1L << bc) - 1L));
        if (bpp > 4) {
            throw new UnsupportedOperationException("Use ByteAlignedImageCodec for codecs with pixel sizes larger than 4 bytes");
        }
        this.as = as;
        this.rs = rs;
        this.gs = gs;
        this.bs = bs;
    }

    private static int readPixelRaw(ByteBuffer buf, int idx, int bpp) {
        idx += bpp;
        int original = buf.get(--idx) & 0xFF;
        while (--bpp > 0) {
            original = original << 8 | buf.get(--idx) & 0xFF;
        }
        return original;
    }

    private void writePixelRaw(ByteBuffer buf, int idx, int pixel, int bpp) {
        while (--bpp >= 0) {
            byte bt = (byte)(pixel >> bpp * 8 & 0xFF);
            buf.put(idx + bpp, bt);
        }
    }

    public void readComponents(ByteBuffer buf, int x, int y, int width, int[] components, byte[] tmp) {
        int inputPixel = BitMaskImageCodec.readPixelRaw(buf, (x + y * width) * this.bpp, this.bpp);
        components[0] = inputPixel >> this.as & this.maxAlpha;
        components[1] = inputPixel >> this.rs & this.maxRed;
        components[2] = inputPixel >> this.gs & this.maxGreen;
        components[3] = inputPixel >> this.bs & this.maxBlue;
    }

    public void writeComponents(ByteBuffer buf, int x, int y, int width, int[] components, byte[] tmp) {
        int outputPixel = (components[0] & this.maxAlpha) << this.as | (components[1] & this.maxRed) << this.rs | (components[2] & this.maxGreen) << this.gs | (components[3] & this.maxBlue) << this.bs;
        this.writePixelRaw(buf, (x + y * width) * this.bpp, outputPixel, this.bpp);
    }
}

