/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.AssetManager;
import com.jme3.asset.cache.AssetCache;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLSLLoader
implements AssetLoader {
    private AssetManager owner;
    private Map<String, DependencyNode> dependCache = new HashMap<String, DependencyNode>();

    private DependencyNode loadNode(InputStream in, String nodeName) throws IOException {
        DependencyNode node = new DependencyNode(nodeName);
        if (in == null) {
            throw new IOException("Dependency " + nodeName + " cannot be found.");
        }
        StringBuilder sb = new StringBuilder();
        BufferedReader r = new BufferedReader(new InputStreamReader(in));
        while (r.ready()) {
            String ln = r.readLine();
            if (ln.startsWith("#import ")) {
                if (!(ln = ln.substring(8).trim()).startsWith("\"") || !ln.endsWith("\"") || ln.length() <= 3) continue;
                if ((ln = ln.substring(1, ln.length() - 1)).equals(nodeName)) {
                    throw new IOException("Node depends on itself.");
                }
                DependencyNode dependNode = this.dependCache.get(ln);
                if (dependNode == null) {
                    GlslDependKey key = new GlslDependKey(ln);
                    InputStream stream = this.owner.loadAsset(key);
                    dependNode = this.loadNode(stream, ln);
                }
                node.addDependency(dependNode);
                continue;
            }
            sb.append(ln).append('\n');
        }
        r.close();
        node.setSource(sb.toString());
        this.dependCache.put(nodeName, node);
        return node;
    }

    private DependencyNode nextIndependentNode(List<DependencyNode> checkedNodes) {
        Collection<DependencyNode> allNodes = this.dependCache.values();
        if (allNodes == null || allNodes.isEmpty()) {
            return null;
        }
        for (DependencyNode node : allNodes) {
            if (!node.dependsOn.isEmpty()) continue;
            return node;
        }
        for (DependencyNode node : allNodes) {
            System.out.println(node.shaderName);
        }
        throw new RuntimeException("Circular dependency.");
    }

    private String resolveDependencies(DependencyNode root) {
        DependencyNode indepnNode;
        StringBuilder sb = new StringBuilder();
        ArrayList<DependencyNode> checkedNodes = new ArrayList<DependencyNode>();
        checkedNodes.add(root);
        while ((indepnNode = this.nextIndependentNode(checkedNodes)) != null) {
            sb.append(indepnNode.shaderSource).append('\n');
            this.dependCache.remove(indepnNode.shaderName);
            Iterator iter = indepnNode.dependOnMe.iterator();
            while (iter.hasNext()) {
                DependencyNode dependNode = (DependencyNode)iter.next();
                iter.remove();
                dependNode.dependsOn.remove(indepnNode);
            }
        }
        return sb.toString();
    }

    @Override
    public Object load(AssetInfo info) throws IOException {
        this.owner = info.getManager();
        if (info.getKey().getExtension().equals("glsllib")) {
            return info.openStream();
        }
        DependencyNode rootNode = this.loadNode(info.openStream(), "[main]");
        String code = this.resolveDependencies(rootNode);
        this.dependCache.clear();
        return code;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GlslDependKey
    extends AssetKey<InputStream> {
        public GlslDependKey(String name) {
            super(name);
        }

        @Override
        public Class<? extends AssetCache> getCacheType() {
            return null;
        }
    }

    private class DependencyNode {
        private String shaderSource;
        private String shaderName;
        private final Set<DependencyNode> dependsOn = new HashSet<DependencyNode>();
        private final Set<DependencyNode> dependOnMe = new HashSet<DependencyNode>();

        public DependencyNode(String shaderName) {
            this.shaderName = shaderName;
        }

        public void setSource(String source) {
            this.shaderSource = source;
        }

        public void addDependency(DependencyNode node) {
            if (this.dependsOn.contains(node)) {
                return;
            }
            this.dependsOn.add(node);
            node.dependOnMe.add(this);
        }
    }
}

