/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader;

import com.jme3.asset.AssetKey;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.shader.DefineList;
import com.jme3.shader.Shader;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShaderKey
extends AssetKey<Shader> {
    protected String fragName;
    protected DefineList defines;
    protected String vertLanguage;
    protected String fragLanguage;

    public ShaderKey() {
    }

    public ShaderKey(String vertName, String fragName, DefineList defines, String vertLanguage, String fragLanguage) {
        super(vertName);
        this.fragName = fragName;
        this.defines = defines;
        this.vertLanguage = vertLanguage;
        this.fragLanguage = fragLanguage;
    }

    @Override
    public String toString() {
        return "V=" + this.name + " F=" + this.fragName + (this.defines != null ? this.defines : "");
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShaderKey other = (ShaderKey)obj;
        if (this.name.equals(other.name) && this.fragName.equals(other.fragName)) {
            if (this.defines != null && other.defines != null) {
                return this.defines.getCompiled().equals(other.defines.getCompiled());
            }
            return this.defines == null && other.defines == null;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + this.name.hashCode();
        hash = 41 * hash + this.fragName.hashCode();
        hash = 41 * hash + (this.defines != null ? this.defines.getCompiled().hashCode() : 0);
        return hash;
    }

    public DefineList getDefines() {
        return this.defines;
    }

    public String getVertName() {
        return this.name;
    }

    public String getFragName() {
        return this.fragName;
    }

    @Deprecated
    public String getLanguage() {
        return this.vertLanguage;
    }

    public String getVertexShaderLanguage() {
        return this.vertLanguage;
    }

    public String getFragmentShaderLanguage() {
        return this.fragLanguage;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.fragName, "fragment_name", null);
        oc.write(this.vertLanguage, "language", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.fragName = ic.readString("fragment_name", null);
        this.vertLanguage = ic.readString("language", null);
    }
}

