/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input;

import com.jme3.input.InputManager;
import com.jme3.input.JoyInput;
import com.jme3.input.controls.JoyAxisTrigger;
import com.jme3.input.controls.JoyButtonTrigger;

public final class Joystick {
    private InputManager inputManager;
    private JoyInput joyInput;
    private int joyId;
    private int buttonCount;
    private int axisCount;
    private int axisXIndex;
    private int axisYIndex;
    private String name;

    public Joystick(InputManager inputManager, JoyInput joyInput, int joyId, String name, int buttonCount, int axisCount, int xAxis, int yAxis) {
        this.inputManager = inputManager;
        this.joyInput = joyInput;
        this.joyId = joyId;
        this.name = name;
        this.buttonCount = buttonCount;
        this.axisCount = axisCount;
        this.axisXIndex = xAxis;
        this.axisYIndex = yAxis;
    }

    public void rumble(float amount) {
        this.joyInput.setJoyRumble(this.joyId, amount);
    }

    public void assignButton(String mappingName, int buttonId) {
        if (buttonId < 0 || buttonId >= this.buttonCount) {
            throw new IllegalArgumentException();
        }
        this.inputManager.addMapping(mappingName, new JoyButtonTrigger(this.joyId, buttonId));
    }

    public void assignAxis(String positiveMapping, String negativeMapping, int axisId) {
        this.inputManager.addMapping(positiveMapping, new JoyAxisTrigger(this.joyId, axisId, false));
        this.inputManager.addMapping(negativeMapping, new JoyAxisTrigger(this.joyId, axisId, true));
    }

    public int getXAxisIndex() {
        return this.axisXIndex;
    }

    public int getYAxisIndex() {
        return this.axisYIndex;
    }

    public int getAxisCount() {
        return this.axisCount;
    }

    public int getButtonCount() {
        return this.buttonCount;
    }

    public String getName() {
        return this.name;
    }

    public int getJoyId() {
        return this.joyId;
    }

    public String toString() {
        return "Joystick[name=" + this.name + ", id=" + this.joyId + ", buttons=" + this.buttonCount + ", axes=" + this.axisCount + "]";
    }
}

