/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.animation;

import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimControl;
import com.jme3.animation.AnimEventListener;
import com.jme3.animation.ClonableTrack;
import com.jme3.animation.Track;
import com.jme3.animation.TrackInfo;
import com.jme3.effect.ParticleEmitter;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import com.jme3.util.TempVars;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EffectTrack
implements ClonableTrack {
    private static final Logger logger = Logger.getLogger(EffectTrack.class.getName());
    private ParticleEmitter emitter;
    private float startOffset = 0.0f;
    private float particlesPerSeconds = 0.0f;
    private float length = 0.0f;
    private boolean emitted = false;
    private boolean initialized = false;
    private boolean stopRequested = false;
    private AbstractControl killParticles = new AbstractControl(){

        protected void controlUpdate(float tpf) {
            if (EffectTrack.this.emitter.getNumVisibleParticles() == 0) {
                EffectTrack.this.emitter.setCullHint(Spatial.CullHint.Always);
                EffectTrack.this.emitter.setEnabled(false);
                EffectTrack.this.emitter.removeControl(EffectTrack.this.killParticles);
                EffectTrack.this.stopRequested = false;
            }
        }

        protected void controlRender(RenderManager rm, ViewPort vp) {
        }

        public Control cloneForSpatial(Spatial spatial) {
            return null;
        }
    };

    public EffectTrack() {
    }

    public EffectTrack(ParticleEmitter emitter, float length) {
        this.emitter = emitter;
        this.particlesPerSeconds = emitter.getParticlesPerSec();
        this.emitter.setParticlesPerSec(0.0f);
        this.length = length;
        this.setUserData(this);
    }

    public EffectTrack(ParticleEmitter emitter, float length, float startOffset) {
        this(emitter, length);
        this.startOffset = startOffset;
    }

    public void setTime(float time, float weight, AnimControl control, AnimChannel channel, TempVars vars) {
        if (!this.initialized) {
            control.addListener(new OnEndListener());
            this.initialized = true;
        }
        if (!this.emitted && time >= this.startOffset) {
            this.emitted = true;
            this.emitter.setCullHint(Spatial.CullHint.Dynamic);
            this.emitter.setEnabled(true);
            if (this.particlesPerSeconds == 0.0f) {
                this.emitter.emitAllParticles();
                if (!this.stopRequested) {
                    this.emitter.addControl(this.killParticles);
                    this.stopRequested = true;
                }
            } else {
                this.emitter.setParticlesPerSec(this.particlesPerSeconds);
            }
        }
    }

    private void stop() {
        this.emitter.setParticlesPerSec(0.0f);
        this.emitted = false;
        if (!this.stopRequested) {
            this.emitter.addControl(this.killParticles);
            this.stopRequested = true;
        }
    }

    public float getLength() {
        return this.length;
    }

    public Track clone() {
        return new EffectTrack(this.emitter, this.length, this.startOffset);
    }

    public Track cloneForSpatial(Spatial spatial) {
        EffectTrack effectTrack = new EffectTrack();
        effectTrack.particlesPerSeconds = this.particlesPerSeconds;
        effectTrack.length = this.length;
        effectTrack.startOffset = this.startOffset;
        effectTrack.emitter = this.findEmitter(spatial);
        if (effectTrack.emitter == null) {
            logger.log(Level.WARNING, "{0} was not found in {1} or is not bound to this track", new Object[]{this.emitter.getName(), spatial.getName()});
            effectTrack.emitter = this.emitter;
        }
        this.setUserData(effectTrack);
        effectTrack.emitter.setParticlesPerSec(0.0f);
        return effectTrack;
    }

    private ParticleEmitter findEmitter(Spatial spat) {
        if (spat instanceof ParticleEmitter) {
            ParticleEmitter em = (ParticleEmitter)spat;
            TrackInfo t = (TrackInfo)em.getUserData("TrackInfo");
            if (t != null && t.getTracks().contains(this)) {
                return em;
            }
            return null;
        }
        if (spat instanceof Node) {
            for (Spatial child : ((Node)spat).getChildren()) {
                ParticleEmitter em = this.findEmitter(child);
                if (em == null) continue;
                return em;
            }
        }
        return null;
    }

    public void cleanUp() {
        TrackInfo t = (TrackInfo)this.emitter.getUserData("TrackInfo");
        t.getTracks().remove(this);
        if (!t.getTracks().isEmpty()) {
            this.emitter.setUserData("TrackInfo", null);
        }
    }

    public ParticleEmitter getEmitter() {
        return this.emitter;
    }

    public void setEmitter(ParticleEmitter emitter) {
        if (this.emitter != null) {
            TrackInfo data = (TrackInfo)emitter.getUserData("TrackInfo");
            data.getTracks().remove(this);
        }
        this.emitter = emitter;
        this.setUserData(this);
    }

    public float getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(float startOffset) {
        this.startOffset = startOffset;
    }

    private void setUserData(EffectTrack effectTrack) {
        TrackInfo data = (TrackInfo)effectTrack.emitter.getUserData("TrackInfo");
        if (data == null) {
            data = new TrackInfo();
            effectTrack.emitter.setUserData("TrackInfo", data);
        }
        data.addTrack(effectTrack);
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule out = ex.getCapsule(this);
        this.emitter.setParticlesPerSec(this.particlesPerSeconds);
        this.emitter.removeControl(this.killParticles);
        out.write(this.emitter, "emitter", null);
        out.write(this.particlesPerSeconds, "particlesPerSeconds", 0.0f);
        out.write(this.length, "length", 0.0f);
        out.write(this.startOffset, "startOffset", 0.0f);
        this.emitter.setParticlesPerSec(0.0f);
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule in = im.getCapsule(this);
        this.particlesPerSeconds = in.readFloat("particlesPerSeconds", 0.0f);
        this.emitter = (ParticleEmitter)in.readSavable("emitter", null);
        this.emitter.setParticlesPerSec(0.0f);
        this.length = in.readFloat("length", this.length);
        this.startOffset = in.readFloat("startOffset", 0.0f);
    }

    private class OnEndListener
    implements AnimEventListener {
        private OnEndListener() {
        }

        public void onAnimCycleDone(AnimControl control, AnimChannel channel, String animName) {
            EffectTrack.this.stop();
        }

        public void onAnimChange(AnimControl control, AnimChannel channel, String animName) {
            EffectTrack.this.stop();
        }
    }
}

